/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.filter;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.pf.common.api.filter.PatternAndRequestType;
import com.pingidentity.pf.common.api.filter.XsrfFilter;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;

public class AdminXsrfFilter
extends XsrfFilter
implements ContainerRequestFilter {
    private static final Pattern CERT_PATTERN = Pattern.compile("/keyPairs/signing/[^/]+/certificate");
    private static final Pattern CSR_PATTERN = Pattern.compile("/keyPairs/signing/[^/]+/csr");
    private static final Pattern SSL_SERVER_CERT_PATTERN = Pattern.compile("/keyPairs/sslServer/[^/]+/certificate");
    private static final Pattern SSL_SERVER_CSR_PATTERN = Pattern.compile("/keyPairs/sslServer/[^/]+/csr");
    private static final Pattern SSL_CLIENT_CERT_PATTERN = Pattern.compile("/keyPairs/sslClient/[^/]+/certificate");
    private static final Pattern SSL_CLIENT_CSR_PATTERN = Pattern.compile("/keyPairs/sslClient/[^/]+/csr");
    private static final Pattern TRUSTED_CERTIFICATE_AUTHORITIES_PATTERN = Pattern.compile("/certificates/ca/[^/]+/file");
    private static final Pattern CONFIG_ARCHIVE_EXPORT_PATTERN = Pattern.compile("/configArchive/export");
    private static final Pattern METADATA_EXPORT_PATTERN = Pattern.compile("/connectionMetadata/export");
    private static final Pattern METADATA_CONVERT_PATTERN = Pattern.compile("/connectionMetadata/convert");
    private static final List<PatternAndRequestType> EXEMPT_PATTERNS = Arrays.asList(new PatternAndRequestType(CERT_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(CERT_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(CSR_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(SSL_SERVER_CSR_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(SSL_SERVER_CERT_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(SSL_CLIENT_CERT_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(SSL_CLIENT_CSR_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(TRUSTED_CERTIFICATE_AUTHORITIES_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(CONFIG_ARCHIVE_EXPORT_PATTERN, PatternAndRequestType.RequestType.GET), new PatternAndRequestType(METADATA_EXPORT_PATTERN, PatternAndRequestType.RequestType.POST), new PatternAndRequestType(METADATA_CONVERT_PATTERN, PatternAndRequestType.RequestType.POST));
    @Context
    private HttpServletRequest servletRequest;

    public ContainerRequest filter(ContainerRequest containerRequest) {
        if (ApiUtil.isApiDocsRequest(this.servletRequest)) {
            return containerRequest;
        }
        return super.filter(containerRequest);
    }

    protected List<PatternAndRequestType> getExemptPaths() {
        return EXEMPT_PATTERNS;
    }

    protected boolean isPathExempt(String path, String requestType) {
        return super.isPathExempt(path, requestType);
    }
}

