/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pingidentity.session.ApiAccessTokenException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.JwtIssuer;
import org.sourceid.saml20.domain.mgmt.impl.OAuth2AdministrativeUser;
import org.sourceid.saml20.domain.util.AdminAuthUtil;
import org.sourceid.util.JsonPointerExpressionEvaluator;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.AuditLogger;

public class JwtAdminAuthHandler {
    private static final Log log = LogFactory.getLog(JwtAdminAuthHandler.class);
    private final AdminUserManager adminUserManager;
    private final ObjectMapper mapper;
    private static final String JSON_PATH_PREFIX = "/";
    private final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.pf.admin.rest.filter.JwtAdminAuthHandler");
    private final int engineCacheExpirySecs = this.configStore.getIntValue("cacheExpirySecs", 30);
    private final long maximumSize = this.configStore.getLongValue("maximumSize", 1000L);
    private final LoadingCache<String, Optional<OAuth2AdministrativeUser>> adminApiAccessTokenCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.engineCacheExpirySecs, TimeUnit.SECONDS).maximumSize(this.maximumSize).build((CacheLoader)new CacheLoader<String, Optional<OAuth2AdministrativeUser>>(){

        public Optional<OAuth2AdministrativeUser> load(String accessToken) throws ApiAccessTokenException {
            return Optional.ofNullable(JwtAdminAuthHandler.this.validateJwtWithJwks(accessToken));
        }
    });
    private static final JwtAdminAuthHandler instance = new JwtAdminAuthHandler(MgmtFactory.getAdminApiUserManager(), ObjectMapperFactory.buildObjectMapper());

    private JwtAdminAuthHandler(AdminUserManager adminUserManager, ObjectMapper objectMapper) {
        this.adminUserManager = adminUserManager;
        this.mapper = objectMapper;
    }

    public static JwtAdminAuthHandler getInstance() {
        return instance;
    }

    public synchronized OAuth2AdministrativeUser validateJwt(String accessToken) throws ApiAccessTokenException {
        try {
            OAuth2AdministrativeUser user = null;
            if (accessToken != null && (user = (OAuth2AdministrativeUser)((Optional)this.adminApiAccessTokenCache.get((Object)accessToken)).orElse(null)) != null && user.hasExpired()) {
                this.adminApiAccessTokenCache.invalidate((Object)accessToken);
                user = null;
            }
            return user;
        }
        catch (ExecutionException e) {
            throw new ApiAccessTokenException(e.getMessage());
        }
    }

    private synchronized OAuth2AdministrativeUser validateJwtWithJwks(String accessToken) throws ApiAccessTokenException {
        if (StringUtils.isBlank((String)accessToken)) {
            log.debug((Object)"Access token is blank.");
            return null;
        }
        AuditLogger.setEvent((String)"Admin API Access Token");
        AuditLogger.setProtocol((String)"OAuth20");
        AuditLogger.setRole((String)"RS");
        AuditLogger.setInAccessTokenHash((String)accessToken);
        JwtIssuer jwtIssuer = this.adminUserManager.getJwtIssuer(accessToken);
        if (jwtIssuer != null) {
            try {
                HttpsJwks httpsJwks = HttpsJwksCache.getInstance().getJwks(jwtIssuer.getJwksUri());
                JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setRequireExpirationTime().setRequireIssuedAt().setVerificationKeyResolver((VerificationKeyResolver)new HttpsJwksVerificationKeyResolver(httpsJwks)).setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
                if (StringUtils.isNotBlank((String)jwtIssuer.getAudience())) {
                    jwtConsumerBuilder.setExpectedAudience(new String[]{jwtIssuer.getAudience()});
                } else {
                    jwtConsumerBuilder.setSkipDefaultAudienceValidation();
                }
                JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
                JwtClaims jwtClaims = jwtConsumer.processToClaims(accessToken);
                if (jwtClaims.getJwtId() != null) {
                    AuditLogger.setRequestJti((String)jwtClaims.getJwtId());
                }
                return this.createAdminUser(jwtClaims, jwtIssuer);
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                log.debug((Object)"Unable to process JWT claims.", e);
            }
        }
        return null;
    }

    private OAuth2AdministrativeUser createAdminUser(JwtClaims jwtClaims, JwtIssuer jwtIssuer) throws ApiAccessTokenException {
        String claimsJson = jwtClaims.toJson();
        Object username = this.getAttributeValue(jwtClaims, claimsJson, jwtIssuer.getUsernameAttribute());
        if (!(username instanceof String)) {
            String err = "Unable to extract the username from JWT token.";
            log.debug((Object)err);
            throw new ApiAccessTokenException(err);
        }
        try {
            AdminAuthUtil.validateScopes((Object)jwtClaims.getClaimValue(Parameters.SCOPE), (Collection)jwtIssuer.getRequiredScopes());
            Object roleValue = this.getAttributeValue(jwtClaims, claimsJson, jwtIssuer.getRoleSearchAttribute());
            if (roleValue == null) {
                log.debug((Object)"Role attribute not found in JWT token.");
            }
            if (roleValue instanceof Collection && ((Collection)roleValue).isEmpty()) {
                log.debug((Object)"Role attribute is empty in JWT token.");
            }
            if (roleValue instanceof String[] && ((String[])roleValue).length == 0) {
                log.debug((Object)"Role attribute is empty in JWT token.");
            }
            HashMap<String, Object> additionalUserInfo = new HashMap<String, Object>();
            if (roleValue != null) {
                additionalUserInfo.put(jwtIssuer.getRoleSearchAttribute(), roleValue);
            }
            return AdminAuthUtil.createActiveOAuthAdminUser((String)((String)username), (Map)jwtClaims.getClaimsMap(), additionalUserInfo, (String)jwtIssuer.getRoleSearchAttribute(), (Map)this.adminUserManager.getRoleMap());
        }
        catch (IOException e) {
            throw new ApiAccessTokenException("OAuth2 access token does not contain the required scopes.");
        }
    }

    private Object getAttributeValue(JwtClaims jwtClaims, String claimsJson, String attributeName) {
        if (attributeName.startsWith(JSON_PATH_PREFIX)) {
            return this.getValueFromJsonPointer(claimsJson, attributeName);
        }
        return jwtClaims.getClaimValue(attributeName);
    }

    private Object getValueFromJsonPointer(String claimsJson, String jsonPointer) {
        try {
            Object value = JsonPointerExpressionEvaluator.evaluateJsonPointer((String)claimsJson, (String)jsonPointer);
            if (value instanceof TextNode) {
                return ((TextNode)value).textValue();
            }
            if (value instanceof ArrayNode) {
                return this.mapper.readValue(value.toString(), (TypeReference)new TypeReference<Object>(){});
            }
            log.debug((Object)("Unsupported type for attribute at: " + jsonPointer));
            return null;
        }
        catch (JsonProcessingException e) {
            log.error((Object)("Error processing JSON pointer expression: " + jsonPointer), (Throwable)e);
            return null;
        }
    }
}

