/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.filter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.audit.ApiAuditLogger;
import com.pingidentity.pf.common.api.model.ApiResult;
import com.pingidentity.pf.common.api.model.CommonApiResultFactory;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import com.pingidentity.session.ApiAccessTokenException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.lang.JoseException;
import org.sourceid.common.Util;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.client.ClientAuthSupport;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.validate.admin.auth.OAuth2AdminApiAuthValidator;
import org.sourceid.oauth20.validate.admin.auth.OAuth2AdminAuthValidator;
import org.sourceid.openid.connect.domain.OAuthClientTokenValidateConnection;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.OAuth2AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.SecretReferenceHelper;
import org.sourceid.saml20.domain.util.AdminAuthUtil;
import org.sourceid.util.ObjectMapperFactory;

public class OAuth2AdminAuthHandler {
    private static final Log log = LogFactory.getLog(OAuth2AdminAuthHandler.class);
    private final ApiAuditLogger auditLogger = ApiAuditLogger.getInstance((String)"AdminApiAuditLogger");
    private static final AdminUserManager adminUserManager = MgmtFactory.getAdminApiUserManager();
    private static final OAuth2AdminAuthValidator validator = new OAuth2AdminApiAuthValidator();
    private final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.pf.admin.rest.filter.OAuth2AdminAuthHandler");
    private final int engineCacheExpirySecs = this.configStore.getIntValue("cacheExpirySecs", 30);
    private final long maximumSize = this.configStore.getLongValue("maximumSize", 1000L);
    private static OAuth2AdminAuthHandler instance = new OAuth2AdminAuthHandler();
    private LoadingCache<String, Optional<OAuth2AdministrativeUser>> engineCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.engineCacheExpirySecs, TimeUnit.SECONDS).maximumSize(this.maximumSize).build((CacheLoader)new CacheLoader<String, Optional<OAuth2AdministrativeUser>>(){

        public Optional<OAuth2AdministrativeUser> load(String accessToken) throws ApiAccessTokenException {
            return Optional.ofNullable(OAuth2AdminAuthHandler.this.validateToken(accessToken));
        }
    });

    public static OAuth2AdminAuthHandler getInstance() {
        return instance;
    }

    public synchronized OAuth2AdministrativeUser validateOAuthAccessToken(String accessToken) throws ApiAccessTokenException {
        try {
            OAuth2AdministrativeUser user = null;
            if (accessToken != null && (user = (OAuth2AdministrativeUser)((Optional)this.engineCache.get((Object)accessToken)).orElse(null)) != null && user.hasExpired()) {
                this.engineCache.invalidate((Object)accessToken);
                user = null;
            }
            return user;
        }
        catch (ExecutionException e) {
            throw new ApiAccessTokenException(e.getMessage());
        }
    }

    private OAuth2AdministrativeUser validateToken(String accessToken) throws ApiAccessTokenException {
        OAuth2AdministrativeUser administrativeUser = null;
        try {
            if (accessToken != null) {
                OAuthClientTokenValidateConnection clientConnection = (OAuthClientTokenValidateConnection)adminUserManager.getConnection();
                if (!validator.validateValue(clientConnection.getIntrospectionEndpoint(), true, true, "Introspection Endpoint")) {
                    throw new ApiAccessTokenException("Invalid introspection endpoint.");
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", accessToken);
                HttpPost post = new HttpPost(clientConnection.getIntrospectionEndpoint());
                this.generateRequestObject(clientConnection, params, post);
                UrlEncodedFormEntity urlEntity = new UrlEncodedFormEntity((Iterable)params.entrySet().stream().map(entity -> new BasicNameValuePair((String)entity.getKey(), (String)entity.getValue())).collect(Collectors.toList()), Consts.UTF_8);
                post.setEntity((HttpEntity)urlEntity);
                String responseStream = HttpConnectionPoolingManager.getInstance().doRequest((HttpRequestBase)post);
                Map adminUserInfo = (Map)ObjectMapperFactory.buildObjectMapper().readValue(responseStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (adminUserInfo.containsKey(adminUserManager.getUsernameAttributeName())) {
                    if (!((Boolean)adminUserInfo.get("active")).booleanValue()) {
                        throw new ApiAccessTokenException("Cannot process an inactive OAuth2 access token.");
                    }
                } else {
                    throw new ApiAccessTokenException("Unable to extract administrator username from OAuth2 access token.");
                }
                AdminAuthUtil.validateScopes(adminUserInfo.get(Parameters.SCOPE), (Collection)clientConnection.getScopes());
                String userName = adminUserInfo.get(adminUserManager.getUsernameAttributeName()).toString();
                administrativeUser = AdminAuthUtil.createActiveOAuthAdminUser((String)userName, (Map)adminUserInfo, (String)adminUserManager.getRoleAttributeName(), (Map)adminUserManager.getRoleMap());
                log.info((Object)("Access Token:" + responseStream));
            }
        }
        catch (IOException | BindingException e) {
            validator.validate();
            log.error((Object)("Unexpected error while calling OAuth2 introspection endpoint: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            ApiResult result = CommonApiResultFactory.create((CommonApiMsgKey)CommonApiMsgKey.token_invalid);
            result.setMessage(e.getMessage());
        }
        return administrativeUser;
    }

    private void generateRequestObject(OAuthClientTokenValidateConnection clientConnection, Map<String, String> params, HttpPost post) throws ApiAccessTokenException, BindingException {
        if ("client_secret_basic".equals(clientConnection.getClientAuthType()) || "client_secret_post".equals(clientConnection.getClientAuthType())) {
            if (clientConnection.getClientSecret() == null) {
                throw new ApiAccessTokenException("Unable to send request to Introspection endpoint. client_secret cannot be empty");
            }
            String client = clientConnection.getClientId();
            String password = clientConnection.getClientSecret().getStrValue();
            if (SecretReferenceUtil.isSecretReference((String)password)) {
                try {
                    SecretReferenceHelper secretReferenceHelper = new SecretReferenceHelper(password);
                    SecretReferenceHelper.Credentials credentials = secretReferenceHelper.getSecretInfo(client);
                    password = credentials.getSecret();
                }
                catch (SecretManagerException e) {
                    throw new BindingException("Unable to obtain credentials.", (Throwable)e);
                }
            }
            if ("client_secret_basic".equals(clientConnection.getClientAuthType())) {
                String urlEncodedClient = Util.urlEncodeUTF8((String)client);
                String urlEncodedPassword = Util.urlEncodeUTF8((String)password);
                String clientIdPassword = urlEncodedClient + ":" + urlEncodedPassword;
                byte[] encodedBase64 = Base64.encodeBase64((byte[])clientIdPassword.getBytes(StandardCharsets.UTF_8));
                String value = "Basic " + new String(encodedBase64, StandardCharsets.UTF_8);
                post.setHeader("Authorization", value);
            } else {
                params.put(Parameters.CLIENT_ID, client);
                params.put(Parameters.CLIENT_SECRET, password);
            }
        } else {
            params.put(Parameters.CLIENT_ID, clientConnection.getClientId());
            if ("private_key_jwt".equals(clientConnection.getClientAuthType()) || "client_secret_jwt".equals(clientConnection.getClientAuthType())) {
                String signingAlgo = "client_secret_jwt".equals(clientConnection.getClientAuthType()) ? "HS256" : "RS256";
                String clientId = clientConnection.getClientId();
                JsonWebSignature jws = new JsonWebSignature();
                jws.setAlgorithmHeaderValue(signingAlgo);
                log.debug((Object)("client " + clientId + " jws algo is " + signingAlgo));
                JwtClaims claims = new JwtClaims();
                claims.setIssuer(clientId);
                claims.setSubject(clientId);
                claims.setAudience(clientConnection.getIntrospectionEndpoint());
                claims.setGeneratedJwtId();
                claims.setExpirationTimeMinutesInTheFuture(5.0f);
                claims.setIssuedAtToNow();
                jws.setPayload(claims.toJson());
                try {
                    this.auditLogger.setJti(claims.getJwtId());
                }
                catch (MalformedClaimException e) {
                    log.error((Object)("Unable to get jti from JWT request. Jti will not be included in the admin API audit log record for this transaction: " + e.getMessage()));
                    log.debug((Object)e);
                }
                try {
                    ClientAuthSupport.sign((JsonWebSignature)jws, (Log)log, (boolean)"private_key_jwt".equals(clientConnection.getClientAuthType()), (String)clientConnection.getClientSecret().getStrValue(), (boolean)false);
                    String jwt = jws.getCompactSerialization();
                    params.put(Parameters.CLIENT_ID, clientId);
                    params.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                    params.put("client_assertion", jwt);
                }
                catch (JoseException je) {
                    throw new BindingException("Failed to create JWT.");
                }
            }
        }
    }
}

