/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AdministrativeAccount;
import com.pingidentity.admin.api.model.AdministrativeRoleType;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class AdministrativeAccountTranslator {
    public static final String HASH_SALT_SEPARATOR = ":";

    public AdministrativeAccount domainToApi(AdministrativeUser domainUser) {
        if (domainUser == null) {
            return null;
        }
        AdministrativeAccount apiAccount = new AdministrativeAccount();
        apiAccount.setActive(domainUser.isActive());
        if (!domainUser.isAuditor()) {
            if (domainUser.isAdmin()) {
                apiAccount.getRoles().add(AdministrativeRoleType.ADMINISTRATOR);
            }
            if (domainUser.isAdminManager()) {
                apiAccount.getRoles().add(AdministrativeRoleType.USER_ADMINISTRATOR);
            }
            if (domainUser.isCryptoManager()) {
                apiAccount.getRoles().add(AdministrativeRoleType.CRYPTO_ADMINISTRATOR);
            }
            if (domainUser.isExpressionAdmin()) {
                apiAccount.getRoles().add(AdministrativeRoleType.EXPRESSION_ADMINISTRATOR);
            }
            if (domainUser.isDataCollectionAdmin()) {
                apiAccount.getRoles().add(AdministrativeRoleType.DATA_COLLECTION_ADMINISTRATOR);
            }
        }
        apiAccount.setAuditor(domainUser.getAuditor());
        apiAccount.setDepartment(domainUser.getDepartment());
        apiAccount.setDescription(domainUser.getDescription());
        apiAccount.setEmailAddress(domainUser.getEmailAddress());
        apiAccount.setPhoneNumber(domainUser.getPhoneNumber());
        apiAccount.setUsername(domainUser.getUserName());
        if (StringUtils.isBlank((String)domainUser.getSalt())) {
            apiAccount.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(domainUser.getHash()));
        } else {
            String hashSalted = domainUser.getHash() + HASH_SALT_SEPARATOR + domainUser.getSalt();
            apiAccount.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(hashSalted));
        }
        return apiAccount;
    }

    public AdministrativeUser apiToDomain(AdministrativeAccount apiAccount, boolean isCreate) {
        if (apiAccount == null) {
            return null;
        }
        AdministrativeUser domainAccount = new AdministrativeUser();
        domainAccount.setActive(apiAccount.isActive());
        domainAccount.setAuditor(apiAccount.isAuditor());
        if (!apiAccount.isAuditor() && apiAccount.getRoles() != null) {
            domainAccount.setAdmin(apiAccount.getRoles().contains((Object)AdministrativeRoleType.ADMINISTRATOR));
            domainAccount.setAdminManager(apiAccount.getRoles().contains((Object)AdministrativeRoleType.USER_ADMINISTRATOR));
            domainAccount.setCryptoManager(apiAccount.getRoles().contains((Object)AdministrativeRoleType.CRYPTO_ADMINISTRATOR));
            domainAccount.setExpressionAdmin(apiAccount.getRoles().contains((Object)AdministrativeRoleType.EXPRESSION_ADMINISTRATOR));
            domainAccount.setDataCollectionAdmin(apiAccount.getRoles().contains((Object)AdministrativeRoleType.DATA_COLLECTION_ADMINISTRATOR));
        }
        domainAccount.setDepartment(apiAccount.getDepartment());
        domainAccount.setDescription(apiAccount.getDescription());
        domainAccount.setEmailAddress(apiAccount.getEmailAddress());
        domainAccount.setPhoneNumber(apiAccount.getPhoneNumber());
        domainAccount.setUserName(apiAccount.getUsername());
        if (isCreate && StringUtils.isNotEmpty((String)apiAccount.getPassword())) {
            domainAccount.setPassword(apiAccount.getPassword());
        } else if (StringUtils.isNotEmpty((String)apiAccount.getEncryptedPassword())) {
            AdministrativeUser user;
            String hashedSalt = EncryptedFieldValidator.decryptCiphertext(apiAccount.getEncryptedPassword());
            domainAccount.setSalt("");
            String[] password = hashedSalt.split(HASH_SALT_SEPARATOR);
            domainAccount.setHash(password[0]);
            if (password.length > 1) {
                domainAccount.setSalt(password[1]);
            }
            if ((user = MgmtFactory.getNativeAdminUserManager().getUser(apiAccount.getUsername())) == null) {
                domainAccount.setChangeRequired(isCreate);
            } else {
                domainAccount.setChangeRequired(user.getChangeRequired());
            }
        }
        domainAccount.setLocalAccount(true);
        return domainAccount;
    }
}

