/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ApcMappingPolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicySelectionActionTranslator;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ApcMappingActionTranslator
extends AuthenticationPolicySelectionActionTranslator<ApcMappingPolicyAction, ApcMappingAction> {
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    @Override
    public PolicyAction domainToApi(ApcMappingAction domainAction) {
        ApcMappingPolicyAction apiApcMappingAction = super.domainToApi(new ApcMappingPolicyAction(), domainAction);
        String apcId = domainAction.getApcId();
        ResourceLink resourceLink = new ResourceLink();
        resourceLink.setId(apcId);
        resourceLink.setLocation(ApiUtil.getResourceUrl("/authenticationPolicyContracts", apcId));
        apiApcMappingAction.setAuthenticationPolicyContractRef(resourceLink);
        AttributeMapping domainAttributeMapping = domainAction.getAttributeMapping();
        com.pingidentity.admin.api.model.AttributeMapping apiAttributeMapping = new com.pingidentity.admin.api.model.AttributeMapping();
        C2cContract apc = MgmtFactory.getC2cContractManager().getContract(domainAction.getApcId());
        if (apc == null) {
            this.attributeMappingTranslator.domainToApi(domainAttributeMapping, apiAttributeMapping);
        } else {
            this.attributeMappingTranslator.domainToApi(domainAttributeMapping, apiAttributeMapping, (Set<String>)apc.getAllAttributeNames(), false);
        }
        apiApcMappingAction.setAttributeMapping(apiAttributeMapping);
        return apiApcMappingAction;
    }

    @Override
    public AuthnSelectionAction apiToDomain(ApcMappingPolicyAction apiAction) {
        String apcId = apiAction.getAuthenticationPolicyContractRef().getId();
        ApcMappingAction domainAction = new ApcMappingAction(apcId, new AttributeMapping());
        super.apiToDomain(apiAction, domainAction);
        com.pingidentity.admin.api.model.AttributeMapping apiAttributeMapping = apiAction.getAttributeMapping();
        AttributeMapping domainAttributeMapping = new AttributeMapping();
        this.attributeMappingTranslator.apiToDomain(apiAttributeMapping, domainAttributeMapping);
        domainAction.setAttributeMapping(domainAttributeMapping);
        return domainAction;
    }
}

