/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthnApiSettings;
import com.pingidentity.admin.api.model.ResourceLink;
import org.apache.commons.lang.StringUtils;

public class AuthenticationApiApplicationSettingsTranslator {
    public AuthnApiSettings domainToApi(org.sourceid.saml20.domain.AuthnApiSettings domain) {
        AuthnApiSettings apiModel = new AuthnApiSettings();
        apiModel.setApiEnabled(domain.isApiEnabled());
        if (StringUtils.isNotBlank((String)domain.getDefaultApplicationId())) {
            ResourceLink defaultApp = new ResourceLink(domain.getDefaultApplicationId(), ApiUtil.getResourceUrl("/authenticationApi/applications", domain.getDefaultApplicationId()));
            apiModel.setDefaultApplicationRef(defaultApp);
        }
        apiModel.setEnableApiDescriptions(domain.isEnableApiDescriptions() == null ? Boolean.TRUE.booleanValue() : domain.isEnableApiDescriptions().booleanValue());
        apiModel.setRestrictAccessToRedirectlessMode(domain.isRestrictAccessToRedirectlessMode());
        apiModel.setIncludeRequestContext(domain.isIncludeRequestContext());
        return apiModel;
    }

    public org.sourceid.saml20.domain.AuthnApiSettings apiToDomain(AuthnApiSettings apiModel) {
        org.sourceid.saml20.domain.AuthnApiSettings domain = new org.sourceid.saml20.domain.AuthnApiSettings();
        domain.setApiEnabled(apiModel.isApiEnabled());
        if (apiModel.getDefaultApplicationRef() != null) {
            domain.setDefaultApplicationId(apiModel.getDefaultApplicationRef().getId());
        }
        domain.setEnableApiDescriptions(Boolean.valueOf(apiModel.isEnableApiDescriptions()));
        domain.setRestrictAccessToRedirectlessMode(apiModel.isRestrictAccessToRedirectlessMode());
        domain.setIncludeRequestContext(apiModel.isIncludeRequestContext());
        return domain;
    }
}

