/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthnApiApplication;
import com.pingidentity.admin.api.model.ResourceLink;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationApiApplicationTranslator {
    public AuthnApiApplication domainToApi(org.sourceid.saml20.domain.AuthnApiApplication domain) {
        return this.domainToApi(domain, false);
    }

    public AuthnApiApplication domainToApi(org.sourceid.saml20.domain.AuthnApiApplication domain, boolean forAdminConsoleValidation) {
        Client client;
        String domainClientId;
        AuthnApiApplication apiModel = new AuthnApiApplication();
        apiModel.setId(domain.getId());
        apiModel.setName(domain.getName());
        apiModel.setDescription(domain.getDescription());
        apiModel.setAdditionalAllowedOrigins(domain.getCorsList());
        apiModel.setUrl(domain.getUrl());
        if (forAdminConsoleValidation) {
            if (domain.getClientIdForRedirectlessMode() != null) {
                ResourceLink clientRef = new ResourceLink(domain.getClientIdForRedirectlessMode(), ApiUtil.getResourceUrl("/oauth/clients", domain.getClientIdForRedirectlessMode()));
                apiModel.setClientForRedirectlessModeRef(clientRef);
            }
        } else if (MgmtFactory.getAuthnApiManager().getSettings().isRestrictAccessToRedirectlessMode() && (domainClientId = domain.getClientIdForRedirectlessMode()) != null && (client = MgmtFactory.getClientManager().getClient(domainClientId)) != null) {
            apiModel.setClientForRedirectlessModeRef(new ResourceLink(domainClientId, ApiUtil.getResourceUrl("/oauth/clients", domainClientId)));
        }
        return apiModel;
    }

    public org.sourceid.saml20.domain.AuthnApiApplication apiToDomain(AuthnApiApplication apiModel) {
        org.sourceid.saml20.domain.AuthnApiApplication domain = new org.sourceid.saml20.domain.AuthnApiApplication();
        domain.setId(apiModel.getId());
        domain.setName(apiModel.getName());
        domain.setDescription(apiModel.getDescription());
        domain.setUrl(apiModel.getUrl());
        domain.setCorsList(apiModel.getAdditionalAllowedOrigins());
        if (apiModel.getClientForRedirectlessModeRef() != null) {
            domain.setClientIdForRedirectlessMode(apiModel.getClientForRedirectlessModeRef().getId());
        }
        return domain;
    }
}

