/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthenticationPolicyContractAssertionMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.pf.admin.rest.translator.AttributeAssertionMappingTranslator;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnSourceToAssertionMapping;

public class AuthenticationPolicyContractAssertionMappingTranslator {
    public void apiToDomain(SpConnection apiConn, List<C2cContractToAssertionMapping> domainMappings) {
        domainMappings.clear();
        List<AuthenticationPolicyContractAssertionMapping> apiMappings = apiConn.getSpBrowserSso().getAuthenticationPolicyContractAssertionMappings();
        for (AuthenticationPolicyContractAssertionMapping authenticationPolicyContractAssertionMapping : apiMappings) {
            C2cContractToAssertionMapping domainMapping = new C2cContractToAssertionMapping();
            domainMapping.setContractId(authenticationPolicyContractAssertionMapping.getAuthenticationPolicyContractRef().getId());
            domainMappings.add(domainMapping);
            AttributeAssertionMappingTranslator mappingTranslator = new AttributeAssertionMappingTranslator();
            if (apiConn.getSpBrowserSso().getProtocol() == Protocol.WSFED) {
                mappingTranslator.apiToDomain_wsFed(authenticationPolicyContractAssertionMapping, (AuthnSourceToAssertionMapping)domainMapping);
            } else {
                mappingTranslator.apiToDomain_nonWsFed(authenticationPolicyContractAssertionMapping, (AuthnSourceToAssertionMapping)domainMapping);
            }
            List domainAttributeMappings = domainMapping.getAttributeMappingList();
            AttributeMapping defaultAttributeMapping = domainMapping.getDefaultAttributeMapping();
            if (domainAttributeMappings.size() > 0 && defaultAttributeMapping.getAttributeMapping().isEmpty() && authenticationPolicyContractAssertionMapping.isAbortSsoTransactionAsFailSafe()) {
                domainMapping.setAbortIfNotFoundInAnyDataSources(true);
            }
            domainMapping.setRestrictVirtualServerIds(authenticationPolicyContractAssertionMapping.isRestrictVirtualEntityIds());
            if (!authenticationPolicyContractAssertionMapping.isRestrictVirtualEntityIds()) continue;
            domainMapping.setRestrictedVirtualServerIds(authenticationPolicyContractAssertionMapping.getRestrictedVirtualEntityIds());
        }
    }

    public void domainToApi(Collection<C2cContractToAssertionMapping> domainMappings, List<AuthenticationPolicyContractAssertionMapping> apiMappings) {
        apiMappings.clear();
        for (C2cContractToAssertionMapping domainMapping : domainMappings) {
            ResourceLink resourceId = new ResourceLink();
            String contractId = domainMapping.getContractId();
            if (contractId != null) {
                resourceId.setId(contractId);
                resourceId.setLocation(ApiUtil.getResourceUrl("/authenticationPolicyContracts", domainMapping.getContractId()));
            }
            AuthenticationPolicyContractAssertionMapping apiMapping = new AuthenticationPolicyContractAssertionMapping();
            apiMapping.setAuthenticationPolicyContractRef(resourceId);
            apiMappings.add(apiMapping);
            AttributeAssertionMappingTranslator mappingTranslator = new AttributeAssertionMappingTranslator();
            mappingTranslator.domainToApi(domainMapping.getAttributeMappingList(), (com.pingidentity.admin.api.model.AttributeMapping)apiMapping);
            if (domainMapping.getDefaultAttributeMapping() != null) {
                mappingTranslator.domainToApi(domainMapping.getDefaultAttributeMapping(), (com.pingidentity.admin.api.model.AttributeMapping)apiMapping);
            }
            apiMapping.setRestrictVirtualEntityIds(domainMapping.isRestrictVirtualServerIds());
            if (domainMapping.isRestrictVirtualServerIds()) {
                apiMapping.setRestrictedVirtualEntityIds(domainMapping.getRestrictedVirtualServerIds());
            }
            if (!domainMapping.isAbortIfNotFoundInAnyDataSources()) continue;
            apiMapping.setAbortSsoTransactionAsFailSafe(true);
        }
    }
}

