/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthenticationPolicyContractMapping;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationPolicyContractMappingTranslator {
    public void apiToDomain(List<AuthenticationPolicyContractMapping> apiMappings, Collection<C2cContractAttributeMapping> domainMappings) {
        domainMappings.clear();
        for (AuthenticationPolicyContractMapping apiMapping : apiMappings) {
            C2cContractAttributeMapping domainMapping = new C2cContractAttributeMapping();
            domainMapping.setContractId(apiMapping.getAuthenticationPolicyContractRef().getId());
            domainMappings.add(domainMapping);
            AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
            attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
            domainMapping.setRestrictVirtualServerIds(apiMapping.isRestrictVirtualServerIds());
            if (!apiMapping.isRestrictVirtualServerIds()) continue;
            domainMapping.setRestrictedVirtualServerIds(apiMapping.getRestrictedVirtualServerIds());
        }
    }

    public void domainToApi(Collection<C2cContractAttributeMapping> domainMappings, List<AuthenticationPolicyContractMapping> apiMappings) {
        apiMappings.clear();
        for (C2cContractAttributeMapping domainMapping : domainMappings) {
            ResourceLink resourceId = new ResourceLink();
            resourceId.setId(domainMapping.getContractId());
            resourceId.setLocation(ApiUtil.getResourceUrl("/authenticationPolicyContracts", domainMapping.getContractId()));
            AuthenticationPolicyContractMapping apiMapping = new AuthenticationPolicyContractMapping();
            apiMapping.setAuthenticationPolicyContractRef(resourceId);
            apiMappings.add(apiMapping);
            C2cContract apc = MgmtFactory.getC2cContractManager().getContract(domainMapping.getContractId());
            AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
            attributeMappingTranslator.domainToApi((AttributeMapping)domainMapping, apiMapping, (Set<String>)apc.getAllAttributeNames(), false);
            apiMapping.setRestrictVirtualServerIds(domainMapping.isRestrictVirtualServerIds());
            if (!domainMapping.isRestrictVirtualServerIds()) continue;
            apiMapping.setRestrictedVirtualServerIds(domainMapping.getRestrictedVirtualServerIds());
        }
    }
}

