/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthenticationPolicyFragment;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicyTreeTranslator;
import com.pingidentity.pingcommons.util.tree.Tree;

public class AuthenticationPolicyFragmentTranslator {
    private final AuthenticationPolicyTreeTranslator authenticationPolicyTreeTranslator = new AuthenticationPolicyTreeTranslator();

    public AuthenticationPolicyFragment domainToApi(PolicyFragment domainFragment) {
        AuthenticationPolicyFragment apiFragment = new AuthenticationPolicyFragment();
        apiFragment.setId(domainFragment.getId());
        apiFragment.setName(domainFragment.getName());
        apiFragment.setDescription(domainFragment.getDescription());
        if (domainFragment.getInputContractId() != null) {
            apiFragment.setInputs(new ResourceLink(domainFragment.getInputContractId(), ApiUtil.getResourceUrl("/authenticationPolicyContracts", domainFragment.getInputContractId())));
        }
        if (domainFragment.getOutputContractId() != null) {
            apiFragment.setOutputs(new ResourceLink(domainFragment.getOutputContractId(), ApiUtil.getResourceUrl("/authenticationPolicyContracts", domainFragment.getOutputContractId())));
        }
        apiFragment.setRootNode(this.authenticationPolicyTreeTranslator.buildApiPolicyTree((Tree.Node<AuthnSelectionAction>)domainFragment.getRootNode()));
        return apiFragment;
    }

    public PolicyFragment apiToDomain(AuthenticationPolicyFragment apiFragment) {
        PolicyFragment domainFragment = new PolicyFragment(this.authenticationPolicyTreeTranslator.buildDomainPolicyTree(apiFragment.getRootNode()));
        domainFragment.setId(apiFragment.getId());
        domainFragment.setName(apiFragment.getName());
        domainFragment.setDescription(apiFragment.getDescription());
        if (apiFragment.getInputs() != null) {
            domainFragment.setInputContractId(apiFragment.getInputs().getId());
        }
        if (apiFragment.getOutputs() != null) {
            domainFragment.setOutputContractId(apiFragment.getOutputs().getId());
        }
        return domainFragment;
    }
}

