/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AuthenticationSource;
import com.pingidentity.admin.api.model.AuthenticationSourceType;
import com.pingidentity.admin.api.model.ResourceLink;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;

public class AuthenticationSourceTranslator {
    public AuthnSourceKey apiToDomain(AuthenticationSource apiSource) {
        switch (apiSource.getType()) {
            case IDP_ADAPTER: {
                return new AdapterAuthnSourceKey(apiSource.getSourceRef().getId());
            }
            case IDP_CONNECTION: {
                return new IdpConnAuthnSourceKey(apiSource.getSourceRef().getId());
            }
        }
        throw new RuntimeException("Unexpected AuthenticationSourceType: " + apiSource.getType());
    }

    public AuthenticationSource domainToApi(AuthnSourceKey domainSource) {
        AuthenticationSource result = new AuthenticationSource();
        switch (domainSource.getType()) {
            case ADAPTER: {
                result.setType(AuthenticationSourceType.IDP_ADAPTER);
                ResourceLink sourceRef = new ResourceLink(domainSource.getId(), ApiUtil.getResourceUrl("/idp/adapters", domainSource.getId()));
                result.setSourceRef(sourceRef);
                break;
            }
            case IDP_CONN: {
                result.setType(AuthenticationSourceType.IDP_CONNECTION);
                ResourceLink sourceRef = new ResourceLink(domainSource.getId(), ApiUtil.getResourceUrl("/sp/idpConnections", domainSource.getId()));
                result.setSourceRef(sourceRef);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected AuthnSourceType: " + domainSource.getType());
            }
        }
        return result;
    }
}

