/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.CertificateRevocationSettings;
import com.pingidentity.admin.api.model.CrlSettings;
import com.pingidentity.admin.api.model.OcspSettings;
import com.pingidentity.admin.api.model.ProxySettings;
import com.pingidentity.admin.api.model.ResourceLink;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.RevocationSettings;

public class CertificateRevocationCheckingTranslator {
    private RevocationSettings settingsDomain;
    private CertificateRevocationSettings settingsApi;
    private OcspSettings ocspSettings;
    private CrlSettings crlSettings;
    private ProxySettings proxySettings;

    public RevocationSettings apiToDomain(CertificateRevocationSettings settingsApi) {
        this.settingsDomain = new RevocationSettings();
        this.ocspSettings = settingsApi.getOcspSettings();
        this.crlSettings = settingsApi.getCrlSettings();
        this.proxySettings = settingsApi.getProxySettings();
        if (this.ocspSettings != null) {
            this.settingsDomain.setOcspEnabled(true);
            this.settingsDomain.setOcspResponderUrl(this.ocspSettings.getResponderUrl());
            this.settingsDomain.setOcspRequesterAddNonce(this.ocspSettings.isRequesterAddNonce());
            if (this.ocspSettings.getResponderCertReference() != null) {
                this.settingsDomain.setOcspResponderCertAlias(this.ocspSettings.getResponderCertReference().getId());
                this.ocspSettings.getResponderCertReference().setLocation(ApiUtil.getResourceUrl("/certificates/revocation/ocspCertificates", this.ocspSettings.getResponderCertReference().getId()));
            } else {
                this.settingsDomain.setOcspResponderCertAlias("");
            }
            this.settingsDomain.setOcspActionOnUnsuccessfulResponse(this.ocspSettings.getActionOnUnsuccessfulResponse());
            this.settingsDomain.setOcspActionOnStatusUnknown(this.ocspSettings.getActionOnStatusUnknown());
            this.settingsDomain.setOcspActionOnResponderUnavailable(this.ocspSettings.getActionOnResponderUnavailable());
            this.settingsDomain.setOcspThisUpdateGracePeriod(String.valueOf(this.ocspSettings.getCurrentUpdateGracePeriod()));
            this.settingsDomain.setOcspNextUpdateGracePeriod(String.valueOf(this.ocspSettings.getNextUpdateGracePeriod()));
            this.settingsDomain.setOcspResponseCachePeriod(String.valueOf(this.ocspSettings.getResponseCachePeriod()));
            this.settingsDomain.setOcspConnectionTimeoutSecs(String.valueOf(this.ocspSettings.getResponderTimeout()));
        } else {
            this.settingsDomain.setOcspEnabled(false);
        }
        if (this.crlSettings != null) {
            this.settingsDomain.setCrlEnabled(true);
            this.settingsDomain.setVerifyCrlSignature(this.crlSettings.isVerifyCrlSignature());
            this.settingsDomain.setNextRetryMinsWhenNextUpdateInPast(String.valueOf(this.crlSettings.getNextRetryMinsWhenNextUpdateInPast()));
            this.settingsDomain.setNextRetryMinsWhenResolveFailed(String.valueOf(this.crlSettings.getNextRetryMinsWhenResolveFailed()));
            this.settingsDomain.setTreatNonRetrievableCrlAsRevoked(this.crlSettings.isTreatNonRetrievableCrlAsRevoked());
        } else {
            this.settingsDomain.setCrlEnabled(false);
        }
        if (this.proxySettings != null) {
            this.settingsDomain.setProxyPort(String.valueOf(this.proxySettings.getPort()));
            this.settingsDomain.setProxyHost(this.proxySettings.getHost());
        } else {
            this.settingsDomain.setProxyPort("");
            this.settingsDomain.setProxyHost("");
        }
        return this.settingsDomain;
    }

    public CertificateRevocationSettings domainToApi(RevocationSettings settingsDomain) {
        this.settingsApi = new CertificateRevocationSettings();
        if (settingsDomain.isOcspEnabled()) {
            this.ocspSettings = new OcspSettings();
            this.ocspSettings.setResponderUrl(settingsDomain.getOcspResponderUrl());
            this.ocspSettings.setRequesterAddNonce(settingsDomain.isOcspRequesterAddNonce());
            String responderCertAlias = settingsDomain.getOcspResponderCertAlias();
            if (StringUtils.isNotBlank((String)responderCertAlias)) {
                ResourceLink resourceLink = new ResourceLink();
                this.ocspSettings.setResponderCertReference(resourceLink);
                this.ocspSettings.getResponderCertReference().setId(responderCertAlias);
                this.ocspSettings.getResponderCertReference().setLocation(ApiUtil.getResourceUrl("/certificates/revocation/ocspCertificates", responderCertAlias));
            }
            this.ocspSettings.setActionOnUnsuccessfulResponse(settingsDomain.getOcspActionOnUnsuccessfulResponse());
            this.ocspSettings.setActionOnStatusUnknown(settingsDomain.getOcspActionOnStatusUnknown());
            this.ocspSettings.setActionOnResponderUnavailable(settingsDomain.getOcspActionOnResponderUnavailable());
            this.ocspSettings.setCurrentUpdateGracePeriod(Integer.parseInt(settingsDomain.getOcspThisUpdateGracePeriod()));
            this.ocspSettings.setNextUpdateGracePeriod(Integer.parseInt(settingsDomain.getOcspNextUpdateGracePeriod()));
            this.ocspSettings.setResponseCachePeriod(Integer.parseInt(settingsDomain.getOcspResponseCachePeriod()));
            this.ocspSettings.setResponderTimeout(Integer.parseInt(settingsDomain.getOcspConnectionTimeoutSecs()));
            this.settingsApi.setOcspSettings(this.ocspSettings);
        }
        if (settingsDomain.isCrlEnabled()) {
            this.crlSettings = new CrlSettings();
            this.crlSettings.setVerifyCrlSignature(settingsDomain.isVerifyCrlSignature());
            this.crlSettings.setNextRetryMinsWhenNextUpdateInPast(Integer.parseInt(settingsDomain.getNextRetryMinsWhenNextUpdateInPast()));
            this.crlSettings.setNextRetryMinsWhenResolveFailed(Integer.parseInt(settingsDomain.getNextRetryMinsWhenResolveFailed()));
            this.crlSettings.setTreatNonRetrievableCrlAsRevoked(settingsDomain.isTreatNonRetrievableCrlAsRevoked());
            this.settingsApi.setCrlSettings(this.crlSettings);
        }
        if (StringUtils.isNotBlank((String)settingsDomain.getProxyHost())) {
            this.proxySettings = new ProxySettings();
            this.proxySettings.setHost(settingsDomain.getProxyHost());
            this.proxySettings.setPort(Integer.parseInt(settingsDomain.getProxyPort()));
            this.settingsApi.setProxySettings(this.proxySettings);
        }
        return this.settingsApi;
    }
}

