/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AccountManagementSettings;
import com.pingidentity.admin.api.model.ChangeDetectionSettings;
import com.pingidentity.admin.api.model.ChannelSource;
import com.pingidentity.admin.api.model.ChannelSourceLocation;
import com.pingidentity.admin.api.model.GroupMembershipDetection;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.pf.admin.rest.translator.AccountManagementSettingsTranslator;
import com.pingidentity.pf.admin.rest.translator.ChangeDetectionSettingsTranslator;
import com.pingidentity.pf.admin.rest.translator.ChannelSourceLocationTranslator;
import com.pingidentity.pf.admin.rest.translator.GroupMembershipDetectionTranslator;
import com.pingidentity.provisioner.domain.source.LdapGuidFormatter;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

class ChannelSourceTranslator {
    private final ChangeDetectionSettingsTranslator changeDetectionSettingsTranslator = new ChangeDetectionSettingsTranslator();
    private final GroupMembershipDetectionTranslator groupMembershipDetectionTranslator = new GroupMembershipDetectionTranslator();
    private final AccountManagementSettingsTranslator accountManagementSettingsTranslator = new AccountManagementSettingsTranslator();
    private final ChannelSourceLocationTranslator channelSourceTranslator = new ChannelSourceLocationTranslator();

    ChannelSourceTranslator() {
    }

    ChannelSource domainToApi(com.pingidentity.provisioner.domain.source.ChannelSource domainChannelSource) {
        ChannelSource apiChannelSource = new ChannelSource();
        AccountManagementSettings accountManagementSettings = this.accountManagementSettingsTranslator.domainToApi(domainChannelSource);
        apiChannelSource.setAccountManagementSettings(accountManagementSettings);
        ChangeDetectionSettings changeDetectionSettings = this.changeDetectionSettingsTranslator.domainToApi(domainChannelSource);
        apiChannelSource.setChangeDetectionSettings(changeDetectionSettings);
        ResourceLink resourceLink = new ResourceLink(domainChannelSource.getDataSourceId(), ApiUtil.getResourceUrl("/dataStores", domainChannelSource.getDataSourceId()));
        apiChannelSource.setDataSource(resourceLink);
        apiChannelSource.setBaseDn(domainChannelSource.getUserBaseDN());
        GroupMembershipDetection groupMembershipDetection = this.groupMembershipDetectionTranslator.domainToApi(domainChannelSource);
        apiChannelSource.setGroupMembershipDetection(groupMembershipDetection);
        apiChannelSource.setGuidAttributeName(domainChannelSource.getGuidFormatter().getGuidAttributeName());
        apiChannelSource.setGuidBinary(domainChannelSource.getGuidFormatter().isGuidIsBinary());
        ChannelSourceLocation userSourceLocation = this.channelSourceTranslator.domainToApi(domainChannelSource.getGroupDNForUsers(), domainChannelSource.getFilterForUsers(), domainChannelSource.isUserNestedSearch());
        apiChannelSource.setUserSourceLocation(userSourceLocation);
        ChannelSourceLocation groupSourceLocation = this.channelSourceTranslator.domainToApi(domainChannelSource.getGroupDNForGroups(), domainChannelSource.getGroupFilterForGroups(), domainChannelSource.isGroupNestedSearch());
        apiChannelSource.setGroupSourceLocation(groupSourceLocation);
        return apiChannelSource;
    }

    void apiToDomain(ChannelSource apiChannelSource, com.pingidentity.provisioner.domain.source.ChannelSource domainChannelSource) {
        String dsId = apiChannelSource.getDataSource().getId();
        domainChannelSource.setDataSourceId(dsId);
        domainChannelSource.setUserBaseDN(apiChannelSource.getBaseDn());
        LdapGuidFormatter ldapGuidFormatter = new LdapGuidFormatter();
        ldapGuidFormatter.setGuidAttributeName(apiChannelSource.getGuidAttributeName());
        ldapGuidFormatter.setGuidIsBinary(apiChannelSource.isGuidBinary());
        domainChannelSource.setGuidFormatter(ldapGuidFormatter);
        this.changeDetectionSettingsTranslator.apiToDomain(apiChannelSource.getChangeDetectionSettings(), domainChannelSource);
        LdapDataSource ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(dsId);
        boolean isOracleLdap = ldapDataSource.isSunOneType() || ldapDataSource.isOracleUnifiedDirectoryType();
        this.groupMembershipDetectionTranslator.apiToDomain(apiChannelSource.getGroupMembershipDetection(), domainChannelSource, isOracleLdap);
        this.accountManagementSettingsTranslator.apiToDomain(apiChannelSource.getAccountManagementSettings(), domainChannelSource);
        this.channelSourceTranslator.apiToDomain(apiChannelSource.getGroupSourceLocation(), false, domainChannelSource);
        this.channelSourceTranslator.apiToDomain(apiChannelSource.getUserSourceLocation(), true, domainChannelSource);
    }
}

