/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.CibaServerPolicySettings;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.fieldpaths.oauth.CibaServerPolicySettingsPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;

public class CibaServerPolicySettingsValidator
extends CompositeValidator {
    private CibaServerPolicySettings cibaServerPolicySettings;
    private CibaServerPolicy domainCibaServerPolicy;

    public CibaServerPolicySettingsValidator(CibaServerPolicySettings settings, CibaServerPolicy policy) {
        this.cibaServerPolicySettings = settings;
        this.domainCibaServerPolicy = policy;
        if (this.cibaServerPolicySettings.getDefaultRequestPolicyRef() != null) {
            this.addValidator((Validator)new ResourceIdValidator(settings.getDefaultRequestPolicyRef(), "Default policy reference", CibaServerPolicySettingsPaths.getDefaultRequestPolicyRef()));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        ResourceLink defaultPolicyRef = this.cibaServerPolicySettings.getDefaultRequestPolicyRef();
        if (defaultPolicyRef != null) {
            if (!this.domainCibaServerPolicy.containsRequestHandlingPolicy(defaultPolicyRef.getId())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_server_policy_default_request_policy_id_invalid, CibaServerPolicySettingsPaths.getDefaultRequestPolicyRef(), new Object[]{defaultPolicyRef.getId()}));
            }
        } else if (!this.domainCibaServerPolicy.getRequestHandlingPolicies().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ciba_server_policy_default_request_policy_required, CibaServerPolicySettingsPaths.getDefaultRequestPolicyRef()));
        }
        return !this.hasErrors();
    }
}

