/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.collectsupportdata.CsdArchiveStatus;
import com.pingidentity.admin.api.model.collectsupportdata.CsdSettings;
import org.sourceid.saml20.domain.mgmt.impl.CsdArchiveInfo;
import org.sourceid.util.collectsupportdata.CsdNodeType;

public class CollectSupportDataTranslator {
    public CsdSettings domainToApi(org.sourceid.util.collectsupportdata.CsdSettings domainSettings) {
        CsdSettings csdSettings = new CsdSettings();
        csdSettings.setCollectExpensiveData(domainSettings.isCollectExpensiveData());
        csdSettings.setEncryptArchive(domainSettings.isEncryptArchive());
        csdSettings.setEncryptionPassphrase(domainSettings.getEncryptionPassphrase());
        csdSettings.setTruncateLogs(domainSettings.isTruncateLogs());
        csdSettings.setFileHeadCollectionKBSize(domainSettings.getFileHeadCollectionKBSize());
        csdSettings.setFileTailCollectionKBSize(domainSettings.getFileTailCollectionKBSize());
        csdSettings.setReportCount(domainSettings.getReportCount());
        csdSettings.setReportInterval(domainSettings.getReportInterval());
        csdSettings.setRolledLogCount(domainSettings.getRolledLogCount());
        csdSettings.setIncludeBinaryFiles(domainSettings.isIncludeBinaryFiles());
        csdSettings.setNumHeartbeatSamples(domainSettings.getNumHeartbeatSamples());
        csdSettings.setIntervalBetweenHeartbeatSamples(domainSettings.getIntervalBetweenHeartbeatSamples());
        return csdSettings;
    }

    public org.sourceid.util.collectsupportdata.CsdSettings apiToDomain(CsdSettings apiSettings) {
        org.sourceid.util.collectsupportdata.CsdSettings domainSettings = new org.sourceid.util.collectsupportdata.CsdSettings();
        domainSettings.setNodesToCollect(apiSettings.getNodesToCollect());
        if (apiSettings.getNodeTypeToCollect() != null) {
            switch (apiSettings.getNodeTypeToCollect()) {
                case STANDALONE: {
                    domainSettings.setNodeTypeToCollect(CsdNodeType.STANDALONE);
                    break;
                }
                case ENGINES: {
                    domainSettings.setNodeTypeToCollect(CsdNodeType.ENGINES);
                    break;
                }
                case ADMINS: {
                    domainSettings.setNodeTypeToCollect(CsdNodeType.ADMINS);
                    break;
                }
                case ALL: {
                    domainSettings.setNodeTypeToCollect(CsdNodeType.ALL);
                }
            }
        }
        domainSettings.setTruncateLogs(apiSettings.isTruncateLogs());
        domainSettings.setFileHeadCollectionKBSize(apiSettings.getFileHeadCollectionKBSize());
        domainSettings.setFileTailCollectionKBSize(apiSettings.getFileTailCollectionKBSize());
        domainSettings.setEncryptArchive(apiSettings.isEncryptArchive());
        domainSettings.setEncryptionPassphrase(apiSettings.getEncryptionPassphrase());
        domainSettings.setCollectExpensiveData(apiSettings.isCollectExpensiveData());
        domainSettings.setIncludeBinaryFiles(apiSettings.isIncludeBinaryFiles());
        domainSettings.setReportCount(apiSettings.getReportCount());
        domainSettings.setReportInterval(apiSettings.getReportInterval());
        domainSettings.setRolledLogCount(apiSettings.getRolledLogCount());
        domainSettings.setNumHeartbeatSamples(apiSettings.getNumHeartbeatSamples());
        domainSettings.setIntervalBetweenHeartbeatSamples(apiSettings.getIntervalBetweenHeartbeatSamples());
        domainSettings.setComment(apiSettings.getComment());
        return domainSettings;
    }

    public com.pingidentity.admin.api.model.collectsupportdata.CsdArchiveInfo domainToApi(CsdArchiveInfo csdArchiveInfo) {
        com.pingidentity.admin.api.model.collectsupportdata.CsdArchiveInfo csdArchiveInfoApi = new com.pingidentity.admin.api.model.collectsupportdata.CsdArchiveInfo();
        csdArchiveInfoApi.setNodeIndex(csdArchiveInfo.getNodeIndex());
        csdArchiveInfoApi.setArchiveId(csdArchiveInfo.getArchiveId());
        csdArchiveInfoApi.setAddress(csdArchiveInfo.getAddress());
        csdArchiveInfoApi.setTimestamp(csdArchiveInfo.getTimestamp());
        csdArchiveInfoApi.setStatus(this.translateCsdArchiveStatus(csdArchiveInfo.getStatus()));
        String statusHref = ApiUtil.getResourceUrl("/collectSupportData", "archives", csdArchiveInfo.getArchiveId());
        csdArchiveInfoApi.setStatusLink(new ResourceLink(statusHref));
        String exportHref = ApiUtil.getResourceUrl("/collectSupportData", "archives", "export", csdArchiveInfo.getArchiveId());
        csdArchiveInfoApi.setExportLink(new ResourceLink(exportHref));
        return csdArchiveInfoApi;
    }

    public CsdArchiveStatus translateCsdArchiveStatus(org.sourceid.util.collectsupportdata.CsdArchiveStatus domainStatus) {
        switch (domainStatus) {
            case FAILED: {
                return CsdArchiveStatus.FAILED;
            }
            case COMPLETED: {
                return CsdArchiveStatus.COMPLETED;
            }
            case IN_PROGRESS: {
                return CsdArchiveStatus.IN_PROGRESS;
            }
        }
        return null;
    }
}

