/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionMetadataUrl;
import com.pingidentity.admin.api.model.ResourceLink;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;

public class ConnectionMetadataUrlTranslator {
    public void apiToDomain(Connection apiConn, ConnectionBase domainConn) {
        ConnectionMetadataUrl connectionMetadata = apiConn.getMetadataReloadSettings();
        if (connectionMetadata != null) {
            ResourceLink metadataResource = connectionMetadata.getMetadataUrlRef();
            boolean enableAutoReload = connectionMetadata.isEnableAutoMetadataUpdate();
            if (metadataResource != null) {
                String metadataUrlID = metadataResource.getId();
                domainConn.setMetadataUrlId(metadataUrlID);
            }
            domainConn.setEnableAutoMetadataUpdate(enableAutoReload);
        }
    }

    public void domainToApi(ConnectionBase domainConn, Connection apiConn) {
        ConnectionMetadataUrl connectionMetadata = new ConnectionMetadataUrl();
        String metadataUrlID = domainConn.getMetadataUrlId();
        if (StringUtils.isNotBlank((String)metadataUrlID)) {
            boolean enableAutoReload = domainConn.isEnableAutoMetadataUpdate();
            String location = ApiUtil.getResourceUrl("/metadataUrls", metadataUrlID);
            ResourceLink metadataResource = new ResourceLink(metadataUrlID, location);
            connectionMetadata.setMetadataUrlRef(metadataResource);
            connectionMetadata.setEnableAutoMetadataUpdate(enableAutoReload);
            apiConn.setMetadataReloadSettings(connectionMetadata);
        }
    }
}

