/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.EncryptedFieldValidator;
import com.pingidentity.email.SmtpNotificationPluginHelper;
import com.pingidentity.pf.email.EmailServerSettings;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.NotificationSettings;

public class EmailServerSettingsTranslator {
    public com.pingidentity.admin.api.model.systemsettings.EmailServerSettings domainToApi(Configuration configuration) {
        EmailServerSettings domainEmailServerSettings = SmtpNotificationPluginHelper.toEmailServerSettings((Configuration)configuration);
        com.pingidentity.admin.api.model.systemsettings.EmailServerSettings apiEmailServerSettings = new com.pingidentity.admin.api.model.systemsettings.EmailServerSettings();
        apiEmailServerSettings.setSourceAddr(domainEmailServerSettings.getFrom());
        apiEmailServerSettings.setUseSSL(domainEmailServerSettings.isUseSSL());
        apiEmailServerSettings.setUseTLS(domainEmailServerSettings.isUseTLS());
        apiEmailServerSettings.setVerifyHostname(domainEmailServerSettings.isVerifyHostname());
        apiEmailServerSettings.setEnableUtf8MessageHeaders(domainEmailServerSettings.isAllowUtf8MsgHeaders());
        apiEmailServerSettings.setUseDebugging(domainEmailServerSettings.isUseDebugging());
        apiEmailServerSettings.setEmailServer(domainEmailServerSettings.getSmtpServer());
        apiEmailServerSettings.setPort(this.getPortInt(domainEmailServerSettings.getSmtpPort()));
        apiEmailServerSettings.setSslPort(this.getSslPortInt(domainEmailServerSettings.getSslSmtpPort()));
        int timeout = this.getTimeoutInt(domainEmailServerSettings.getTimeout());
        apiEmailServerSettings.setTimeout(timeout);
        apiEmailServerSettings.setUsername(domainEmailServerSettings.getUser());
        if (!StringUtils.isBlank((String)domainEmailServerSettings.getPassword())) {
            apiEmailServerSettings.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(domainEmailServerSettings.getPassword()));
        }
        int retryAttempt = this.getRetryAttemptInt(domainEmailServerSettings.getEmailRetryAttempt());
        apiEmailServerSettings.setRetryAttempts(retryAttempt);
        int retryDelay = this.getRetryDelayInt(domainEmailServerSettings.getEmailRetryDelay());
        apiEmailServerSettings.setRetryDelay(retryDelay);
        return apiEmailServerSettings;
    }

    public com.pingidentity.admin.api.model.systemsettings.EmailServerSettings domainToApi(NotificationSettings settings) {
        com.pingidentity.admin.api.model.systemsettings.EmailServerSettings emailSettings = new com.pingidentity.admin.api.model.systemsettings.EmailServerSettings();
        emailSettings.setSourceAddr(settings.getFrom());
        emailSettings.setEmailServer(settings.getSmtpServer());
        emailSettings.setPort(this.getPortInt(settings.getSmtpPort()));
        emailSettings.setSslPort(this.getSslPortInt(settings.getSslSmtpPort()));
        emailSettings.setTimeout(this.getTimeoutInt(settings.getTimeout()));
        emailSettings.setRetryAttempts(this.getRetryAttemptInt(settings.getEmailRetryAttempt()));
        emailSettings.setRetryDelay(this.getRetryDelayInt(settings.getEmailRetryDelay()));
        emailSettings.setUseSSL(settings.isUseSSL());
        emailSettings.setUseTLS(settings.isUseTLS());
        emailSettings.setVerifyHostname(settings.isVerifyHostname());
        emailSettings.setEnableUtf8MessageHeaders(settings.isAllowUtf8MsgHeaders());
        emailSettings.setUseDebugging(settings.isUseDebugging());
        emailSettings.setUsername(settings.getUser());
        if (!StringUtils.isBlank((String)settings.getPassword())) {
            emailSettings.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(settings.getPassword()));
        }
        return emailSettings;
    }

    public Configuration apiToDomainConfiguration(com.pingidentity.admin.api.model.systemsettings.EmailServerSettings emailSettings) {
        return SmtpNotificationPluginHelper.toConfiguration((EmailServerSettings)this.apiToDomain(emailSettings));
    }

    private EmailServerSettings apiToDomain(com.pingidentity.admin.api.model.systemsettings.EmailServerSettings apiEmailSettings) {
        if (apiEmailSettings == null) {
            return null;
        }
        String timeout = this.getTimeoutString(apiEmailSettings.getTimeout());
        String retryAttempts = this.getRetryAttemptStr(apiEmailSettings.getRetryAttempts());
        String retryDelay = this.getRetryDelayStr(apiEmailSettings.getRetryDelay());
        String password = apiEmailSettings.getPassword();
        EncryptedFieldValidator encryptedPasswordValidator = new EncryptedFieldValidator(apiEmailSettings.getPassword(), apiEmailSettings.getEncryptedPassword(), ApiMessageKey.email_server_encrypted_password_invalid, "", new Object[0]);
        if (encryptedPasswordValidator.validate()) {
            password = encryptedPasswordValidator.getPlaintext();
        }
        return new EmailServerSettings(true, apiEmailSettings.isUseSSL(), apiEmailSettings.isUseTLS(), apiEmailSettings.isVerifyHostname(), apiEmailSettings.isEnableUtf8MessageHeaders(), apiEmailSettings.isUseDebugging(), apiEmailSettings.getEmailServer(), Integer.toString(apiEmailSettings.getPort()), Integer.toString(apiEmailSettings.getSslPort()), timeout, apiEmailSettings.getSourceAddr(), apiEmailSettings.getUsername(), password, retryAttempts, retryDelay);
    }

    public com.pingidentity.admin.api.model.systemsettings.EmailServerSettings domainToApi(EmailServerSettings domainEmailSettings) {
        com.pingidentity.admin.api.model.systemsettings.EmailServerSettings apiEmailSettings = new com.pingidentity.admin.api.model.systemsettings.EmailServerSettings();
        apiEmailSettings.setUseSSL(domainEmailSettings.isUseSSL());
        apiEmailSettings.setUseTLS(domainEmailSettings.isUseTLS());
        apiEmailSettings.setVerifyHostname(domainEmailSettings.isVerifyHostname());
        apiEmailSettings.setEnableUtf8MessageHeaders(domainEmailSettings.isAllowUtf8MsgHeaders());
        apiEmailSettings.setUseDebugging(domainEmailSettings.isUseDebugging());
        apiEmailSettings.setEmailServer(domainEmailSettings.getSmtpServer());
        apiEmailSettings.setPort(NumberUtils.toInt((String)domainEmailSettings.getSmtpPort()));
        apiEmailSettings.setSslPort(NumberUtils.toInt((String)domainEmailSettings.getSslSmtpPort()));
        apiEmailSettings.setTimeout(this.getTimeoutInt(domainEmailSettings.getTimeout()));
        apiEmailSettings.setSourceAddr(domainEmailSettings.getFrom());
        apiEmailSettings.setUsername(domainEmailSettings.getUser());
        if (!StringUtils.isBlank((String)domainEmailSettings.getPassword())) {
            apiEmailSettings.setEncryptedPassword(EncryptedFieldValidator.encryptPlaintext(domainEmailSettings.getPassword()));
        }
        apiEmailSettings.setRetryAttempts(this.getRetryAttemptInt(domainEmailSettings.getEmailRetryAttempt()));
        apiEmailSettings.setRetryDelay(this.getRetryDelayInt(domainEmailSettings.getEmailRetryDelay()));
        return apiEmailSettings;
    }

    String getTimeoutString(int timeout) {
        if (timeout < 0) {
            return "30";
        }
        if (timeout > 3600) {
            return String.valueOf(3600);
        }
        return String.valueOf(timeout);
    }

    int getTimeoutInt(String timeout) {
        if (StringUtils.isBlank((String)timeout)) {
            return NumberUtils.toInt((String)"30");
        }
        int timeoutInt = NumberUtils.toInt((String)timeout);
        if (timeoutInt > 3600) {
            return 3600;
        }
        return timeoutInt;
    }

    int getRetryAttemptInt(String retryAttempt) {
        if (StringUtils.isBlank((String)retryAttempt)) {
            return Integer.parseInt("2");
        }
        int retryAttemptInt = NumberUtils.toInt((String)retryAttempt);
        if (retryAttemptInt > 5) {
            return 5;
        }
        return retryAttemptInt;
    }

    String getRetryAttemptStr(int retryAttempt) {
        if (retryAttempt < 0) {
            return "2";
        }
        if (retryAttempt > 5) {
            return Integer.toString(5);
        }
        return Integer.toString(retryAttempt);
    }

    int getRetryDelayInt(String retryDelay) {
        if (StringUtils.isBlank((String)retryDelay)) {
            return Integer.parseInt("2");
        }
        int retryDelayInt = NumberUtils.toInt((String)retryDelay);
        if (retryDelayInt > 10) {
            return 10;
        }
        return retryDelayInt;
    }

    String getRetryDelayStr(int retryDelay) {
        if (retryDelay < 0) {
            return "2";
        }
        if (retryDelay > 10) {
            return Integer.toString(10);
        }
        return Integer.toString(retryDelay);
    }

    int getPortInt(String smtpPort) {
        if (StringUtils.isBlank((String)smtpPort)) {
            return NumberUtils.toInt((String)"25");
        }
        return NumberUtils.toInt((String)smtpPort);
    }

    int getSslPortInt(String sslPort) {
        if (StringUtils.isBlank((String)sslPort)) {
            return NumberUtils.toInt((String)"465");
        }
        return NumberUtils.toInt((String)sslPort);
    }
}

