/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.systemsettings.GeneralSettings;
import com.pingidentity.admin.api.model.systemsettings.LoggingModeOverride;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.LoggingMode;

public class GeneralSettingsTranslator {
    public GeneralSettings domainToApi(LocalSettings localSettings) {
        GeneralSettings generalSettings = new GeneralSettings();
        generalSettings.setDisableAutomaticConnectionValidation(localSettings.isDisableAutomaticConnectionValidation());
        generalSettings.setIdpConnectionTransactionLoggingOverride(LoggingMode.isIdpOverrideOn() ? this.convertToLoggingModeOverride(LoggingMode.getIdpOverrideMode(), "IdP") : LoggingModeOverride.DONT_OVERRIDE);
        generalSettings.setSpConnectionTransactionLoggingOverride(LoggingMode.isSpOverrideOn() ? this.convertToLoggingModeOverride(LoggingMode.getSpOverrideMode(), "SP") : LoggingModeOverride.DONT_OVERRIDE);
        generalSettings.setDatastoreValidationIntervalSecs(localSettings.getDataStoreValidationInterval());
        generalSettings.setRequestHeaderForCorrelationId(StringUtils.isEmpty((String)localSettings.getRequestHeaderNameForCorrelationId()) ? "" : localSettings.getRequestHeaderNameForCorrelationId());
        return generalSettings;
    }

    private LoggingModeOverride convertToLoggingModeOverride(LoggingMode loggingMode, String connectionType) {
        switch (loggingMode) {
            case NONE: {
                return LoggingModeOverride.NONE;
            }
            case STANDARD: {
                return LoggingModeOverride.STANDARD;
            }
            case ENHANCED: {
                return LoggingModeOverride.ENHANCED;
            }
            case FULL: {
                return LoggingModeOverride.FULL;
            }
        }
        throw new RuntimeException("Unexpected " + connectionType + " connection transaction logging mode: " + loggingMode.name());
    }

    public LocalSettings apiToDomain(GeneralSettings generalSettings, LocalSettings localSettings) {
        localSettings.setDisableAutomaticConnectionValidation(generalSettings.isDisableAutomaticConnectionValidation());
        localSettings.setDataStoreValidationInterval(generalSettings.getDatastoreValidationIntervalSecs());
        localSettings.setRequestHeaderNameForCorrelationId(StringUtils.isEmpty((String)generalSettings.getRequestHeaderForCorrelationId()) ? "" : generalSettings.getRequestHeaderForCorrelationId());
        return localSettings;
    }

    public LoggingMode convertToLoggingMode(LoggingModeOverride loggingModeOverride, String connectionType) {
        switch (loggingModeOverride) {
            case NONE: {
                return LoggingMode.NONE;
            }
            case STANDARD: {
                return LoggingMode.STANDARD;
            }
            case ENHANCED: {
                return LoggingMode.ENHANCED;
            }
            case FULL: {
                return LoggingMode.FULL;
            }
        }
        throw new RuntimeException("Unexpected " + connectionType + " connection transaction logging mode: " + loggingModeOverride.name());
    }
}

