/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AccessTokenManagerMapping;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class IdpAccessTokenMappingTranslator {
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    public void apiToDomain(IdpConnection apiConn, org.sourceid.saml20.domain.IdpConnection domainConn) {
        for (AccessTokenManagerMapping mapping : apiConn.getIdpOAuthGrantAttributeMapping().getAccessTokenManagerMappings()) {
            OAuthAssertionGrantMapping domainMapping = new OAuthAssertionGrantMapping();
            domainMapping.setTokenManagerId(mapping.getAccessTokenManagerRef().getId());
            this.attributeMappingTranslator.apiToDomain(mapping, (AttributeMapping)domainMapping);
            domainConn.getOAuthSettings().getOAuthAssertionGrantMappingList().add(domainMapping);
        }
    }

    public void domainToApi(org.sourceid.saml20.domain.IdpConnection domainConn, IdpConnection apiConn) {
        for (OAuthAssertionGrantMapping mapping : domainConn.getOAuthSettings().getOAuthAssertionGrantMappingList()) {
            AccessTokenManagerMapping accessTokenManagerMapping = new AccessTokenManagerMapping();
            ResourceLink tokenManagerRef = new ResourceLink(mapping.getTokenManagerId(), ApiUtil.getResourceUrl("/oauth/accessTokenManagers", mapping.getTokenManagerId()));
            accessTokenManagerMapping.setAccessTokenManagerRef(tokenManagerRef);
            AttributeMappingTranslator attributeMappingTranslatorWithPlugin = new AttributeMappingTranslator(mapping.getTokenManagerId(), (PluginManager<?, ?>)MgmtFactory.getBearerAccessTokenMgmtPluginMgr());
            attributeMappingTranslatorWithPlugin.domainToApi((AttributeMapping)mapping, accessTokenManagerMapping);
            apiConn.getIdpOAuthGrantAttributeMapping().getAccessTokenManagerMappings().add(accessTokenManagerMapping);
        }
    }
}

