/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.DecryptionPolicy;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpIdentityMapping;
import com.pingidentity.admin.api.model.IdpSsoServiceEndpoint;
import com.pingidentity.admin.api.model.OIDCProviderSettings;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SsoOAuthMapping;
import com.pingidentity.admin.api.model.sso.idp.JitProvisioning;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicyContractMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.BaseBrowserSsoTranslator;
import com.pingidentity.pf.admin.rest.translator.IdpConnectionAttributeContractTranslator;
import com.pingidentity.pf.admin.rest.translator.JitProvisioningTranslator;
import com.pingidentity.pf.admin.rest.translator.OIDCProviderTranslator;
import com.pingidentity.pf.admin.rest.translator.SpAdapterMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sourceid.oauth20.domain.UserKeyAttrMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnContextMapping;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.UserProvisioning;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.util.SSOApplicationUrlUtil;
import org.sourceid.websso.domain.trans.DomainTranslator;

public class IdpBrowserSsoTranslator
extends BaseBrowserSsoTranslator {
    private static final Set<org.sourceid.websso.Protocol> SUPPORTED_DOMAIN_PROTOCOLS = new HashSet<org.sourceid.websso.Protocol>();
    private static final Set<Binding> SUPPORTED_SSO_BINDINGS = new HashSet<Binding>();
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
    private ValidatorContext validatorContext;

    public IdpBrowserSsoTranslator(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public void apiToDomain(com.pingidentity.admin.api.model.IdpConnection apiConn, IdpConnection domainConn) {
        IdpBrowserSso browserSso = apiConn.getIdpBrowserSso();
        if (browserSso == null) {
            this.apiToDomain(Collections.emptySet(), domainConn.getEnabledProfiles());
        } else {
            org.sourceid.websso.Protocol domainProtocol = org.sourceid.websso.Protocol.valueOf((String)browserSso.getProtocol().name());
            domainConn.setProtocol(domainProtocol);
            if (domainProtocol != org.sourceid.websso.Protocol.SAML20) {
                this.populateEnabledProfilesAndIncomingBindings(browserSso, Role.IDP);
            }
            this.apiToDomain(browserSso.getEnabledProfiles(), domainConn.getEnabledProfiles());
            this.apiToDomain(browserSso.getIncomingBindings(), domainConn.getIncomingBindings());
            this.apiToDomain(browserSso.getMessageCustomizations(), domainConn.getMessageCustomizationHooks());
            this.apiToDomainSsoServiceEndpoint(browserSso.getSsoServiceEndpoints(), domainProtocol, domainConn.getSingleSignOnServices());
            if (domainProtocol == org.sourceid.websso.Protocol.WSFED) {
                ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
                for (IdpSsoServiceEndpoint item : browserSso.getSsoServiceEndpoints()) {
                    allEndpoints.add(new Endpoint("wsfed:prp:http:get", item.getUrl()));
                }
                domainConn.getSingleLogoutServices().setEndpoints(allEndpoints);
            }
            this.apiToDomain(browserSso.getSloServiceEndpoints(), domainProtocol, domainConn.getSingleLogoutServices());
            domainConn.setDefaultTargetResource(browserSso.getDefaultTargetUrl());
            this.apiToDomainAuthnContextMap(domainConn, browserSso);
            domainConn.setAssertionSigned(browserSso.isAssertionsSigned() == null ? false : browserSso.isAssertionsSigned());
            domainConn.setWantAuthnRequestsSigned(browserSso.isSignAuthnRequests() == null ? false : browserSso.isSignAuthnRequests());
            if (domainProtocol == org.sourceid.websso.Protocol.SAML20 || org.sourceid.websso.Protocol.WSFED == domainProtocol) {
                if (browserSso.getDecryptionPolicy() == null) {
                    browserSso.setDecryptionPolicy(new DecryptionPolicy());
                }
                this.apiToDomain(browserSso.getDecryptionPolicy(), domainConn.getEncryptionSettings());
            }
            this.apiToDomainArtifact(browserSso, (ConnectionBase)domainConn);
            if (this.isArtifactEnabled(browserSso)) {
                domainConn.setAlwaysSignArtifactResponse(browserSso.isAlwaysSignArtifactResponse() == null ? false : browserSso.isAlwaysSignArtifactResponse());
            }
            this.apiToDomain(browserSso.getUrlWhitelistEntries(), (ConnectionBase)domainConn);
            domainConn.setDefaultTargetResource(browserSso.getDefaultTargetUrl());
            IdpConnectionAttributeContractTranslator acTranslator = new IdpConnectionAttributeContractTranslator();
            SpAdapterMappingTranslator adapterTranslator = new SpAdapterMappingTranslator(this.validatorContext);
            domainConn.setLinking(browserSso.getIdpIdentityMapping() == IdpIdentityMapping.ACCOUNT_LINKING);
            if (browserSso.getAttributeContract() != null && !browserSso.getAttributeContract().getExtendedAttributes().isEmpty() && browserSso.getIdpIdentityMapping() == IdpIdentityMapping.ACCOUNT_LINKING) {
                domainConn.setIncludeAdditionalAttributes(true);
            }
            acTranslator.apiToDomain(browserSso, domainConn);
            adapterTranslator.apiToDomain(apiConn, domainConn.getTargetAttributeMappings());
            AuthenticationPolicyContractMappingTranslator authenticationPolicyContractMappingTranslator = new AuthenticationPolicyContractMappingTranslator();
            authenticationPolicyContractMappingTranslator.apiToDomain(browserSso.getAuthenticationPolicyContractMappings(), domainConn.getC2cContractMappings());
            if (browserSso.getSsoOAuthMapping() != null) {
                domainConn.setSsoToOAuthAttrMapping(new UserKeyAttrMapping());
                this.attributeMappingTranslator.apiToDomain(browserSso.getSsoOAuthMapping(), (AttributeMapping)domainConn.getSsoToOAuthAttrMapping());
            } else if (browserSso.getOAuthAuthenticationPolicyContractRef() != null) {
                domainConn.setOAuthApcId(browserSso.getOAuthAuthenticationPolicyContractRef().getId());
            }
            if (domainProtocol == org.sourceid.websso.Protocol.OIDC) {
                OIDCProviderTranslator oidcProviderTranslator = new OIDCProviderTranslator();
                oidcProviderTranslator.apiToDomain(apiConn, domainConn);
            }
            if (browserSso.getJitProvisioning() != null) {
                UserProvisioning userProvisioning = new UserProvisioning();
                JitProvisioningTranslator jitProvisioningTranslator = new JitProvisioningTranslator();
                jitProvisioningTranslator.apiToDomain(browserSso.getJitProvisioning(), userProvisioning);
                domainConn.setUserProvisioning(userProvisioning);
            }
        }
    }

    private void apiToDomainAuthnContextMap(IdpConnection domainConn, IdpBrowserSso browserSso) {
        List<com.pingidentity.admin.api.model.AuthnContextMapping> authnContextMappings = browserSso.getAuthnContextMappings();
        ArrayList<AuthnContextMapping> domainAuthnCtxMappings = new ArrayList<AuthnContextMapping>();
        if (authnContextMappings != null) {
            for (com.pingidentity.admin.api.model.AuthnContextMapping authnContextMapEntry : authnContextMappings) {
                String local = authnContextMapEntry.getLocal();
                String remote = authnContextMapEntry.getRemote();
                AuthnContextMapping domainAuthCtxMapping = new AuthnContextMapping(local, remote);
                domainAuthnCtxMappings.add(domainAuthCtxMapping);
            }
        }
        domainConn.setAuthnContextMappings(domainAuthnCtxMappings);
    }

    public void domainToApi(IdpConnection domainConn, com.pingidentity.admin.api.model.IdpConnection apiConn) {
        EnabledProfiles domainProfiles = domainConn.getEnabledProfiles();
        org.sourceid.websso.Protocol domainProtocol = domainConn.getProtocol();
        if ((domainProfiles.isIdpInitiatedSSOEnabled() || domainProfiles.isSpInitiatedSSOEnabled()) && SUPPORTED_DOMAIN_PROTOCOLS.contains(domainProtocol) && this.isBrowserSSOProfileEnabled(domainProtocol)) {
            boolean setSsoApplicationURL;
            IdpBrowserSso browserSso = new IdpBrowserSso();
            apiConn.setIdpBrowserSso(browserSso);
            Protocol protocol = Protocol.valueOf(domainProtocol.name());
            browserSso.setProtocol(protocol);
            if (domainConn.getEnabledProfiles().isSpInitiatedSSOEnabled()) {
                this.domainToApiSsoServiceEndpoint(domainConn.getSingleSignOnServices(), domainConn.getProtocol(), browserSso);
            }
            if (!domainConn.getMessageCustomizationHooks().isEmpty() && ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
                browserSso.setMessageCustomizations(new ArrayList<ProtocolMessageCustomization>());
                this.domainToApi(domainConn.getMessageCustomizationHooks(), browserSso.getMessageCustomizations());
            }
            browserSso.setDefaultTargetUrl(domainConn.getDefaultTargetResource());
            this.domainToApiAuthnContextMap(domainConn, browserSso);
            browserSso.setAssertionsSigned(domainConn.isAssertionSigned());
            if (this.isSaml(protocol)) {
                if (Protocol.isSaml1x(protocol)) {
                    domainProfiles.setIdpInitiatedSSOEnabled(false);
                    browserSso.setDecryptionPolicy(null);
                } else if (protocol != Protocol.OIDC) {
                    if (browserSso.getDecryptionPolicy() == null) {
                        browserSso.setDecryptionPolicy(new DecryptionPolicy());
                    }
                    this.domainToApi(domainConn.getEncryptionSettings(), browserSso.getDecryptionPolicy());
                }
                this.domainToApi(domainProfiles, browserSso.getEnabledProfiles());
                if (protocol == Protocol.SAML20) {
                    browserSso.setSignAuthnRequests(domainConn.isWantAuthnRequestsSigned());
                } else {
                    browserSso.setSignAuthnRequests(null);
                }
                if (this.isArtifactEnabled((ConnectionBase)domainConn)) {
                    browserSso.setAlwaysSignArtifactResponse(domainConn.isAlwaysSignArtifactResponse());
                }
                HashSet<Binding> bindings = new HashSet<Binding>();
                this.domainToApi(domainConn.getIncomingBindings(), bindings);
                browserSso.setIncomingBindings(bindings);
            } else if (protocol == Protocol.WSFED) {
                if (browserSso.getDecryptionPolicy() == null) {
                    browserSso.setDecryptionPolicy(new DecryptionPolicy());
                }
                this.domainToApi(domainConn.getEncryptionSettings(), browserSso.getDecryptionPolicy());
                browserSso.setEnabledProfiles(null);
                browserSso.setSignAuthnRequests(null);
            }
            browserSso.setDefaultTargetUrl(domainConn.getDefaultTargetResource());
            this.domainToApiArtifact((ConnectionBase)domainConn, browserSso);
            this.domainToApiSsoServiceEndpoint(domainConn.getSingleSignOnServices(), domainConn.getProtocol(), browserSso);
            this.domainToApi(domainConn.getSingleLogoutServices(), domainConn.getProtocol(), browserSso);
            IdpConnectionAttributeContractTranslator acTranslator = new IdpConnectionAttributeContractTranslator();
            SpAdapterMappingTranslator adapterTranslator = new SpAdapterMappingTranslator(this.validatorContext);
            IdpIdentityMapping idMapping = null;
            idMapping = domainConn.isLinking() ? IdpIdentityMapping.ACCOUNT_LINKING : (!domainConn.getTargetAttributeMappings().isEmpty() || !domainConn.getC2cContractMappings().isEmpty() ? IdpIdentityMapping.ACCOUNT_MAPPING : IdpIdentityMapping.NONE);
            browserSso.setIdpIdentityMapping(idMapping);
            acTranslator.domainToApi(domainConn, browserSso.getAttributeContract());
            adapterTranslator.domainToApi(domainConn.getTargetAttributeMappings(), browserSso.getAdapterMappings());
            AuthenticationPolicyContractMappingTranslator apcMappingTranslator = new AuthenticationPolicyContractMappingTranslator();
            apcMappingTranslator.domainToApi(domainConn.getC2cContractMappings(), browserSso.getAuthenticationPolicyContractMappings());
            this.domainToApi(domainConn.getRedirectValidationWhitelist(), browserSso);
            if (domainConn.hasSsoToOAuthAttrMapping()) {
                browserSso.setSsoOAuthMapping(new SsoOAuthMapping());
                HashSet<String> validAttributeContract = MgmtFactory.getAuthzServerManager().getKeyNameContract() == null ? new HashSet() : MgmtFactory.getAuthzServerManager().getKeyNameContract().getAllAttributeNames();
                this.attributeMappingTranslator.domainToApi((AttributeMapping)domainConn.getSsoToOAuthAttrMapping(), browserSso.getSsoOAuthMapping(), validAttributeContract, false);
            } else if (domainConn.hasOAuthApcId()) {
                String apcId = domainConn.getOAuthApcId();
                ResourceLink oauthLink = new ResourceLink();
                oauthLink.setId(apcId);
                oauthLink.setLocation(ApiUtil.getResourceUrl("/authenticationPolicyContracts", apcId));
                browserSso.setOAuthAuthenticationPolicyContractRef(oauthLink);
            }
            if (domainConn.isOIDCConnection()) {
                OIDCProviderTranslator oidcProviderTranslator = new OIDCProviderTranslator();
                apiConn.getIdpBrowserSso().setOidcProviderSettings(new OIDCProviderSettings());
                oidcProviderTranslator.domainToApi(domainConn, apiConn.getIdpBrowserSso().getOidcProviderSettings());
                browserSso.setDecryptionPolicy(null);
                browserSso.setEnabledProfiles(null);
                browserSso.setSignAuthnRequests(null);
                browserSso.setSsoServiceEndpoints(null);
                browserSso.setAssertionsSigned(null);
            }
            if (domainConn.hasUserProvisioning()) {
                JitProvisioning jitProvisioning = new JitProvisioning();
                JitProvisioningTranslator jitProvisioningTranslator = new JitProvisioningTranslator();
                jitProvisioningTranslator.domainToApi(domainConn, jitProvisioning);
                apiConn.getIdpBrowserSso().setJitProvisioning(jitProvisioning);
            }
            if (setSsoApplicationURL = SSOApplicationUrlUtil.displayIdpConnectionSsoURL((boolean)domainConn.isSpSsoSelected(), (boolean)domainConn.doesOIDCRPSettingsExist(), (int)(browserSso.getAdapterMappings() == null ? 0 : browserSso.getAdapterMappings().size()), (int)(browserSso.getAuthenticationPolicyContractMappings() == null ? 0 : browserSso.getAuthenticationPolicyContractMappings().size()))) {
                String ssoUrl = SSOApplicationUrlUtil.getSSOUrl((boolean)true, (boolean)false, (String)apiConn.getEntityId(), (String)SpAdapterMappingTranslator.getAdapterIdForApplicationUrl(browserSso.getAdapterMappings()));
                browserSso.setSsoApplicationEndpoint(ssoUrl);
            }
        }
    }

    private void domainToApiAuthnContextMap(IdpConnection domainConn, IdpBrowserSso browserSso) {
        if (domainConn.getAuthnContextMappings().isEmpty()) {
            return;
        }
        ArrayList<com.pingidentity.admin.api.model.AuthnContextMapping> authnContextMappings = new ArrayList<com.pingidentity.admin.api.model.AuthnContextMapping>();
        for (AuthnContextMapping domainMapping : domainConn.getAuthnContextMappings()) {
            com.pingidentity.admin.api.model.AuthnContextMapping authnContextEntry = new com.pingidentity.admin.api.model.AuthnContextMapping();
            authnContextEntry.setLocal(domainMapping.getLocal());
            authnContextEntry.setRemote(domainMapping.getRemote());
            authnContextMappings.add(authnContextEntry);
        }
        browserSso.setAuthnContextMappings(authnContextMappings);
    }

    private void apiToDomainSsoServiceEndpoint(List<IdpSsoServiceEndpoint> apiSsoEndpoints, org.sourceid.websso.Protocol protocol, EndpointGroup domainSsoEndpointGroup) {
        if (apiSsoEndpoints == null || apiSsoEndpoints.isEmpty()) {
            return;
        }
        DomainTranslator bindingTranslator = DomainTranslator.getTranslator((org.sourceid.websso.Protocol)protocol);
        for (IdpSsoServiceEndpoint ssoEndpoint : apiSsoEndpoints) {
            String newBinding = protocol == org.sourceid.websso.Protocol.WSFED && ssoEndpoint.getBinding() == null ? "wsfed:prp:http:get" : (protocol == org.sourceid.websso.Protocol.SAML10 || protocol == org.sourceid.websso.Protocol.SAML11 ? "DestinationSiteFirstBinding:simple:http:302" : bindingTranslator.toBindingUri(ssoEndpoint.getBinding().getGuiName()));
            String newLocation = ssoEndpoint.getUrl();
            domainSsoEndpointGroup.getEndpoints().add(new Endpoint(newBinding, newLocation));
        }
    }

    private void domainToApiSsoServiceEndpoint(EndpointGroup domainSsoEndpointGroup, org.sourceid.websso.Protocol protocol, IdpBrowserSso idpBrowserSso) {
        LinkedList<IdpSsoServiceEndpoint> ssoServiceEndpoints = new LinkedList<IdpSsoServiceEndpoint>();
        DomainTranslator bindingTranslator = DomainTranslator.getTranslator((org.sourceid.websso.Protocol)protocol);
        for (Endpoint endpoint : domainSsoEndpointGroup.getEndpoints()) {
            String bindingUri = endpoint.getBinding();
            String bindingName = bindingTranslator.toBindingGuiName(bindingUri);
            Binding bindingModel = Binding.fromGuiName(bindingName);
            if ((bindingModel == null || !SUPPORTED_SSO_BINDINGS.contains((Object)bindingModel)) && protocol != org.sourceid.websso.Protocol.WSFED && protocol != org.sourceid.websso.Protocol.SAML10 && protocol != org.sourceid.websso.Protocol.SAML11) continue;
            IdpSsoServiceEndpoint ssoServiceEndpoint = new IdpSsoServiceEndpoint();
            ssoServiceEndpoint.setBinding(bindingModel);
            ssoServiceEndpoint.setUrl(endpoint.getLocation());
            ssoServiceEndpoints.add(ssoServiceEndpoint);
        }
        idpBrowserSso.setSsoServiceEndpoints(ssoServiceEndpoints);
    }

    private void apiToDomain(DecryptionPolicy apiDecryptPolicy, EncryptionSettings domainEncryptionSettings) {
        org.sourceid.saml20.domain.DecryptionPolicy domainDecryptPolicy = domainEncryptionSettings.getDecryptionPolicy();
        if (apiDecryptPolicy == null) {
            apiDecryptPolicy = new DecryptionPolicy();
        }
        domainDecryptPolicy.setAssertionEncrypted(apiDecryptPolicy.isAssertionEncrypted());
        domainDecryptPolicy.setAttributeEncrypted(apiDecryptPolicy.isAttributesEncrypted());
        domainDecryptPolicy.setSubjectNameIDEncrypted(apiDecryptPolicy.isSubjectNameIdEncrypted());
        domainDecryptPolicy.setSloSubjectNameIDEncrypted(apiDecryptPolicy.isSloSubjectNameIDEncrypted());
        domainEncryptionSettings.getEncryptionPolicy().setSloEncryptSubjectNameID(apiDecryptPolicy.isSloEncryptSubjectNameID());
    }

    private void domainToApi(EncryptionSettings domainEncryptionSettings, DecryptionPolicy apiDecryptPolicy) {
        org.sourceid.saml20.domain.DecryptionPolicy domainDecryptPolicy = domainEncryptionSettings.getDecryptionPolicy();
        apiDecryptPolicy.setAssertionEncrypted(domainDecryptPolicy.isAssertionEncrypted());
        apiDecryptPolicy.setAttributesEncrypted(domainDecryptPolicy.isAttributeEncrypted());
        apiDecryptPolicy.setSubjectNameIdEncrypted(domainDecryptPolicy.isSubjectNameIDEncrypted());
        apiDecryptPolicy.setSloEncryptSubjectNameID(domainEncryptionSettings.getEncryptionPolicy().isSloEncryptSubjectNameID());
        apiDecryptPolicy.setSloSubjectNameIDEncrypted(domainDecryptPolicy.isSloSubjectNameIDEncrypted());
    }

    private boolean isBrowserSSOProfileEnabled(org.sourceid.websso.Protocol protocol) {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableProtocolSp(protocol);
    }

    static {
        SUPPORTED_DOMAIN_PROTOCOLS.add(org.sourceid.websso.Protocol.SAML20);
        SUPPORTED_DOMAIN_PROTOCOLS.add(org.sourceid.websso.Protocol.SAML11);
        SUPPORTED_DOMAIN_PROTOCOLS.add(org.sourceid.websso.Protocol.SAML10);
        SUPPORTED_DOMAIN_PROTOCOLS.add(org.sourceid.websso.Protocol.WSFED);
        SUPPORTED_DOMAIN_PROTOCOLS.add(org.sourceid.websso.Protocol.OIDC);
        SUPPORTED_SSO_BINDINGS.add(Binding.ARTIFACT);
        SUPPORTED_SSO_BINDINGS.add(Binding.POST);
        SUPPORTED_SSO_BINDINGS.add(Binding.REDIRECT);
    }
}

