/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.IdpOAuthAttribute;
import com.pingidentity.admin.api.model.IdpOAuthAttributeContract;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.OAuthAssertionGrantAttributeContract;
import org.sourceid.saml20.domain.OAuthSettings;
import org.sourceid.websso.Protocol;

public class IdpConnectionOAuthAttributeContractTranslator {
    public void apiToDomain(IdpConnection apiConn, org.sourceid.saml20.domain.IdpConnection domainConn) {
        IdpOAuthAttributeContract apiContract;
        if (apiConn.getIdpOAuthGrantAttributeMapping() != null && (apiContract = apiConn.getIdpOAuthGrantAttributeMapping().getIdpOAuthAttributeContract()) != null) {
            String attrName;
            domainConn.setOAuthSettings(new OAuthSettings());
            OAuthAssertionGrantAttributeContract domainContract = new OAuthAssertionGrantAttributeContract();
            HashSet<String> maskedAttrNames = new HashSet<String>();
            for (IdpBrowserSsoAttribute immutableAttr : apiContract.getCoreAttributes()) {
                attrName = immutableAttr.getName();
                if (attrName == null || !domainContract.isImmutable(attrName) || !immutableAttr.isMasked().booleanValue()) continue;
                maskedAttrNames.add(attrName);
            }
            for (IdpBrowserSsoAttribute mutableAttr : apiContract.getExtendedAttributes()) {
                attrName = mutableAttr.getName();
                if (mutableAttr.isMasked().booleanValue()) {
                    maskedAttrNames.add(attrName);
                }
                domainContract.addMutableAttributeName(attrName);
            }
            domainContract.setMaskedAttributeNames(maskedAttrNames);
            domainConn.getOAuthSettings().setOAuthAssertionGrantAttributeContract(domainContract);
        }
    }

    public void domainToApi(org.sourceid.saml20.domain.IdpConnection domainConn, IdpConnection apiConn) {
        if (domainConn.getOAuthSettings() != null) {
            OAuthAssertionGrantAttributeContract domainContract = domainConn.getOAuthSettings().getOAuthAssertionGrantAttributeContract();
            Set maskedAttrNames = domainConn.getMaskedAttributeNames();
            for (String immutableAttrName : domainContract.getImmutableAttributeNames()) {
                IdpOAuthAttribute immutableAttr = new IdpOAuthAttribute();
                immutableAttr.setName(immutableAttrName);
                if (domainConn.getProtocol() != Protocol.WSFED) {
                    immutableAttr.setMasked(maskedAttrNames.contains(immutableAttrName));
                } else {
                    immutableAttr.setMasked(null);
                }
                apiConn.getIdpOAuthGrantAttributeMapping().getIdpOAuthAttributeContract().getCoreAttributes().add(immutableAttr);
            }
            for (String mutableAttrName : domainContract.getMutableAttributeNames()) {
                IdpOAuthAttribute mutableAttr = new IdpOAuthAttribute();
                mutableAttr.setName(mutableAttrName);
                mutableAttr.setMasked(maskedAttrNames.contains(mutableAttrName));
                apiConn.getIdpOAuthGrantAttributeMapping().getIdpOAuthAttributeContract().getExtendedAttributes().add(mutableAttr);
            }
        }
    }
}

