/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.IdpWsTrust;
import com.pingidentity.admin.api.model.IdpWsTrustAttribute;
import com.pingidentity.admin.api.model.IdpWsTrustAttributeContract;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;

public class IdpConnectionWsTrustAttributeContractTranslator {
    public void domainToApi(org.sourceid.saml20.domain.IdpConnection domainConn, IdpConnection apiConn) {
        IdpWsTrustAttributeContract apiContract = apiConn.getWsTrust().getAttributeContract();
        WsTrustTokenAttributeContract domainContract = domainConn.getWsTrustSettings().getAttributeContract();
        Set maskedAttributes = domainContract.getMaskedAttributeNames() == null ? new HashSet() : domainContract.getMaskedAttributeNames();
        for (String immutableAttrName : domainContract.getImmutableAttributeNames()) {
            IdpWsTrustAttribute immutableAttr = new IdpWsTrustAttribute();
            immutableAttr.setName(immutableAttrName);
            immutableAttr.setMasked(maskedAttributes.contains(immutableAttrName));
            apiContract.getCoreAttributes().add(immutableAttr);
        }
        for (String mutableAttrName : domainContract.getMutableAttributeNames()) {
            IdpWsTrustAttribute mutableAttr = new IdpWsTrustAttribute();
            mutableAttr.setName(mutableAttrName);
            mutableAttr.setMasked(maskedAttributes.contains(mutableAttrName));
            apiContract.getExtendedAttributes().add(mutableAttr);
        }
    }

    public void apiToDomain(IdpConnection apiConn, org.sourceid.saml20.domain.IdpConnection domainConn) {
        WsTrustFederatedWspSettings domainSettings = domainConn.getWsTrustSettings();
        IdpWsTrust settings = apiConn.getWsTrust();
        WsTrustTokenAttributeContract wsTrustAttributeContract = new WsTrustTokenAttributeContract();
        HashSet<String> maskedAttributes = new HashSet<String>();
        HashSet<String> coreAttributes = new HashSet<String>();
        for (IdpWsTrustAttribute coreAttribute : settings.getAttributeContract().getCoreAttributes()) {
            coreAttributes.add(coreAttribute.getName());
        }
        wsTrustAttributeContract.setImmutableAttributeNames(coreAttributes);
        HashSet<String> mutableAttributes = new HashSet<String>();
        HashMap<String, String> mutableAttributesInfo = new HashMap<String, String>();
        for (IdpWsTrustAttribute mutableAttribute : settings.getAttributeContract().getExtendedAttributes()) {
            mutableAttributes.add(mutableAttribute.getName());
            mutableAttributesInfo.put(mutableAttribute.getName(), "");
            if (!mutableAttribute.isMasked().booleanValue()) continue;
            maskedAttributes.add(mutableAttribute.getName());
        }
        wsTrustAttributeContract.setMutableAttributeNames(mutableAttributes);
        wsTrustAttributeContract.setMutableAttributesInfo(mutableAttributesInfo);
        wsTrustAttributeContract.setMaskedAttributeNames(maskedAttributes);
        domainSettings.setAttributeContract(wsTrustAttributeContract);
    }
}

