/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.MaskableAttribute;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.Schema;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.sso.idp.Groups;
import com.pingidentity.admin.api.model.sso.idp.IdentityStoreInboundProvisioningUserRepository;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioning;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioningAttribute;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioningAttributeContract;
import com.pingidentity.admin.api.model.sso.idp.LdapInboundProvisioningUserRepository;
import com.pingidentity.admin.api.model.sso.idp.ReadGroups;
import com.pingidentity.admin.api.model.sso.idp.ReadUsers;
import com.pingidentity.admin.api.model.sso.idp.Scim2Schema;
import com.pingidentity.admin.api.model.sso.idp.Scim2SchemaAttribute;
import com.pingidentity.admin.api.model.sso.idp.ScimDeleteUsersBehavior;
import com.pingidentity.admin.api.model.sso.idp.ServiceProviderConfig;
import com.pingidentity.admin.api.model.sso.idp.Users;
import com.pingidentity.admin.api.model.sso.idp.WriteGroups;
import com.pingidentity.admin.api.model.sso.idp.WriteUsers;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.SchemaAttributeTranslator;
import com.pingidentity.pf.admin.rest.translator.Scim2SchemaAttributeTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.MaskedAttributeContract;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.scim.ScimVersion;

public class IdpInboundProvisioningTranslator {
    private final SchemaAttributeTranslator schemaAttributeTranslator = new SchemaAttributeTranslator();
    private final Scim2SchemaAttributeTranslator scim2SchemaAttributeTranslator = new Scim2SchemaAttributeTranslator();

    public void apiToDomain(com.pingidentity.admin.api.model.IdpConnection apiConn, IdpConnection domainConn) {
        if (apiConn.getInboundProvisioning() == null) {
            return;
        }
        IdpInboundProvisioning apiInboundProvisioning = apiConn.getInboundProvisioning();
        ScimUserProvisioning domainInboundProvisioning = new ScimUserProvisioning();
        domainInboundProvisioning.setVersion(apiInboundProvisioning.getScimVersion().getCorrespondingDomainScimVersion());
        this.apiToDomainUserRepository(apiInboundProvisioning, domainInboundProvisioning);
        if (ScimVersion.SCIM11.equals((Object)domainInboundProvisioning.getVersion())) {
            this.apiToDomainCustomScim11Attributes(apiInboundProvisioning, domainInboundProvisioning);
        } else if (ScimVersion.SCIM20.equals((Object)domainInboundProvisioning.getVersion())) {
            this.apiToDomainScim2ServiceProviderConfig(apiInboundProvisioning, domainInboundProvisioning);
            this.apiToDomainCustomScim2Attributes(apiInboundProvisioning, domainInboundProvisioning);
        }
        this.apiToDomainUsers(apiInboundProvisioning, domainInboundProvisioning);
        if (apiInboundProvisioning.isGroupSupport()) {
            this.apiToDomainGroups(apiInboundProvisioning, domainInboundProvisioning);
        }
        this.apiToDomainDeleteUsersBehavior(apiInboundProvisioning, domainInboundProvisioning);
        domainConn.setInboundProvisioning(domainInboundProvisioning);
    }

    private void apiToDomainUserRepository(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        switch (apiInboundProvisioning.getUserRepository().getType()) {
            case IDENTITY_STORE: {
                domainInboundProvisioning.setUserRepositoryType(InboundProvisioningUserRepositoryType.IDENTITY_STORE);
                IdentityStoreInboundProvisioningUserRepository identityStoreInboundProvisioningUserRepository = (IdentityStoreInboundProvisioningUserRepository)apiInboundProvisioning.getUserRepository();
                domainInboundProvisioning.setIdentityStoreProvisionerId(identityStoreInboundProvisioningUserRepository.getIdentityStoreProvisionerRef().getId());
                break;
            }
            case LDAP: {
                domainInboundProvisioning.setUserRepositoryType(InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY);
                LdapInboundProvisioningUserRepository ldapInboundProvisioningUserRepository = (LdapInboundProvisioningUserRepository)apiInboundProvisioning.getUserRepository();
                this.apiToDomainLdapAttributeSource(ldapInboundProvisioningUserRepository, domainInboundProvisioning, apiInboundProvisioning.isGroupSupport());
            }
        }
    }

    private void apiToDomainLdapAttributeSource(LdapInboundProvisioningUserRepository apiUserRepository, ScimUserProvisioning domainInboundProvisioning, boolean isGroupSupport) {
        if (isGroupSupport) {
            LdapAttributeSource domainGroupsLdapAttributeSource = new LdapAttributeSource();
            domainGroupsLdapAttributeSource.setId(apiUserRepository.getDataStoreRef().getId());
            domainGroupsLdapAttributeSource.setDataSourceId(apiUserRepository.getDataStoreRef().getId());
            domainGroupsLdapAttributeSource.setParameter("search_base", apiUserRepository.getBaseDn());
            domainGroupsLdapAttributeSource.setParameter("filter", apiUserRepository.getUniqueGroupIdFilter());
            domainInboundProvisioning.getWriteGroupsAttributeMapping().setAttributeSource((AttributeSource)domainGroupsLdapAttributeSource);
            domainInboundProvisioning.getReadGroupsAttributeMapping().setAttributeSource((AttributeSource)domainGroupsLdapAttributeSource);
        }
        LdapAttributeSource domainUsersLdapAttributeSource = new LdapAttributeSource();
        domainUsersLdapAttributeSource.setId(apiUserRepository.getDataStoreRef().getId());
        domainUsersLdapAttributeSource.setDataSourceId(apiUserRepository.getDataStoreRef().getId());
        domainUsersLdapAttributeSource.setParameter("search_base", apiUserRepository.getBaseDn());
        domainUsersLdapAttributeSource.setParameter("filter", apiUserRepository.getUniqueUserIdFilter());
        domainUsersLdapAttributeSource.setParameter("search_scope", "ONELEVEL_SCOPE");
        domainUsersLdapAttributeSource.setParameter("memberof_nested_group", "false");
        domainInboundProvisioning.getWriteUsersAttributeMapping().setAttributeSource((AttributeSource)domainUsersLdapAttributeSource);
        domainInboundProvisioning.getReadUsersAttributeMapping().setAttributeSource((AttributeSource)domainUsersLdapAttributeSource);
    }

    private void apiToDomainCustomScim11Attributes(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        Schema apiSchema = apiInboundProvisioning.getCustomSchema();
        org.sourceid.saml20.domain.scim.model.Schema domainSchema = new org.sourceid.saml20.domain.scim.model.Schema();
        ArrayList<org.sourceid.saml20.domain.scim.model.SchemaAttribute> domainSchemaAttrs = new ArrayList<org.sourceid.saml20.domain.scim.model.SchemaAttribute>();
        domainSchema.setAttributes(domainSchemaAttrs);
        if (apiSchema != null) {
            domainSchema.setSchema(apiSchema.getNamespace());
            domainSchema.setSchemas(Collections.singleton(apiSchema.getNamespace()));
            List<SchemaAttribute> schemaAttributes = apiSchema.getAttributes();
            for (SchemaAttribute attribute : schemaAttributes) {
                org.sourceid.saml20.domain.scim.model.SchemaAttribute domainSchemaAttr = this.schemaAttributeTranslator.apiToDomain(attribute, apiSchema.getNamespace());
                domainSchemaAttrs.add(domainSchemaAttr);
            }
        } else {
            domainSchema.setSchema("urn:scim:schemas:extension:custom:1.0");
            domainSchema.setSchemas(Collections.singleton("urn:scim:schemas:extension:custom:1.0"));
        }
        domainInboundProvisioning.setCustomScim(domainSchema);
    }

    private void apiToDomainCustomScim2Attributes(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        Scim2Schema apiSchema = apiInboundProvisioning.getCustomScim2Schema();
        org.sourceid.saml20.domain.scim.model.Scim2Schema domainSchema = new org.sourceid.saml20.domain.scim.model.Scim2Schema();
        ArrayList<org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute> domainSchemaAttrs = new ArrayList<org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute>();
        domainSchema.setAttributes(domainSchemaAttrs);
        if (apiSchema != null) {
            domainSchema.setSchema(apiSchema.getNamespace());
            List<Scim2SchemaAttribute> schemaAttributes = apiSchema.getAttributes();
            for (Scim2SchemaAttribute attribute : schemaAttributes) {
                org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute domainSchemaAttr = this.scim2SchemaAttributeTranslator.apiToDomain(attribute);
                domainSchemaAttrs.add(domainSchemaAttr);
            }
        } else {
            domainSchema.setSchema("urn:scim:schemas:extension:custom:2.0");
        }
        domainInboundProvisioning.setCustomScim2Schema(domainSchema);
    }

    private void apiToDomainScim2ServiceProviderConfig(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        ServiceProviderConfig apiConfig = apiInboundProvisioning.getServiceProviderConfig();
        if (apiConfig != null && StringUtils.isNotEmpty((String)apiConfig.getDocumentationUri())) {
            domainInboundProvisioning.setDocumentationUri(apiConfig.getDocumentationUri());
        }
    }

    private void apiToDomainUsers(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        Users apiUsers = apiInboundProvisioning.getUsers();
        this.apiToDomainWriteUsers(apiUsers.getWriteUsers(), domainInboundProvisioning);
        this.apiToDomainReadUsers(apiUsers.getWriteUsers(), apiUsers.getReadUsers(), domainInboundProvisioning);
    }

    private void apiToDomainWriteUsers(WriteUsers writeUsers, ScimUserProvisioning domainInboundProvisioning) {
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        attributeMappingTranslator.apiToDomain(writeUsers.getAttributeFulfillment(), domainInboundProvisioning.getWriteUsersAttributeMapping().getAttributeMapping());
    }

    private void apiToDomainReadUsers(WriteUsers writeUsers, ReadUsers readUsers, ScimUserProvisioning domainInboundProvisioning) {
        MaskedAttributeContract attributeContract = new MaskedAttributeContract(Collections.emptySet());
        SourceTypeIdKey scimUserKey = new SourceTypeIdKey(SourceType.SCIM_USER);
        Set coreAttributeNames = writeUsers.getAttributeFulfillment().values().stream().filter(a -> a.getSource() == scimUserKey).map(AttributeFulfillmentValue::getValue).collect(Collectors.toSet());
        attributeContract.setImmutableAttributeNames(coreAttributeNames);
        Set extendedAttributeNames = Optional.ofNullable(readUsers.getAttributeContract()).orElse(new IdpInboundProvisioningAttributeContract()).getExtendedAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        attributeContract.setMutableAttributeNames(extendedAttributeNames);
        Set maskedAttributeNames = Optional.ofNullable(readUsers.getAttributeContract()).orElse(new IdpInboundProvisioningAttributeContract()).getExtendedAttributes().stream().filter(MaskableAttribute::isMasked).map(Attribute::getName).collect(Collectors.toSet());
        attributeContract.setMaskedAttributeNames(maskedAttributeNames);
        domainInboundProvisioning.setReadUsersAttributeContract(attributeContract);
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        attributeMappingTranslator.apiToDomain(readUsers.getAttributeFulfillment(), domainInboundProvisioning.getReadUsersAttributeMapping().getAttributeMapping());
    }

    private void apiToDomainGroups(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        Groups apiGroups = apiInboundProvisioning.getGroups();
        this.apiToDomainWriteGroups(apiGroups.getWriteGroups(), domainInboundProvisioning);
        this.apiToDomainReadGroups(apiGroups.getWriteGroups(), apiGroups.getReadGroups(), domainInboundProvisioning);
    }

    private void apiToDomainWriteGroups(WriteGroups writeGroups, ScimUserProvisioning domainInboundProvisioning) {
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        attributeMappingTranslator.apiToDomain(writeGroups.getAttributeFulfillment(), domainInboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping());
    }

    private void apiToDomainReadGroups(WriteGroups writeGroups, ReadGroups readGroups, ScimUserProvisioning domainInboundProvisioning) {
        MaskedAttributeContract attributeContract = new MaskedAttributeContract(Collections.emptySet());
        SourceTypeIdKey scimGroupKey = new SourceTypeIdKey(SourceType.SCIM_GROUP);
        Set coreAttributeNames = writeGroups.getAttributeFulfillment().values().stream().filter(a -> a.getSource() == scimGroupKey).map(AttributeFulfillmentValue::getValue).collect(Collectors.toSet());
        attributeContract.setImmutableAttributeNames(coreAttributeNames);
        Set extendedAttributeNames = readGroups.getAttributeContract().getExtendedAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        attributeContract.setMutableAttributeNames(extendedAttributeNames);
        Set maskedAttributeNames = readGroups.getAttributeContract().getExtendedAttributes().stream().filter(MaskableAttribute::isMasked).map(Attribute::getName).collect(Collectors.toSet());
        attributeContract.setMaskedAttributeNames(maskedAttributeNames);
        domainInboundProvisioning.setReadGroupsAttributeContract(attributeContract);
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        attributeMappingTranslator.apiToDomain(readGroups.getAttributeFulfillment(), domainInboundProvisioning.getReadGroupsAttributeMapping().getAttributeMapping());
    }

    private void apiToDomainDeleteUsersBehavior(IdpInboundProvisioning apiInboundProvisioning, ScimUserProvisioning domainInboundProvisioning) {
        if (com.pingidentity.admin.api.model.sso.idp.InboundProvisioningUserRepositoryType.LDAP.equals((Object)apiInboundProvisioning.getUserRepository().getType())) {
            switch (apiInboundProvisioning.getActionOnDelete()) {
                case DISABLE_USER: {
                    domainInboundProvisioning.setPermanentlyDeleteUsersOnDelete(false);
                    break;
                }
                case PERMANENTLY_DELETE_USER: {
                    domainInboundProvisioning.setPermanentlyDeleteUsersOnDelete(true);
                    break;
                }
            }
        }
    }

    public void domainToApi(IdpConnection domainConn, com.pingidentity.admin.api.model.IdpConnection apiConn) {
        if (domainConn.getInboundProvisioning() == null) {
            return;
        }
        ScimUserProvisioning domainInboundProvisioning = domainConn.getInboundProvisioning();
        IdpInboundProvisioning apiInboundProvisioning = new IdpInboundProvisioning();
        apiInboundProvisioning.setScimVersion(com.pingidentity.admin.api.model.ScimVersion.getApiScimVersionFromDomainScimVersion(domainInboundProvisioning.getVersion()));
        boolean isGroupSupported = this.isGroupSupported(domainInboundProvisioning);
        apiInboundProvisioning.setGroupSupport(isGroupSupported);
        this.domainToApiUserRepository(domainInboundProvisioning, apiInboundProvisioning);
        if (ScimVersion.SCIM11.equals((Object)domainInboundProvisioning.getVersion())) {
            this.domainToApiCustomScim11Attributes(domainInboundProvisioning, apiInboundProvisioning);
        } else {
            this.domainToApiScim2ServiceProviderConfig(domainInboundProvisioning, apiInboundProvisioning);
            this.domainToApiCustomScim20Attributes(domainInboundProvisioning, apiInboundProvisioning);
        }
        this.domainToApiUsers(domainInboundProvisioning, apiInboundProvisioning);
        if (isGroupSupported) {
            this.domainToApiGroups(domainInboundProvisioning, apiInboundProvisioning);
        }
        this.domainToApiDeleteUsersBehavior(domainInboundProvisioning, apiInboundProvisioning);
        apiConn.setInboundProvisioning(apiInboundProvisioning);
    }

    private boolean isGroupSupported(ScimUserProvisioning domainInboundProvisioning) {
        return domainInboundProvisioning.getWriteGroupsAttributeMapping() != null && domainInboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping() != null && !domainInboundProvisioning.getWriteGroupsAttributeMapping().getAttributeMapping().isEmpty();
    }

    private void domainToApiUserRepository(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        switch (domainInboundProvisioning.getUserRepositoryType()) {
            case ACTIVE_DIRECTORY: {
                LdapInboundProvisioningUserRepository apiUserRepository = new LdapInboundProvisioningUserRepository();
                this.domainToApiLdapAttributeSource(domainInboundProvisioning, apiUserRepository);
                apiInboundProvisioning.setUserRepository(apiUserRepository);
                break;
            }
            case IDENTITY_STORE: {
                IdentityStoreInboundProvisioningUserRepository apiUserRepository = new IdentityStoreInboundProvisioningUserRepository();
                ResourceLink pluginDescriptorRef = this.getResourceLinkFromDomain(domainInboundProvisioning.getIdentityStoreProvisionerId());
                apiUserRepository.setIdentityStoreProvisionerRef(pluginDescriptorRef);
                apiInboundProvisioning.setUserRepository(apiUserRepository);
                break;
            }
        }
    }

    private void domainToApiLdapAttributeSource(ScimUserProvisioning domainInboundProvisioning, LdapInboundProvisioningUserRepository apiUserRepository) {
        LdapAttributeSource domainLdapUserAttributeSource = (LdapAttributeSource)domainInboundProvisioning.getWriteUsersAttributeMapping().getAttributeSource();
        apiUserRepository.setUniqueUserIdFilter(domainLdapUserAttributeSource.getParameter("filter"));
        if (this.isGroupSupported(domainInboundProvisioning)) {
            LdapAttributeSource domainLdapGroupAttributeSource = (LdapAttributeSource)domainInboundProvisioning.getWriteGroupsAttributeMapping().getAttributeSource();
            apiUserRepository.setUniqueGroupIdFilter(domainLdapGroupAttributeSource.getParameter("filter"));
        }
        ResourceLink ldapDataSourceResourceLink = this.getResourceLinkFromDomain((AttributeSource)domainLdapUserAttributeSource);
        apiUserRepository.setDataStoreRef(ldapDataSourceResourceLink);
        apiUserRepository.setBaseDn(domainLdapUserAttributeSource.getParameter("search_base"));
    }

    private void domainToApiCustomScim11Attributes(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        org.sourceid.saml20.domain.scim.model.Schema schema = domainInboundProvisioning.getCustomScim();
        if (schema != null) {
            Schema apiSchema = new Schema();
            apiSchema.setNamespace(schema.getSchema());
            if (schema.getAttributes() != null) {
                ArrayList<SchemaAttribute> apiSchemaAttributes = new ArrayList<SchemaAttribute>();
                for (org.sourceid.saml20.domain.scim.model.SchemaAttribute attribute : schema.getAttributes()) {
                    SchemaAttribute apiAttribute = this.schemaAttributeTranslator.domainToApi(attribute);
                    apiSchemaAttributes.add(apiAttribute);
                }
                apiSchema.setAttributes(apiSchemaAttributes);
                apiInboundProvisioning.setCustomSchema(apiSchema);
            }
        }
    }

    private void domainToApiCustomScim20Attributes(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        org.sourceid.saml20.domain.scim.model.Scim2Schema schema = domainInboundProvisioning.getCustomScim2Schema();
        if (schema != null) {
            Scim2Schema apiSchema = new Scim2Schema();
            apiSchema.setNamespace(schema.getSchema());
            if (schema.getAttributes() != null) {
                ArrayList<Scim2SchemaAttribute> apiSchemaAttributes = new ArrayList<Scim2SchemaAttribute>();
                for (org.sourceid.saml20.domain.scim.model.Scim2SchemaAttribute attribute : schema.getAttributes()) {
                    Scim2SchemaAttribute apiAttribute = this.scim2SchemaAttributeTranslator.domainToApi(attribute);
                    apiSchemaAttributes.add(apiAttribute);
                }
                apiSchema.setAttributes(apiSchemaAttributes);
                apiInboundProvisioning.setCustomScim2Schema(apiSchema);
            }
        }
    }

    private void domainToApiScim2ServiceProviderConfig(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        String documentationUri = domainInboundProvisioning.getDocumentationUri();
        if (StringUtils.isNotEmpty((String)documentationUri)) {
            ServiceProviderConfig apiConfig = new ServiceProviderConfig();
            apiConfig.setDocumentationUri(documentationUri);
            apiInboundProvisioning.setServiceProviderConfig(apiConfig);
        }
    }

    private void domainToApiUsers(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        Users apiUsers = new Users();
        this.domainToApiWriteUsers(domainInboundProvisioning, apiUsers);
        this.domainToApiReadUsers(domainInboundProvisioning, apiUsers);
        apiInboundProvisioning.setUsers(apiUsers);
    }

    private void domainToApiWriteUsers(ScimUserProvisioning domainInboundProvisioning, Users apiUsers) {
        WriteUsers apiWriteUsers = new WriteUsers();
        AttributeMapping domainWriteUsersAttributeMapping = domainInboundProvisioning.getWriteUsersAttributeMapping();
        Map<String, AttributeFulfillmentValue> apiWriteUsersAttributeFulfillment = this.domainToApiAttributeMapping(domainWriteUsersAttributeMapping);
        apiWriteUsers.setAttributeFulfillment(apiWriteUsersAttributeFulfillment);
        apiUsers.setWriteUsers(apiWriteUsers);
    }

    private void domainToApiReadUsers(ScimUserProvisioning domainInboundProvisioning, Users apiUsers) {
        ReadUsers apiReadUsers = new ReadUsers();
        MaskedAttributeContract domainReadUsersAttributeContract = domainInboundProvisioning.getReadUsersAttributeContract();
        IdpInboundProvisioningAttributeContract apiReadUsersAttributeContract = new IdpInboundProvisioningAttributeContract();
        LinkedList<IdpInboundProvisioningAttribute> coreAttributes = new LinkedList<IdpInboundProvisioningAttribute>();
        for (Object attributeName : domainReadUsersAttributeContract.getSortedImmutableAttributeNames()) {
            IdpInboundProvisioningAttribute attribute = new IdpInboundProvisioningAttribute();
            attribute.setName((String)attributeName);
            coreAttributes.add(attribute);
        }
        apiReadUsersAttributeContract.setCoreAttributes(coreAttributes);
        LinkedList<IdpInboundProvisioningAttribute> extendedAttributes = new LinkedList<IdpInboundProvisioningAttribute>();
        for (String attributeName : domainReadUsersAttributeContract.getSortedMutableAttributeNames()) {
            IdpInboundProvisioningAttribute attribute = new IdpInboundProvisioningAttribute();
            attribute.setName(attributeName);
            attribute.setMasked(domainReadUsersAttributeContract.isMaskedAttribute(attributeName));
            extendedAttributes.add(attribute);
        }
        apiReadUsersAttributeContract.setExtendedAttributes(extendedAttributes);
        apiReadUsers.setAttributeContract(apiReadUsersAttributeContract);
        AttributeMapping domainReadUsersAttributeMapping = domainInboundProvisioning.getReadUsersAttributeMapping();
        Map<String, AttributeFulfillmentValue> apiReadUsersAttributeFulfillment = this.domainToApiAttributeMapping(domainReadUsersAttributeMapping);
        List<Attribute> attributes = this.getSelectedAttributeListFromMapping(domainReadUsersAttributeMapping.getAttributeMapping());
        apiReadUsers.setAttributes(attributes);
        apiReadUsers.setAttributeFulfillment(apiReadUsersAttributeFulfillment);
        apiUsers.setReadUsers(apiReadUsers);
    }

    private void domainToApiGroups(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        Groups apiGroups = new Groups();
        this.domainToApiWriteGroups(domainInboundProvisioning, apiGroups);
        this.domainToApiReadGroups(domainInboundProvisioning, apiGroups);
        apiInboundProvisioning.setGroups(apiGroups);
    }

    private void domainToApiWriteGroups(ScimUserProvisioning domainInboundProvisioning, Groups apiGroups) {
        WriteGroups apiWriteGroups = new WriteGroups();
        AttributeMapping domainWriteGroupsAttributeMapping = domainInboundProvisioning.getWriteGroupsAttributeMapping();
        Map<String, AttributeFulfillmentValue> apiWriteGroupsAttributeFulfillment = this.domainToApiAttributeMapping(domainWriteGroupsAttributeMapping);
        apiWriteGroups.setAttributeFulfillment(apiWriteGroupsAttributeFulfillment);
        apiGroups.setWriteGroups(apiWriteGroups);
    }

    private void domainToApiReadGroups(ScimUserProvisioning domainInboundProvisioning, Groups apiGroups) {
        ReadGroups apiReadGroups = new ReadGroups();
        MaskedAttributeContract domainReadGroupsAttributeContract = domainInboundProvisioning.getReadGroupsAttributeContract();
        IdpInboundProvisioningAttributeContract apiReadGroupsAttributeContract = new IdpInboundProvisioningAttributeContract();
        LinkedList<IdpInboundProvisioningAttribute> coreAttributes = new LinkedList<IdpInboundProvisioningAttribute>();
        for (Object attributeName : domainReadGroupsAttributeContract.getSortedImmutableAttributeNames()) {
            IdpInboundProvisioningAttribute attribute = new IdpInboundProvisioningAttribute();
            attribute.setName((String)attributeName);
            coreAttributes.add(attribute);
        }
        apiReadGroupsAttributeContract.setCoreAttributes(coreAttributes);
        LinkedList<IdpInboundProvisioningAttribute> extendedAttributes = new LinkedList<IdpInboundProvisioningAttribute>();
        for (String attributeName : domainReadGroupsAttributeContract.getSortedMutableAttributeNames()) {
            IdpInboundProvisioningAttribute attribute = new IdpInboundProvisioningAttribute();
            attribute.setName(attributeName);
            attribute.setMasked(domainReadGroupsAttributeContract.isMaskedAttribute(attributeName));
            extendedAttributes.add(attribute);
        }
        apiReadGroupsAttributeContract.setExtendedAttributes(extendedAttributes);
        apiReadGroups.setAttributeContract(apiReadGroupsAttributeContract);
        AttributeMapping domainReadGroupsAttributeMapping = domainInboundProvisioning.getReadGroupsAttributeMapping();
        Map<String, AttributeFulfillmentValue> apiReadGroupsAttributeFulfillment = this.domainToApiAttributeMapping(domainReadGroupsAttributeMapping);
        List<Attribute> attributes = this.getSelectedAttributeListFromMapping(domainReadGroupsAttributeMapping.getAttributeMapping());
        apiReadGroups.setAttributes(attributes);
        apiReadGroups.setAttributeFulfillment(apiReadGroupsAttributeFulfillment);
        apiGroups.setReadGroups(apiReadGroups);
    }

    private Map<String, AttributeFulfillmentValue> domainToApiAttributeMapping(AttributeMapping domainAttributeMapping) {
        HashMap<String, AttributeFulfillmentValue> apiAttributeFulfillment = new HashMap<String, AttributeFulfillmentValue>();
        AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();
        attributeMappingTranslator.domainToApi(domainAttributeMapping.getAttributeMapping(), apiAttributeFulfillment);
        return apiAttributeFulfillment;
    }

    private void domainToApiDeleteUsersBehavior(ScimUserProvisioning domainInboundProvisioning, IdpInboundProvisioning apiInboundProvisioning) {
        if (InboundProvisioningUserRepositoryType.ACTIVE_DIRECTORY.equals((Object)domainInboundProvisioning.getUserRepositoryType())) {
            if (domainInboundProvisioning.isPermanentlyDeleteUsersOnDelete()) {
                apiInboundProvisioning.setActionOnDelete(ScimDeleteUsersBehavior.PERMANENTLY_DELETE_USER);
            } else {
                apiInboundProvisioning.setActionOnDelete(ScimDeleteUsersBehavior.DISABLE_USER);
            }
        }
    }

    private ResourceLink getResourceLinkFromDomain(String identityStoreProvisionerId) {
        ResourceLink dsRef = new ResourceLink();
        dsRef.setId(identityStoreProvisionerId);
        dsRef.setLocation(ApiUtil.getResourceUrl("/identityStoreProvisioners", identityStoreProvisionerId));
        return dsRef;
    }

    private ResourceLink getResourceLinkFromDomain(AttributeSource domainSource) {
        ResourceLink dsRef = new ResourceLink();
        dsRef.setId(domainSource.getDataSourceId());
        dsRef.setLocation(ApiUtil.getResourceUrl("/dataStores", domainSource.getDataSourceId()));
        return dsRef;
    }

    private List<Attribute> getSelectedAttributeListFromMapping(Map<String, List<AttrMappingValue>> attributeMapping) {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        if (attributeMapping != null && !attributeMapping.isEmpty()) {
            for (Map.Entry<String, List<AttrMappingValue>> entry : attributeMapping.entrySet()) {
                List<AttrMappingValue> valueList = entry.getValue();
                for (AttrMappingValue val : valueList) {
                    if (val.getType() != org.sourceid.saml20.domain.SourceType.LDAP_DATA_STORE) continue;
                    Attribute attribute = new Attribute();
                    attribute.setName(val.getValue());
                    attributeList.add(attribute);
                }
            }
        }
        return attributeList;
    }
}

