/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.IdpToSpAdapterMapping;
import com.pingidentity.admin.api.validator.IdpToSpAdapterMappingValidator;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpToSpAdapterMappingTranslator {
    public IdpToSpAdapterMapping domainToApi(Direct2SpAdapterMapping domainMapping) {
        IdpToSpAdapterMapping apiMapping = new IdpToSpAdapterMapping();
        apiMapping.setId(ApiUtil.combineId(domainMapping.getSourceId(), domainMapping.getTargetId()));
        apiMapping.setSourceId(domainMapping.getSourceId());
        apiMapping.setTargetId(domainMapping.getTargetId());
        AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
        mappingTranslator.domainToApi((AttributeMapping)domainMapping, apiMapping);
        apiMapping.setDefaultTargetResource(domainMapping.getDefaultTargetResource());
        apiMapping.setLicenseConnectionGroupAssignment(domainMapping.getLicenseConnectionGroupAssignment());
        apiMapping.setApplicationName(domainMapping.getApplicationName());
        if (domainMapping.getApplicationIconUrl() != null) {
            apiMapping.setApplicationIconUrl(domainMapping.getApplicationIconUrl().toExternalForm());
        }
        return apiMapping;
    }

    public Direct2SpAdapterMapping apiToDomain(IdpToSpAdapterMapping apiMapping, boolean isUpdate, IdpToSpAdapterMappingValidator validator) {
        Direct2SpAdapterMapping domainMapping = new Direct2SpAdapterMapping();
        domainMapping.setSourceId(apiMapping.getSourceId());
        domainMapping.setTargetId(apiMapping.getTargetId());
        AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
        mappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        domainMapping.setDefaultTargetResource(apiMapping.getDefaultTargetResource());
        domainMapping.setLicenseConnectionGroupAssignment(apiMapping.getLicenseConnectionGroupAssignment());
        domainMapping.setApplicationName(apiMapping.getApplicationName());
        URL applicationIconUrl = null;
        try {
            applicationIconUrl = new URL(apiMapping.getApplicationIconUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        domainMapping.setApplicationIconUrl(applicationIconUrl);
        return domainMapping;
    }

    public static void cleanupContractFulfillmentMapping(IdpToSpAdapterMapping apiMapping) {
        AuthnAdapterInstance targetAdapter = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(apiMapping.getTargetId());
        Set attributeContract = targetAdapter.getAttributeContract().getAllAttributeNames();
        Map<String, AttributeFulfillmentValue> contractFulfillmentMappings = apiMapping.getAttributeContractFulfillment();
        contractFulfillmentMappings.entrySet().removeIf(entry -> !attributeContract.contains(entry.getKey()));
    }
}

