/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.IdpTokenProcessorMapping;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;

public class IdpTokenProcessorMappingTranslator {
    public void domainToApi(Collection<TokenPluginAttributeMapping> domainMappings, List<IdpTokenProcessorMapping> adapterMappings) {
        adapterMappings.clear();
        for (TokenPluginAttributeMapping domainMapping : domainMappings) {
            ResourceLink resourceId = new ResourceLink();
            String id = domainMapping.getPluginId();
            if (id != null) {
                resourceId.setId(id);
                resourceId.setLocation(ApiUtil.getResourceUrl("/idp/tokenProcessors", id));
            }
            IdpTokenProcessorMapping apiMapping = new IdpTokenProcessorMapping();
            apiMapping.setIdpTokenProcessorRef(resourceId);
            adapterMappings.add(apiMapping);
            AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
            mappingTranslator.domainToApi(domainMapping.getAttributeMapping(), apiMapping);
            if (!domainMapping.isRestrictVirtualServerIds()) continue;
            apiMapping.setRestrictedVirtualEntityIds(domainMapping.getRestrictedVirtualServerIds());
        }
    }

    public void apiToDomain(List<IdpTokenProcessorMapping> adapterMappings, WsTrustFederatedWscSettings wsTrustSettings) {
        ArrayList<TokenPluginAttributeMapping> domainMappings = new ArrayList<TokenPluginAttributeMapping>();
        for (IdpTokenProcessorMapping apiMapping : adapterMappings) {
            TokenPluginAttributeMapping domainMapping = new TokenPluginAttributeMapping();
            domainMappings.add(domainMapping);
            domainMapping.setAttributeMapping(new AttributeMapping());
            String id = apiMapping.getIdpTokenProcessorRef().getId();
            domainMapping.setPluginId(id);
            domainMapping.setRestrictVirtualServerIds(!apiMapping.getRestrictedVirtualEntityIds().isEmpty());
            domainMapping.setRestrictedVirtualServerIds(apiMapping.getRestrictedVirtualEntityIds());
            AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
            mappingTranslator.apiToDomain(apiMapping, domainMapping.getAttributeMapping());
        }
        wsTrustSettings.setTokenToAssertionMappings(domainMappings);
    }
}

