/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.IdpWsTrust;
import com.pingidentity.pf.admin.rest.translator.IdpConnectionWsTrustAttributeContractTranslator;
import com.pingidentity.pf.admin.rest.translator.SpTokenGeneratorMappingTranslator;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpWsTrustTranslator {
    private final LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();

    public void domainToApi(org.sourceid.saml20.domain.IdpConnection domainConn, IdpConnection apiConn) {
        WsTrustFederatedWspSettings settings = domainConn.getWsTrustSettings();
        if (settings == null || !this.localSettings.isEnableWsTrustSp()) {
            return;
        }
        IdpWsTrust wsTrust = new IdpWsTrust();
        apiConn.setWsTrust(wsTrust);
        IdpConnectionWsTrustAttributeContractTranslator attributeContractTranslator = new IdpConnectionWsTrustAttributeContractTranslator();
        attributeContractTranslator.domainToApi(domainConn, apiConn);
        SpTokenGeneratorMappingTranslator tokenGeneratorMappingTranslator = new SpTokenGeneratorMappingTranslator();
        tokenGeneratorMappingTranslator.domainToApi(settings.getAssertionToTokenMappingsMappings(), wsTrust.getTokenGeneratorMappings(), settings.getDefaultAssertionToTokenMappingsMappingId());
        apiConn.getWsTrust().setGenerateLocalToken(wsTrust.getTokenGeneratorMappings() != null && !wsTrust.getTokenGeneratorMappings().isEmpty());
    }

    public void apiToDomain(IdpConnection apiConn, org.sourceid.saml20.domain.IdpConnection domainConn) {
        IdpWsTrust settings = apiConn.getWsTrust();
        if (settings == null) {
            return;
        }
        WsTrustFederatedWspSettings domainSettings = new WsTrustFederatedWspSettings();
        domainConn.setWsTrustSettings(domainSettings);
        if (settings.getGenerateLocalToken()) {
            IdpConnectionWsTrustAttributeContractTranslator attributeContractTranslator = new IdpConnectionWsTrustAttributeContractTranslator();
            attributeContractTranslator.apiToDomain(apiConn, domainConn);
            SpTokenGeneratorMappingTranslator tokenGeneratorMappingTranslator = new SpTokenGeneratorMappingTranslator();
            tokenGeneratorMappingTranslator.apiToDomain(settings.getTokenGeneratorMappings(), domainSettings);
        }
    }
}

