/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.IncomingProxySettings;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LocalSettings;

public class IncomingProxySettingsTranslator {
    private IncomingProxySettingsTranslator() {
    }

    private static IncomingProxySettings.ClientCertHeaderEncodingFormat fromDomain(LocalSettings.ClientCertEncodingFormat domainFormat) {
        if (domainFormat == null) {
            return IncomingProxySettings.ClientCertHeaderEncodingFormat.APACHE_MOD_SSL;
        }
        switch (domainFormat) {
            case APACHE_MOD_SSL: {
                return IncomingProxySettings.ClientCertHeaderEncodingFormat.APACHE_MOD_SSL;
            }
            case NGINX: {
                return IncomingProxySettings.ClientCertHeaderEncodingFormat.NGINX;
            }
        }
        throw new IllegalArgumentException("Unknown client cert encoding format: " + domainFormat);
    }

    private static LocalSettings.ClientCertEncodingFormat toDomain(IncomingProxySettings.ClientCertHeaderEncodingFormat apiFormat) {
        if (apiFormat == null) {
            return LocalSettings.ClientCertEncodingFormat.APACHE_MOD_SSL;
        }
        switch (apiFormat) {
            case APACHE_MOD_SSL: {
                return LocalSettings.ClientCertEncodingFormat.APACHE_MOD_SSL;
            }
            case NGINX: {
                return LocalSettings.ClientCertEncodingFormat.NGINX;
            }
        }
        throw new IllegalArgumentException("Unknown client cert encoding format: " + apiFormat);
    }

    public static IncomingProxySettings domainToApi(LocalSettings localSettings) {
        IncomingProxySettings apiSettings = new IncomingProxySettings();
        apiSettings.setForwardedIpAddressHeaderName(localSettings.getCustomGlobalHttpHeaderName());
        if (StringUtils.isBlank((String)apiSettings.getForwardedIpAddressHeaderName())) {
            apiSettings.setForwardedIpAddressHeaderName(null);
            apiSettings.setForwardedIpAddressHeaderIndex(null);
        } else if (localSettings.getClientIpHeaderIndex().equals((Object)LocalSettings.ForwardedHeaderIndex.LAST)) {
            apiSettings.setForwardedIpAddressHeaderIndex(IncomingProxySettings.ForwardedHeaderIndex.LAST);
        } else {
            apiSettings.setForwardedIpAddressHeaderIndex(IncomingProxySettings.ForwardedHeaderIndex.FIRST);
        }
        apiSettings.setForwardedHostHeaderName(localSettings.getForwardedHostHeaderName());
        if (StringUtils.isBlank((String)apiSettings.getForwardedHostHeaderName())) {
            apiSettings.setForwardedHostHeaderName(null);
            apiSettings.setForwardedHostHeaderIndex(null);
        } else if (localSettings.getForwardedHostHeaderIndex() == LocalSettings.ForwardedHeaderIndex.LAST) {
            apiSettings.setForwardedHostHeaderIndex(IncomingProxySettings.ForwardedHeaderIndex.LAST);
        } else {
            apiSettings.setForwardedHostHeaderIndex(IncomingProxySettings.ForwardedHeaderIndex.FIRST);
        }
        apiSettings.setEnableClientCertHeaderAuth(localSettings.isEnableClientCertAuth());
        IncomingProxySettings.ClientCertHeaderEncodingFormat clientCertHeaderEncodingFormat = IncomingProxySettingsTranslator.fromDomain(localSettings.getClientCertEncodingFormat());
        apiSettings.setClientCertHeaderEncodingFormat(clientCertHeaderEncodingFormat);
        String clientCertSslHeaderName = localSettings.getClientCertSSLHeaderName();
        if (StringUtils.isBlank((String)clientCertSslHeaderName)) {
            apiSettings.setClientCertSSLHeaderName(null);
        } else {
            apiSettings.setClientCertSSLHeaderName(clientCertSslHeaderName);
        }
        String clientCertChainSslHeaderName = localSettings.getClientCertChainSSLHeaderName();
        if (StringUtils.isBlank((String)clientCertChainSslHeaderName)) {
            apiSettings.setClientCertChainSSLHeaderName(null);
        } else {
            apiSettings.setClientCertChainSSLHeaderName(clientCertChainSslHeaderName);
        }
        apiSettings.setProxyTerminatesHttpsConns(localSettings.isProxyTerminatesHttpsConns());
        return apiSettings;
    }

    public static void apiToDomain(IncomingProxySettings apiSettings, LocalSettings domainSettings) {
        domainSettings.setCustomGlobalHttpHeaderName(apiSettings.getForwardedIpAddressHeaderName());
        if (apiSettings.getForwardedIpAddressHeaderIndex().equals((Object)IncomingProxySettings.ForwardedHeaderIndex.LAST)) {
            domainSettings.setClientIpHeaderIndex(LocalSettings.ForwardedHeaderIndex.LAST);
        } else {
            domainSettings.setClientIpHeaderIndex(LocalSettings.ForwardedHeaderIndex.FIRST);
        }
        domainSettings.setForwardedHostHeaderName(apiSettings.getForwardedHostHeaderName());
        if (apiSettings.getForwardedHostHeaderIndex() == IncomingProxySettings.ForwardedHeaderIndex.LAST) {
            domainSettings.setForwardedHostHeaderIndex(LocalSettings.ForwardedHeaderIndex.LAST);
        } else {
            domainSettings.setForwardedHostHeaderIndex(LocalSettings.ForwardedHeaderIndex.FIRST);
        }
        Boolean enableClientCertHeaderAuth = apiSettings.getEnableClientCertHeaderAuth();
        if (enableClientCertHeaderAuth == null) {
            enableClientCertHeaderAuth = StringUtils.isNotBlank((String)apiSettings.getClientCertSSLHeaderName()) || StringUtils.isNotBlank((String)apiSettings.getClientCertChainSSLHeaderName());
        }
        domainSettings.setEnableClientCertAuth(enableClientCertHeaderAuth.booleanValue());
        LocalSettings.ClientCertEncodingFormat clientCertEncodingFormat = IncomingProxySettingsTranslator.toDomain(apiSettings.getClientCertHeaderEncodingFormat());
        domainSettings.setClientCertEncodingFormat(clientCertEncodingFormat);
        domainSettings.setClientCertSSLHeaderName(apiSettings.getClientCertSSLHeaderName());
        domainSettings.setClientCertChainSSLHeaderName(apiSettings.getClientCertChainSSLHeaderName());
        domainSettings.setProxyTerminatesHttpsConns(apiSettings.isProxyTerminatesHttpsConns());
    }
}

