/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.CertView;
import com.pingidentity.admin.api.model.IssuerCert;
import com.pingidentity.admin.api.model.IssuerCerts;
import com.pingidentity.admin.api.model.X509File;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.admin.rest.translator.CertTranslator;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.WsTrustClientCertAuthManager;

public class IssuerCertTranslator {
    private static final Log log = LogFactory.getLog(IssuerCertTranslator.class);
    private static final WsTrustClientCertAuthManager clientCertAuthManager = MgmtFactory.getWsTrustClientCertAuthManager();
    private static final CertTranslator certTranslator = new CertTranslator();

    public IssuerCerts domainToApi() {
        ArrayList<IssuerCert> issuerCerts = new ArrayList<IssuerCert>();
        for (Cert cert : clientCertAuthManager.getCerts()) {
            issuerCerts.add(this.domainToApi(cert));
        }
        return new IssuerCerts(issuerCerts);
    }

    public IssuerCert domainToApi(Cert domainCert) {
        CertView certView = certTranslator.domainToApi(domainCert);
        X509File data = new X509File();
        try {
            data.setFileData(domainCert.exportCert());
            data.setId(domainCert.getId());
            data.setCryptoProvider(certView.getCryptoProvider());
        }
        catch (CertificateEncodingException e) {
            String message = "Error exporting data for certificate with alias " + domainCert.getAlias();
            log.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        HashSet activeCertAliases = new HashSet(clientCertAuthManager.getAcceptableIssuerCertAliases());
        return new IssuerCert(certView, data, activeCertAliases.contains(domainCert.getId()));
    }
}

