/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AdditionalKeySet;
import com.pingidentity.admin.api.model.AdditionalKeySets;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SigningKeys;
import com.pingidentity.pf.admin.rest.translator.OAuthOidcKeysTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.domain.JwksSigningInstanceSettings;
import org.sourceid.oauth20.domain.OidcJwksSet;

public class JwksSigningKeyInstanceTranslator {
    public void apiToDomain(AdditionalKeySet apiDataObj, JwksSigningInstanceSettings domainDataObj) {
        domainDataObj.setId(apiDataObj.getId());
        domainDataObj.setName(apiDataObj.getName());
        domainDataObj.setDescription(apiDataObj.getDescription());
        OidcJwksSet domainSigningKeys = new OidcJwksSet();
        this.apiToDomainKeys(apiDataObj.getSigningKeys(), domainSigningKeys);
        domainDataObj.setOidcJWKSSigningKeySet(domainSigningKeys);
        Set domainIssuer = apiDataObj.getIssuers().stream().map(ResourceLink::getId).collect(Collectors.toSet());
        domainDataObj.setIssuerIds(domainIssuer);
    }

    public void domainToApiKeys(AdditionalKeySet apiDataObj, JwksSigningInstanceSettings domainDataObj) {
        apiDataObj.setId(domainDataObj.getId());
        apiDataObj.setName(domainDataObj.getName());
        apiDataObj.setDescription(domainDataObj.getDescription());
        SigningKeys signingKeys = new SigningKeys();
        JwksSigningKeyInstanceTranslator.domainToApiKeys(domainDataObj.getOidcJWKSSigningKeySet(), signingKeys);
        apiDataObj.setSigningKeys(signingKeys);
        ArrayList<ResourceLink> apiIssuerIds = new ArrayList<ResourceLink>();
        for (String issuer : domainDataObj.getIssuerIds()) {
            ResourceLink resourceLink = new ResourceLink();
            resourceLink.setId(issuer);
            resourceLink.setLocation(ApiUtil.getResourceUrl("/oauth/issuers", issuer));
            apiIssuerIds.add(resourceLink);
        }
        apiDataObj.setIssuers(apiIssuerIds);
    }

    public void apiToDomain(AdditionalKeySets apiDataObjs, List<JwksSigningInstanceSettings> domainDataObjs) {
        domainDataObjs.clear();
        for (AdditionalKeySet apiDataObj : apiDataObjs.getItems()) {
            JwksSigningInstanceSettings domainDataObj = new JwksSigningInstanceSettings();
            this.apiToDomain(apiDataObj, domainDataObj);
            domainDataObjs.add(domainDataObj);
        }
    }

    public AdditionalKeySets domainToApiKeys(List<JwksSigningInstanceSettings> domainDataObjs) {
        ArrayList<AdditionalKeySet> jWKSSigningKeySets = new ArrayList<AdditionalKeySet>();
        for (JwksSigningInstanceSettings domainDataObj : domainDataObjs) {
            AdditionalKeySet apiDataObj = new AdditionalKeySet();
            this.domainToApiKeys(apiDataObj, domainDataObj);
            jWKSSigningKeySets.add(apiDataObj);
        }
        return new AdditionalKeySets(jWKSSigningKeySets);
    }

    protected void apiToDomainKeys(SigningKeys apiDataObj, OidcJwksSet domainDataObj) {
        if (apiDataObj.getP256ActiveCertRef() != null) {
            domainDataObj.setP256ActiveId(apiDataObj.getP256ActiveCertRef().getId());
        }
        if (apiDataObj.getP256PreviousCertRef() != null) {
            domainDataObj.setP256PreviousId(apiDataObj.getP256PreviousCertRef().getId());
        }
        if (apiDataObj.isP256PublishX5cParameter() != null) {
            domainDataObj.setP256PublishX5cParameter(apiDataObj.isP256PublishX5cParameter().booleanValue());
        }
        domainDataObj.setP256ActiveKeyId(apiDataObj.getP256ActiveKeyId());
        domainDataObj.setP256PreviousKeyId(apiDataObj.getP256PreviousKeyId());
        if (apiDataObj.getP384ActiveCertRef() != null) {
            domainDataObj.setP384ActiveId(apiDataObj.getP384ActiveCertRef().getId());
        }
        if (apiDataObj.getP384PreviousCertRef() != null) {
            domainDataObj.setP384PreviousId(apiDataObj.getP384PreviousCertRef().getId());
        }
        if (apiDataObj.isP384PublishX5cParameter() != null) {
            domainDataObj.setP384PublishX5cParameter(apiDataObj.isP384PublishX5cParameter().booleanValue());
        }
        domainDataObj.setP384ActiveKeyId(apiDataObj.getP384ActiveKeyId());
        domainDataObj.setP384PreviousKeyId(apiDataObj.getP384PreviousKeyId());
        if (apiDataObj.getP521ActiveCertRef() != null) {
            domainDataObj.setP521ActiveId(apiDataObj.getP521ActiveCertRef().getId());
        }
        if (apiDataObj.getP521PreviousCertRef() != null) {
            domainDataObj.setP521PreviousId(apiDataObj.getP521PreviousCertRef().getId());
        }
        if (apiDataObj.isP521PublishX5cParameter() != null) {
            domainDataObj.setP521PublishX5cParameter(apiDataObj.isP521PublishX5cParameter().booleanValue());
        }
        domainDataObj.setP521ActiveKeyId(apiDataObj.getP521ActiveKeyId());
        domainDataObj.setP521PreviousKeyId(apiDataObj.getP521PreviousKeyId());
        if (apiDataObj.getRsaActiveCertRef() != null) {
            domainDataObj.setRsaActiveId(apiDataObj.getRsaActiveCertRef().getId());
        }
        if (apiDataObj.getRsaPreviousCertRef() != null) {
            domainDataObj.setRsaPreviousId(apiDataObj.getRsaPreviousCertRef().getId());
        }
        if (apiDataObj.isRsaPublishX5cParameter() != null) {
            domainDataObj.setRsaPublishX5cParameter(apiDataObj.isRsaPublishX5cParameter().booleanValue());
        }
        domainDataObj.setRsaActiveKeyId(apiDataObj.getRsaActiveKeyId());
        domainDataObj.setRsaPreviousKeyId(apiDataObj.getRsaPreviousKeyId());
        domainDataObj.setRsaAlgTypesActiveCustomKeyIds(OAuthOidcKeysTranslator.populateDomainRsaAlgTypeToKeyIds(apiDataObj.getRsaAlgorithmActiveKeyIds()));
        domainDataObj.setRsaAlgTypesPreviousCustomKeyIds(OAuthOidcKeysTranslator.populateDomainRsaAlgTypeToKeyIds(apiDataObj.getRsaAlgorithmPreviousKeyIds()));
    }

    protected static void domainToApiKeys(OidcJwksSet domainDataObj, SigningKeys apiDataObj) {
        apiDataObj.setP256ActiveCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getP256ActiveId()));
        apiDataObj.setP256PreviousCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getP256PreviousId()));
        if (apiDataObj.getP256ActiveCertRef() != null || apiDataObj.getP256PreviousCertRef() != null) {
            apiDataObj.setP256PublishX5cParameter(domainDataObj.isP256PublishX5cParameter());
        }
        apiDataObj.setP256ActiveKeyId(domainDataObj.getP256ActiveKeyId());
        apiDataObj.setP256PreviousKeyId(domainDataObj.getP256PreviousKeyId());
        apiDataObj.setP384ActiveCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getP384ActiveId()));
        apiDataObj.setP384PreviousCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getP384PreviousId()));
        if (apiDataObj.getP384ActiveCertRef() != null || apiDataObj.getP384PreviousCertRef() != null) {
            apiDataObj.setP384PublishX5cParameter(domainDataObj.isP384PublishX5cParameter());
        }
        apiDataObj.setP384ActiveKeyId(domainDataObj.getP384ActiveKeyId());
        apiDataObj.setP384PreviousKeyId(domainDataObj.getP384PreviousKeyId());
        apiDataObj.setP521ActiveCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getP521ActiveId()));
        apiDataObj.setP521PreviousCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getP521PreviousId()));
        if (apiDataObj.getP521ActiveCertRef() != null || apiDataObj.getP521PreviousCertRef() != null) {
            apiDataObj.setP521PublishX5cParameter(domainDataObj.isP521PublishX5cParameter());
        }
        apiDataObj.setP521ActiveKeyId(domainDataObj.getP521ActiveKeyId());
        apiDataObj.setP521PreviousKeyId(domainDataObj.getP521PreviousKeyId());
        apiDataObj.setRsaActiveCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getRsaActiveId()));
        apiDataObj.setRsaPreviousCertRef(JwksSigningKeyInstanceTranslator.createResourceLinkForKey(domainDataObj.getRsaPreviousId()));
        if (apiDataObj.getRsaActiveCertRef() != null || apiDataObj.getRsaPreviousCertRef() != null) {
            apiDataObj.setRsaPublishX5cParameter(domainDataObj.isRsaPublishX5cParameter());
        }
        apiDataObj.setRsaActiveKeyId(domainDataObj.getRsaActiveKeyId());
        apiDataObj.setRsaPreviousKeyId(domainDataObj.getRsaPreviousKeyId());
        apiDataObj.setRsaAlgorithmActiveKeyIds(OAuthOidcKeysTranslator.populateApiRsAlgTypeToKeyIds(domainDataObj.getRsaAlgTypesActiveCustomKeyIds()));
        apiDataObj.setRsaAlgorithmPreviousKeyIds(OAuthOidcKeysTranslator.populateApiRsAlgTypeToKeyIds(domainDataObj.getRsaAlgTypesPreviousCustomKeyIds()));
    }

    protected static ResourceLink createResourceLinkForKey(String keyId) {
        if (StringUtils.isNotEmpty((String)keyId)) {
            ResourceLink resource = new ResourceLink();
            resource.setId(keyId);
            resource.setLocation(ApiUtil.getResourceUrl("/keyPairs/signing", keyId));
            return resource;
        }
        return null;
    }
}

