/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.KeyPairFile;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.KeyPairFileFormat;
import com.pingidentity.crypto.PkCert;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import org.sourceid.common.IDGenerator;

public class KeyPairTranslator {
    private static int PASSWORD_LENGTH = 24;
    private FieldObfuscator fieldObfuscator = FieldObfuscator.REAL;

    public KeyPairFile domainToApi(PkCert pkCert) {
        KeyPairFile file = null;
        try {
            KeyPairFileFormat format;
            byte[] fileData;
            String password = IDGenerator.rndAlphaNumeric((int)PASSWORD_LENGTH);
            String encryptedPassword = this.fieldObfuscator.obfuscate(password);
            if (this.isBCFIPSMode()) {
                fileData = pkCert.exportPEM(password);
                format = KeyPairFileFormat.PEM;
            } else {
                fileData = pkCert.exportPKCS12(password);
                format = KeyPairFileFormat.PKCS12;
            }
            file = new KeyPairFile.Builder(pkCert.getId()).fileData(Base64.getUrlEncoder().encodeToString(fileData)).keyPairFileFormat(format).encryptedPassword(encryptedPassword).build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Certificate file could not be translated into a key pair", e);
        }
        return file;
    }

    private boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }
}

