/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.LdapDataStore;
import com.pingidentity.admin.api.model.LdapType;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.validator.LdapDataStoreValidator;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.pf.admin.rest.translator.DataStoreTranslator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagConfig;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;
import org.sourceid.saml20.domain.datasource.tag.LdapTagConfig;

public class LdapDataStoreTranslator
extends DataStoreTranslator<LdapDataStore, LdapDataSource, LdapDataStoreValidator> {
    @Override
    public void apiToDomain(LdapDataStore dataStore, LdapDataSource dataSource, LdapDataStoreValidator validator) {
        super.apiToDomain(dataStore, dataSource, validator);
        String defaultHost = LDAPUtil.joinServerUrls(dataStore.getHostnames());
        if (StringUtils.isNotBlank((String)defaultHost)) {
            dataSource.setHost(defaultHost);
        }
        dataSource.setLdapType(dataStore.getLdapType().getLdapInfoEquivalent());
        this.setDataSourceTagConfig(dataStore, dataSource, defaultHost);
        switch (dataStore.getLdapType()) {
            case ACTIVE_DIRECTORY: {
                dataSource.setLdapType(LdapInfo.LdapType.ActiveDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.ActiveDirectory.getDescription());
                break;
            }
            case ORACLE_DIRECTORY_SERVER: {
                dataSource.setLdapType(LdapInfo.LdapType.SunDirectoryServer);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.SunDirectoryServer.getDescription());
                break;
            }
            case ORACLE_UNIFIED_DIRECTORY: {
                dataSource.setLdapType(LdapInfo.LdapType.OracleUnifiedDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.OracleUnifiedDirectory.getDescription());
                break;
            }
            case UNBOUNDID_DS: {
                dataSource.setLdapType(LdapInfo.LdapType.PingDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.PingDirectory.getDescription());
                break;
            }
            case PING_DIRECTORY: {
                dataSource.setLdapType(LdapInfo.LdapType.PingDirectory);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.PingDirectory.getDescription());
                break;
            }
            case PING_DS: {
                dataSource.setLdapType(LdapInfo.LdapType.PingDS);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.PingDS.getDescription());
                break;
            }
            default: {
                dataSource.setLdapType(LdapInfo.LdapType.Generic);
                dataSource.setLdapTypeDesc(LdapInfo.LdapType.Generic.getDescription());
            }
        }
        dataSource.setAnonymousBinding(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isBindAnonymously(), (boolean)false));
        if (!dataSource.getAnonymousBinding()) {
            if (dataStore.getClientTlsCertificateRef() != null) {
                dataSource.setClientTlsCertificate(dataStore.getClientTlsCertificateRef().getId());
                dataSource.setAuthenticationMethod("clientTlsCert");
            } else {
                dataSource.setPrincipal(dataStore.getUserDN());
                String credentials = StringUtils.isNotBlank((String)dataStore.getPassword()) ? dataStore.getPassword() : (SecretReferenceUtil.isSecretReference((String)dataStore.getEncryptedPassword()) ? dataStore.getEncryptedPassword() : FieldObfuscator.REAL.deobfuscate(dataStore.getEncryptedPassword()));
                dataSource.setCredentials(credentials);
                dataSource.setAuthenticationMethod("simple");
            }
        } else {
            dataSource.setAuthenticationMethod("none");
        }
        dataSource.setUseSSL(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isUseSsl(), (boolean)false));
        dataSource.setUseDnsSrvRecords(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isUseDnsSrvRecords(), (boolean)false));
        dataSource.setUseAdReferral(dataStore.isFollowLDAPReferrals() == null ? false : dataStore.isFollowLDAPReferrals());
        dataSource.setTestOnBorrow(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isTestOnBorrow(), (boolean)false));
        dataSource.setTestOnReturn(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isTestOnReturn(), (boolean)false));
        dataSource.setCreateIfNecessary(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isCreateIfNecessary(), (boolean)true));
        dataSource.setRetryFailedOperations(dataStore.isRetryFailedOperations());
        dataSource.setVerifyHost(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isVerifyHost(), (boolean)true));
        if (dataStore.getMinConnections() != null) {
            dataSource.setMin(dataStore.getMinConnections().intValue());
        }
        if (dataStore.getMaxConnections() != null) {
            dataSource.setMax(dataStore.getMaxConnections().intValue());
        }
        if (dataStore.getMaxWait() != null) {
            dataSource.setMaxWait(dataStore.getMaxWait().intValue());
        }
        if (dataStore.getTimeBetweenEvictions() != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(dataStore.getTimeBetweenEvictions().intValue());
        }
        if (dataStore.getReadTimeout() != null) {
            dataSource.setReadTimeoutMillis(dataStore.getReadTimeout().intValue());
        }
        if (dataStore.getConnectionTimeout() != null) {
            dataSource.setConnTimeoutMillis(dataStore.getConnectionTimeout().intValue());
        }
        if (dataStore.getDnsTtl() != null) {
            dataSource.setDnsTtlMillis(dataStore.getDnsTtl().intValue());
        }
        if (dataStore.getLdapDnsSrvPrefix() != null) {
            dataSource.setLdapDnsSrvPrefix(dataStore.getLdapDnsSrvPrefix());
        }
        if (dataStore.getLdapsDnsSrvPrefix() != null) {
            dataSource.setLdapsDnsSrvPrefix(dataStore.getLdapsDnsSrvPrefix());
        }
        if (dataStore.getBinaryAttributes() != null) {
            dataSource.setBinaryAttributes(dataStore.getBinaryAttributes());
        }
        if (StringUtils.isNotBlank((String)dataStore.getName())) {
            dataSource.setDsName(dataStore.getName());
        }
        dataSource.setUseStartTLS(BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isUseStartTLS(), (boolean)false));
    }

    private void setDataSourceTagConfig(LdapDataStore dataStore, LdapDataSource dataSource, String defaultHost) {
        if (CollectionUtils.isEmpty(dataStore.getHostnamesTags()) && StringUtils.isNotEmpty((String)defaultHost)) {
            LinkedList<LdapTagConfig> revisedLdapTagConfigList = new LinkedList<LdapTagConfig>();
            LdapInstanceIdentifier defaultInstanceIdentifier = new LdapInstanceIdentifier(defaultHost);
            revisedLdapTagConfigList.add(new LdapTagConfig(defaultInstanceIdentifier, null, true));
            dataSource.setLdapTagConfigList(revisedLdapTagConfigList);
        } else if (CollectionUtils.isNotEmpty(dataStore.getHostnamesTags()) && StringUtils.isEmpty((String)defaultHost)) {
            dataStore.getHostnamesTags().parallelStream().filter(DataSourceTagConfig::isDefaultSource).findFirst().ifPresent(defaultJdbcTagConfig -> dataSource.setHost(defaultJdbcTagConfig.getIdentifier().getHostname()));
            dataSource.setLdapTagConfigList(dataStore.getHostnamesTags());
        } else {
            dataSource.setLdapTagConfigList(dataStore.getHostnamesTags());
        }
    }

    @Override
    public void domainToApi(LdapDataSource dataSource, LdapDataStore dataStore) {
        super.domainToApi(dataSource, dataStore);
        List<String> defaultHosts = Arrays.asList(LDAPUtil.splitServerUrls((String)dataSource.getHost()));
        dataStore.setHostnames(defaultHosts);
        this.setDataStoreTagConfig(dataSource, dataStore, defaultHosts);
        if (dataSource.isActiveDirectoryType()) {
            dataStore.setLdapType(LdapType.ACTIVE_DIRECTORY);
        } else if (dataSource.isSunOneType()) {
            dataStore.setLdapType(LdapType.ORACLE_DIRECTORY_SERVER);
        } else if (dataSource.isOracleUnifiedDirectoryType()) {
            dataStore.setLdapType(LdapType.ORACLE_UNIFIED_DIRECTORY);
        } else if (dataSource.isPingDirectoryType()) {
            dataStore.setLdapType(LdapType.PING_DIRECTORY);
        } else if (dataSource.isPingDSType()) {
            dataStore.setLdapType(LdapType.PING_DS);
        } else {
            dataStore.setLdapType(LdapType.GENERIC);
        }
        dataStore.setBindAnonymously(dataSource.getAnonymousBinding());
        dataStore.setPassword(null);
        dataStore.setUseSsl(dataSource.getUseSSL());
        dataStore.setUseDnsSrvRecords(dataSource.isUseDnsSrvRecords());
        if (StringUtils.isNotBlank((String)dataSource.getPrincipal())) {
            dataStore.setUserDN(dataSource.getPrincipal());
        }
        if (StringUtils.isNotBlank((String)dataSource.getCredentials())) {
            dataStore.setEncryptedPassword(SecretReferenceUtil.isSecretReference((String)dataSource.getCredentials()) ? dataSource.getCredentials() : FieldObfuscator.REAL.obfuscate(dataSource.getCredentials()));
        }
        if (StringUtils.isNotBlank((String)dataSource.getClientTlsCertificate())) {
            String href = ApiUtil.getResourceUrl("/keyPairs/sslClient", dataSource.getClientTlsCertificate());
            dataStore.setClientTlsCertificateRef(new ResourceLink(dataSource.getClientTlsCertificate(), href));
        }
        if (dataStore.getLdapType() == LdapType.PING_DIRECTORY || dataStore.getLdapType() == LdapType.PING_DS) {
            dataStore.setFollowLDAPReferrals(null);
        } else {
            dataStore.setFollowLDAPReferrals(dataSource.isUseAdReferral());
        }
        dataStore.setTestOnBorrow(dataSource.isTestOnBorrow());
        dataStore.setTestOnReturn(dataSource.isTestOnReturn());
        dataStore.setCreateIfNecessary(dataSource.isCreateIfNecessary());
        dataStore.setRetryFailedOperations(dataSource.isRetryFailedOperations());
        dataStore.setVerifyHost(dataSource.isVerifyHost());
        dataStore.setMinConnections(dataSource.getMin());
        dataStore.setMaxConnections(dataSource.getMax());
        dataStore.setMaxWait(dataSource.getMaxWait());
        dataStore.setTimeBetweenEvictions(dataSource.getTimeBetweenEvictionRunsMillis());
        dataStore.setReadTimeout(dataSource.getReadTimeoutMillis());
        dataStore.setConnectionTimeout(dataSource.getConnTimeoutMillis());
        dataStore.setDnsTtl(dataSource.getDnsTtlMillis());
        dataStore.setLdapDnsSrvPrefix(dataSource.getLdapDnsSrvPrefix());
        dataStore.setLdapsDnsSrvPrefix(dataSource.getLdapsDnsSrvPrefix());
        if (dataSource.getBinaryAttributes() != null) {
            dataStore.setBinaryAttributes(dataSource.getBinaryAttributes());
        }
        if (StringUtils.isNotBlank((String)dataSource.getDsName())) {
            dataStore.setName(dataSource.getDsName());
        }
        dataStore.setUseStartTLS(dataSource.getUseStartTLS());
    }

    private void setDataStoreTagConfig(LdapDataSource dataSource, LdapDataStore dataStore, List<String> defaultHosts) {
        if (CollectionUtils.isEmpty((Collection)dataSource.getLdapTagConfigList()) && StringUtils.isNotEmpty((String)dataSource.getHost())) {
            LinkedList<LdapTagConfig> revisedLdapTagConfigList = new LinkedList<LdapTagConfig>();
            LdapInstanceIdentifier defaultInstanceIdentifier = new LdapInstanceIdentifier(dataSource.getHost());
            revisedLdapTagConfigList.add(new LdapTagConfig(defaultInstanceIdentifier, null, true));
            dataStore.setHostnamesTags(revisedLdapTagConfigList);
        } else if (CollectionUtils.isNotEmpty((Collection)dataSource.getLdapTagConfigList()) && StringUtils.isEmpty((String)dataSource.getHost())) {
            dataSource.getLdapTagConfigList().parallelStream().filter(DataSourceTagConfig::isDefaultSource).findFirst().ifPresent(defaultJdbcTagConfig -> dataStore.setHostnames(defaultHosts));
            dataStore.setHostnamesTags(dataSource.getLdapTagConfigList());
        } else {
            dataStore.setHostnamesTags(dataSource.getLdapTagConfigList());
        }
    }
}

