/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ConnectionGroupLicenseView;
import com.pingidentity.admin.api.model.LicenseFeatureView;
import com.pingidentity.admin.api.model.LicenseView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseConnectionGroupManager;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;

public class LicenseTranslator {
    public LicenseView domainToApi(PingLicense domainLicense) {
        if (domainLicense == null) {
            return null;
        }
        LicenseView apiLicenseView = new LicenseView();
        apiLicenseView.setId(domainLicense.getID());
        apiLicenseView.setEnforcementType(domainLicense.getEnforcementType());
        apiLicenseView.setExpirationDate(domainLicense.getExpirationDate());
        apiLicenseView.setIssueDate(domainLicense.getIssueDate());
        apiLicenseView.setName(domainLicense.getName());
        apiLicenseView.setOrganization(domainLicense.getOrganization());
        apiLicenseView.setProduct(domainLicense.getProduct());
        apiLicenseView.setVersion(domainLicense.getVersion());
        apiLicenseView.setTier(domainLicense.getType());
        apiLicenseView.setOauthEnabled(domainLicense.isOAuthEnabled());
        apiLicenseView.setWsTrustEnabled(domainLicense.isFeatureEnabled("WSTrustSTS"));
        apiLicenseView.setProvisioningEnabled(domainLicense.isFeatureEnabled("SaasProvisioning"));
        apiLicenseView.setBridgeMode(domainLicense.isBridgeMode());
        apiLicenseView.setGracePeriod(domainLicense.getGracePeriod());
        if (domainLicense.getConnectionLimit() != null && domainLicense.getConnectionLimit() > 0) {
            apiLicenseView.setMaxConnections(domainLicense.getConnectionLimit());
        }
        int usedConnectionCount = LicenseManager.getUsedConnectionCount();
        if (LicenseManager.isConnectionGroupDefined()) {
            usedConnectionCount = LicenseConnectionGroupManager.getInstance().getUsedConnectionCount();
        }
        apiLicenseView.setUsedConnections(usedConnectionCount);
        Integer nodeLimit = domainLicense.getNodeLimit();
        if (nodeLimit != null && nodeLimit > 0) {
            apiLicenseView.setNodeLimit(nodeLimit);
        }
        ArrayList<ConnectionGroupLicenseView> apiConnectionGroupLicense = new ArrayList<ConnectionGroupLicenseView>();
        Map domainGroups = domainLicense.getConnectionLimitDetails();
        if (domainGroups != null) {
            for (Map.Entry entry : domainGroups.entrySet()) {
                LicenseConnectionGroup domainGroup = (LicenseConnectionGroup)entry.getValue();
                ConnectionGroupLicenseView apiLicenseGroup = new ConnectionGroupLicenseView();
                apiLicenseGroup.setName((String)entry.getKey());
                apiLicenseGroup.setConnectionCount(domainGroup.getConnectionLimit());
                apiLicenseGroup.setStartDate(domainGroup.getEffectiveDate());
                apiLicenseGroup.setEndDate(domainGroup.getExpirationDate());
                apiConnectionGroupLicense.add(apiLicenseGroup);
            }
        }
        apiLicenseView.setLicenseGroups(apiConnectionGroupLicense);
        List<LicenseFeatureView> licenseFeatureViews = domainLicense.getNonStandardFeatures().stream().map(LicenseFeatureView::new).collect(Collectors.toList());
        if (!licenseFeatureViews.isEmpty()) {
            apiLicenseView.setFeatures(licenseFeatureViews);
        }
        return apiLicenseView;
    }
}

