/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.LocalIdentityMappingPolicyAction;
import com.pingidentity.admin.api.model.PolicyAction;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.AuthenticationPolicySelectionActionTranslator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityMappingActionTranslator
extends AuthenticationPolicySelectionActionTranslator<LocalIdentityMappingPolicyAction, LocalIdentityMappingAction> {
    private static final LocalIdentityManager manager = MgmtFactory.getLocalIdentityProfileManager();
    private final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    @Override
    public PolicyAction domainToApi(LocalIdentityMappingAction domainAction) {
        LocalIdentityProfile profile;
        LocalIdentityMappingPolicyAction apiLocalIdentityMappingAction = super.domainToApi(new LocalIdentityMappingPolicyAction(), domainAction);
        String lipId = domainAction.getLipId();
        ResourceLink resourceLink = new ResourceLink();
        resourceLink.setId(lipId);
        resourceLink.setLocation(ApiUtil.getResourceUrl("/localIdentity/identityProfiles", lipId));
        apiLocalIdentityMappingAction.setLocalIdentityRef(resourceLink);
        AttributeMapping domainInboundAttributeMapping = domainAction.getInboundAttributeMapping();
        com.pingidentity.admin.api.model.AttributeMapping apiInboundAttributeMapping = new com.pingidentity.admin.api.model.AttributeMapping();
        if (domainInboundAttributeMapping != null) {
            this.attributeMappingTranslator.domainToApi(domainInboundAttributeMapping, apiInboundAttributeMapping);
            apiLocalIdentityMappingAction.setInboundMapping(apiInboundAttributeMapping);
        }
        if (!(profile = manager.getProfile(lipId)).isProfileEnabled() && !profile.isRegistrationEnabled()) {
            apiLocalIdentityMappingAction.setInboundMapping(null);
        }
        AttributeMapping domainOutboundAttributeMapping = domainAction.getOutboundAttributeMapping();
        com.pingidentity.admin.api.model.AttributeMapping apiOutboundAttributeMapping = new com.pingidentity.admin.api.model.AttributeMapping();
        if (StringUtils.isEmpty((String)domainAction.getApcId())) {
            this.attributeMappingTranslator.domainToApi(domainOutboundAttributeMapping, apiOutboundAttributeMapping);
        } else {
            this.attributeMappingTranslator.domainToApi(domainOutboundAttributeMapping, apiOutboundAttributeMapping, (Set<String>)MgmtFactory.getC2cContractManager().getContract(domainAction.getApcId()).getAllAttributeNames(), false);
        }
        apiLocalIdentityMappingAction.setOutboundAttributeMapping(apiOutboundAttributeMapping);
        return apiLocalIdentityMappingAction;
    }

    @Override
    public AuthnSelectionAction apiToDomain(LocalIdentityMappingPolicyAction apiAction) {
        LocalIdentityProfile profile;
        String lipId = apiAction.getLocalIdentityRef().getId();
        LocalIdentityMappingAction domainAction = new LocalIdentityMappingAction(lipId, new AttributeMapping(), new AttributeMapping());
        super.apiToDomain(apiAction, domainAction);
        com.pingidentity.admin.api.model.AttributeMapping apiInboundAttributeMapping = apiAction.getInboundMapping();
        AttributeMapping domainInboundAttributeMapping = new AttributeMapping();
        if (apiInboundAttributeMapping != null) {
            this.attributeMappingTranslator.apiToDomain(apiInboundAttributeMapping, domainInboundAttributeMapping);
            domainAction.setInboundAttributeMapping(domainInboundAttributeMapping);
        }
        if (!(profile = manager.getProfile(lipId)).isProfileEnabled() && !profile.isRegistrationEnabled()) {
            domainAction.setInboundAttributeMapping(null);
        }
        com.pingidentity.admin.api.model.AttributeMapping apiOutboundAttributeMapping = apiAction.getOutboundAttributeMapping();
        AttributeMapping domainOutboundAttributeMapping = new AttributeMapping();
        this.attributeMappingTranslator.apiToDomain(apiOutboundAttributeMapping, domainOutboundAttributeMapping);
        domainAction.setAttributeMapping(domainOutboundAttributeMapping);
        return domainAction;
    }
}

