/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.systemsettings.BulkheadAlertNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.CertificateExpirationNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.LicenseEventNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.MetadataEventNotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.NotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.ThreadPoolExhaustionNotificationSettings;
import com.pingidentity.admin.api.validator.NotificationSettingsValidator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import org.apache.commons.lang.StringUtils;

public class NotificationSettingsTranslator {
    private ValidatorContext validatorContext = null;

    public NotificationSettingsTranslator() {
    }

    public NotificationSettingsTranslator(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public void apiToDomain(NotificationSettings apiSettings, org.sourceid.saml20.domain.NotificationSettings domainSettings) {
        if (apiSettings.getLicenseEvents() != null) {
            LicenseEventNotificationSettings licenseSettings = apiSettings.getLicenseEvents();
            domainSettings.setEnableEmailNotification(true);
            domainSettings.setTo(licenseSettings.getEmailAddress());
            domainSettings.setLicensingEventTo(licenseSettings.getEmailAddress());
            if (licenseSettings.getNotificationPublisherRef() != null) {
                domainSettings.setNotificationPublisherLicensing(licenseSettings.getNotificationPublisherRef().getId());
            } else {
                domainSettings.setNotificationPublisherLicensing(null);
            }
        } else {
            domainSettings.setEnableEmailNotification(false);
            domainSettings.setTo("");
        }
        MetadataEventNotificationSettings metadataSettings = apiSettings.getMetadataNotificationSettings();
        if (metadataSettings != null && StringUtils.isNotBlank((String)metadataSettings.getEmailAddress())) {
            domainSettings.setEnableMetadataEventNotification(true);
            domainSettings.setMetadataEventTo(metadataSettings.getEmailAddress());
            if (metadataSettings.getNotificationPublisherRef() != null) {
                domainSettings.setNotificationPublisherMetadata(metadataSettings.getNotificationPublisherRef().getId());
            } else {
                domainSettings.setNotificationPublisherMetadata(null);
            }
        } else {
            domainSettings.setEnableMetadataEventNotification(false);
            domainSettings.setMetadataEventTo("");
        }
        if (apiSettings.getCertificateExpirations() != null) {
            CertificateExpirationNotificationSettings certificateSettings = apiSettings.getCertificateExpirations();
            domainSettings.setEnableCertificateExpirationNotification(true);
            domainSettings.setCertificateExpirationTo(certificateSettings.getEmailAddress());
            if (certificateSettings.getInitialWarningPeriod() == null) {
                domainSettings.setCertInitialWarningEvent("");
            } else {
                domainSettings.setCertInitialWarningEvent(certificateSettings.getInitialWarningPeriod().toString());
            }
            if (certificateSettings.getFinalWarningPeriod() == null) {
                domainSettings.setCertFinalWarningEvent("");
            } else {
                domainSettings.setCertFinalWarningEvent(certificateSettings.getFinalWarningPeriod().toString());
            }
            if (certificateSettings.getNotificationPublisherRef() != null) {
                domainSettings.setNotificationPublisherCertificates(certificateSettings.getNotificationPublisherRef().getId());
            } else {
                domainSettings.setNotificationPublisherCertificates(null);
            }
            domainSettings.setCertExpirationNotificationMode(certificateSettings.getNotificationMode());
        } else {
            domainSettings.setEnableCertificateExpirationNotification(false);
            domainSettings.setCertificateExpirationTo("");
            domainSettings.setCertInitialWarningEvent("");
            domainSettings.setCertFinalWarningEvent("");
        }
        this.populateCertExpWarningConsoleNotificationSettings(apiSettings, domainSettings);
        if (apiSettings.getThreadPoolExhaustionNotificationSettings() != null) {
            ThreadPoolExhaustionNotificationSettings threadSettings = apiSettings.getThreadPoolExhaustionNotificationSettings();
            domainSettings.setEnableThreadPoolExhaustionNotification(true);
            domainSettings.setThreadPoolExhaustionTo(threadSettings.getEmailAddress());
            domainSettings.setThreadPoolExhaustionThreadDump(threadSettings.isThreadDumpEnabled());
            domainSettings.setThreadPoolExhaustionNotificationMode(threadSettings.getNotificationMode());
            if (threadSettings.getNotificationPublisherRef() != null) {
                domainSettings.setNotificationPublisherThreadPoolExhaustion(threadSettings.getNotificationPublisherRef().getId());
            } else {
                domainSettings.setNotificationPublisherThreadPoolExhaustion(null);
            }
        } else {
            domainSettings.setEnableThreadPoolExhaustionNotification(false);
            domainSettings.setThreadPoolExhaustionTo("");
            domainSettings.setThreadPoolExhaustionThreadDump(false);
        }
        if (apiSettings.getBulkheadAlertNotificationSettings() != null) {
            BulkheadAlertNotificationSettings bulkheadAlertNotificationSettings = apiSettings.getBulkheadAlertNotificationSettings();
            domainSettings.setEnableBulkheadAlertNotification(true);
            domainSettings.setBulkheadAlertsTo(bulkheadAlertNotificationSettings.getEmailAddress());
            domainSettings.setBulkheadAlertNotificationMode(bulkheadAlertNotificationSettings.getNotificationMode());
            domainSettings.setBulkheadThreadDump(bulkheadAlertNotificationSettings.isThreadDumpEnabled());
            if (bulkheadAlertNotificationSettings.getNotificationPublisherRef() != null) {
                domainSettings.setNotificationPublisherBulkheadAlerts(bulkheadAlertNotificationSettings.getNotificationPublisherRef().getId());
            } else {
                domainSettings.setNotificationPublisherBulkheadAlerts(null);
            }
        } else {
            domainSettings.setEnableBulkheadAlertNotification(false);
            domainSettings.setBulkheadAlertsTo("");
        }
        domainSettings.setEnableAccountChangesNotification(apiSettings.isNotifyAdminUserPasswordChanges());
        if (apiSettings.getAccountChangesNotificationPublisherRef() != null) {
            domainSettings.setNotificationPublisherAccountChanges(apiSettings.getAccountChangesNotificationPublisherRef().getId());
        } else {
            domainSettings.setNotificationPublisherAccountChanges(null);
        }
    }

    private void populateCertExpWarningConsoleNotificationSettings(NotificationSettings apiSettings, org.sourceid.saml20.domain.NotificationSettings domainSettings) {
        if (apiSettings.getExpiredCertificateAdministrativeConsoleWarningDays() == null) {
            domainSettings.setExpiredCertThresholdUIWarning("14");
        } else {
            domainSettings.setExpiredCertThresholdUIWarning(apiSettings.getExpiredCertificateAdministrativeConsoleWarningDays().toString());
        }
        if (apiSettings.getExpiringCertificateAdministrativeConsoleWarningDays() == null) {
            domainSettings.setExpiringCertUIWarning("14");
        } else {
            domainSettings.setExpiringCertUIWarning(apiSettings.getExpiringCertificateAdministrativeConsoleWarningDays().toString());
        }
    }

    private boolean isBulkImport() {
        return this.validatorContext != null && this.validatorContext.isBulkConfigRequest();
    }

    public NotificationSettings domainToApi(org.sourceid.saml20.domain.NotificationSettings domainSettings) {
        ResourceLink resourceLinkNotificationPublisher;
        ResourceLink resourceLinkNotificationPublisher2;
        NotificationSettings apiSettings = new NotificationSettings();
        if (domainSettings.isEnableEmailNotification() && NotificationSettingsValidator.licenseSupportsNotifications()) {
            LicenseEventNotificationSettings licenseSettings = new LicenseEventNotificationSettings();
            apiSettings.setLicenseEventSettings(licenseSettings);
            licenseSettings.setEmailAddress(domainSettings.getTo());
            if (StringUtils.isNotBlank((String)domainSettings.getNotificationPublisherLicensing())) {
                resourceLinkNotificationPublisher2 = new ResourceLink();
                resourceLinkNotificationPublisher2.setId(domainSettings.getNotificationPublisherLicensing());
                resourceLinkNotificationPublisher2.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherLicensing()));
                licenseSettings.setNotificationPublisherRef(resourceLinkNotificationPublisher2);
            }
        }
        if (domainSettings.isEnableMetadataEventNotification()) {
            MetadataEventNotificationSettings metadataSetting = new MetadataEventNotificationSettings();
            metadataSetting.setEmailAddress(domainSettings.getMetadataEventTo());
            apiSettings.setMetadataNotificationSettings(metadataSetting);
            if (StringUtils.isNotBlank((String)domainSettings.getNotificationPublisherMetadata())) {
                resourceLinkNotificationPublisher2 = new ResourceLink();
                resourceLinkNotificationPublisher2.setId(domainSettings.getNotificationPublisherMetadata());
                resourceLinkNotificationPublisher2.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherMetadata()));
                metadataSetting.setNotificationPublisherRef(resourceLinkNotificationPublisher2);
            }
        }
        CertificateExpirationNotificationSettings certSettings = new CertificateExpirationNotificationSettings();
        if (domainSettings.isEnableCertificateExpirationNotification()) {
            apiSettings.setCertificateExpirations(certSettings);
            certSettings.setEmailAddress(domainSettings.getCertificateExpirationTo());
            try {
                if (!StringUtils.isBlank((String)domainSettings.getCertInitialWarningEvent())) {
                    certSettings.setInitialWarningPeriod(Integer.parseInt(domainSettings.getCertInitialWarningEvent()));
                }
                if (!StringUtils.isBlank((String)domainSettings.getCertFinalWarningEvent())) {
                    certSettings.setFinalWarningPeriod(Integer.parseInt(domainSettings.getCertFinalWarningEvent()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unexpected exception", numberFormatException);
            }
            certSettings.setNotificationMode(domainSettings.getCertExpirationNotificationMode());
            if (StringUtils.isNotBlank((String)domainSettings.getNotificationPublisherCertificates())) {
                resourceLinkNotificationPublisher2 = new ResourceLink();
                resourceLinkNotificationPublisher2.setId(domainSettings.getNotificationPublisherCertificates());
                resourceLinkNotificationPublisher2.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherCertificates()));
                certSettings.setNotificationPublisherRef(resourceLinkNotificationPublisher2);
            }
        }
        apiSettings.setExpiringCertificateAdministrativeConsoleWarningDays(Integer.parseInt(domainSettings.getExpiringCertUIWarning()));
        apiSettings.setExpiredCertificateAdministrativeConsoleWarningDays(Integer.parseInt(domainSettings.getExpiredCertThresholdUIWarning()));
        if (domainSettings.isEnableThreadPoolExhaustionNotification()) {
            ThreadPoolExhaustionNotificationSettings threadSettings = new ThreadPoolExhaustionNotificationSettings();
            apiSettings.setThreadPoolExhaustionNotificationSettings(threadSettings);
            threadSettings.setEmailAddress(domainSettings.getThreadPoolExhaustionTo());
            threadSettings.setThreadDumpEnabled(domainSettings.getThreadPoolExhaustionThreadDump());
            threadSettings.setNotificationMode(domainSettings.getThreadPoolExhaustionNotificationMode());
            if (StringUtils.isNotBlank((String)domainSettings.getNotificationPublisherThreadPoolExhaustion())) {
                resourceLinkNotificationPublisher = new ResourceLink();
                resourceLinkNotificationPublisher.setId(domainSettings.getNotificationPublisherThreadPoolExhaustion());
                resourceLinkNotificationPublisher.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherThreadPoolExhaustion()));
                threadSettings.setNotificationPublisherRef(resourceLinkNotificationPublisher);
            }
        }
        if (domainSettings.isEnableBulkheadAlertNotification()) {
            BulkheadAlertNotificationSettings bulkheadAlertNotificationSettings = new BulkheadAlertNotificationSettings();
            apiSettings.setBulkheadAlertNotificationSettings(bulkheadAlertNotificationSettings);
            bulkheadAlertNotificationSettings.setEmailAddress(domainSettings.getBulkheadAlertsTo());
            bulkheadAlertNotificationSettings.setNotificationMode(domainSettings.getBulkheadAlertsNotificationMode());
            if (StringUtils.isNotBlank((String)domainSettings.getNotificationPublisherBulkheadAlerts())) {
                resourceLinkNotificationPublisher = new ResourceLink();
                resourceLinkNotificationPublisher.setId(domainSettings.getNotificationPublisherBulkheadAlerts());
                resourceLinkNotificationPublisher.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherBulkheadAlerts()));
                bulkheadAlertNotificationSettings.setNotificationPublisherRef(resourceLinkNotificationPublisher);
                bulkheadAlertNotificationSettings.setThreadDumpEnabled(domainSettings.getBulkheadThreadDump());
            }
        }
        apiSettings.setNotifyAdminUserPasswordChanges(domainSettings.isEnableAccountChangesNotification());
        if (StringUtils.isNotBlank((String)domainSettings.getNotificationPublisherAccountChanges())) {
            resourceLinkNotificationPublisher2 = new ResourceLink();
            resourceLinkNotificationPublisher2.setId(domainSettings.getNotificationPublisherAccountChanges());
            resourceLinkNotificationPublisher2.setLocation(ApiUtil.getResourceUrl("/notificationPublishers", domainSettings.getNotificationPublisherAccountChanges()));
            apiSettings.setAccountChangesNotificationPublisherRef(resourceLinkNotificationPublisher2);
        }
        return apiSettings;
    }
}

