/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.JwtSecuredAuthorizationResponseModeType;
import com.pingidentity.admin.api.model.OIDCAuthenticationScheme;
import com.pingidentity.admin.api.model.OIDCLoginType;
import com.pingidentity.admin.api.model.OIDCProviderSettings;
import com.pingidentity.admin.api.model.OIDCRequestParameter;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.oauth.SigningAlgorithm;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.OIDCSettings;

public class OIDCProviderTranslator {
    private static final AttributeMappingTranslator attributeMappingTranslator = new AttributeMappingTranslator();

    public void apiToDomain(IdpConnection apiOidcConnection, org.sourceid.saml20.domain.IdpConnection domainConnection) {
        if (domainConnection.getOidcSettings() == null) {
            domainConnection.setOidcSettings(new OIDCSettings());
        }
        OIDCSettings domainOidcSettings = domainConnection.getOidcSettings();
        OIDCProviderSettings apiOidcSetting = apiOidcConnection.getIdpBrowserSso().getOidcProviderSettings();
        domainOidcSettings.setScopes(new Scope(apiOidcSetting.getScopes()));
        domainOidcSettings.setProfile(apiOidcSetting.getLoginType().getOIDCProfile());
        if (apiOidcSetting.getJwtSecuredAuthorizationResponseModeType() == null) {
            domainOidcSettings.setJwtSecuredAuthorizationResponseModeType("disabled");
        } else {
            domainOidcSettings.setJwtSecuredAuthorizationResponseModeType(apiOidcSetting.getJwtSecuredAuthorizationResponseModeType().getName());
        }
        domainOidcSettings.setBasicAuth(true);
        ArrayList<Endpoint> allEndpoints = new ArrayList<Endpoint>();
        Endpoint endpoint = new Endpoint("oauth:authz", apiOidcSetting.getAuthorizationEndpoint());
        allEndpoints.add(endpoint);
        EndpointGroup ssoServices = new EndpointGroup();
        ssoServices.setEndpoints(allEndpoints);
        domainConnection.setSingleSignOnServices(ssoServices);
        if (apiOidcSetting.getLoginType() == OIDCLoginType.CODE) {
            if (apiOidcSetting.getAuthenticationScheme() == OIDCAuthenticationScheme.BASIC) {
                domainOidcSettings.setPrivateKeyJwtAuth(false);
                domainOidcSettings.setClientSecretJwtAuth(false);
            }
            if (apiOidcSetting.getAuthenticationScheme() == OIDCAuthenticationScheme.POST) {
                domainOidcSettings.setBasicAuth(false);
                domainOidcSettings.setPrivateKeyJwtAuth(false);
                domainOidcSettings.setClientSecretJwtAuth(false);
            }
            if (apiOidcSetting.getAuthenticationScheme() == OIDCAuthenticationScheme.PRIVATE_KEY_JWT) {
                domainOidcSettings.setBasicAuth(false);
                domainOidcSettings.setPrivateKeyJwtAuth(true);
                domainOidcSettings.setClientSecretJwtAuth(false);
                domainOidcSettings.setSigningAlgorithm(apiOidcSetting.getAuthenticationSigningAlgorithm() != null ? apiOidcSetting.getAuthenticationSigningAlgorithm().getId() : null);
                domainOidcSettings.setType(apiOidcSetting.getType());
                domainOidcSettings.setLifetime(apiOidcSetting.getLifetime());
                domainOidcSettings.setAudience(apiOidcSetting.getAudience());
                domainOidcSettings.setIncludeNotBeforeClaim(apiOidcSetting.isIncludeNotBeforeClaim());
            }
            if (apiOidcSetting.getAuthenticationScheme() == OIDCAuthenticationScheme.CLIENT_SECRET_JWT) {
                domainOidcSettings.setBasicAuth(false);
                domainOidcSettings.setPrivateKeyJwtAuth(false);
                domainOidcSettings.setClientSecretJwtAuth(true);
                domainOidcSettings.setSigningAlgorithm(apiOidcSetting.getAuthenticationSigningAlgorithm() != null ? apiOidcSetting.getAuthenticationSigningAlgorithm().getId() : null);
                domainOidcSettings.setType(apiOidcSetting.getType());
                domainOidcSettings.setLifetime(apiOidcSetting.getLifetime());
                domainOidcSettings.setAudience(apiOidcSetting.getAudience());
                domainOidcSettings.setIncludeNotBeforeClaim(apiOidcSetting.isIncludeNotBeforeClaim());
            }
        }
        domainOidcSettings.setRequestSigningAlgorithm(apiOidcSetting.getRequestSigningAlgorithm() != null ? apiOidcSetting.getRequestSigningAlgorithm().getId() : null);
        domainOidcSettings.setTokenEndpoint(new Endpoint(null, apiOidcSetting.getTokenEndpoint()));
        domainOidcSettings.setEnableProofKeyForCodeExchange(apiOidcSetting.getEnablePKCE());
        domainOidcSettings.setJwksUri(new Endpoint(null, apiOidcSetting.getJwksURL()));
        domainOidcSettings.setUserInfoEndpoint(new Endpoint(null, apiOidcSetting.getUserInfoEndpoint()));
        domainOidcSettings.setTrackUserSessionsForLogout(apiOidcSetting.isTrackUserSessionsForLogout());
        if (StringUtils.isNotEmpty((String)apiOidcSetting.getLogoutEndpoint())) {
            domainOidcSettings.setLogoutEndpoint(new Endpoint(null, apiOidcSetting.getLogoutEndpoint()));
        }
        List<OIDCRequestParameter> reqParams = apiOidcSetting.getRequestParameters();
        if (StringUtils.isNotEmpty((String)apiOidcSetting.getPushedAuthorizationRequestEndpoint())) {
            domainOidcSettings.setPushedAuthorizationRequestEndpoint(new Endpoint(null, apiOidcSetting.getPushedAuthorizationRequestEndpoint()));
        }
        List<OIDCRequestParamSetting> reqParamsList = this.getDomainRequestParams(reqParams);
        domainOidcSettings.setRequestParams(reqParamsList);
    }

    private List<OIDCRequestParamSetting> getDomainRequestParams(List<OIDCRequestParameter> reqParams) {
        ArrayList<OIDCRequestParamSetting> reqParamsList = new ArrayList<OIDCRequestParamSetting>();
        if (reqParams != null && !reqParams.isEmpty()) {
            for (OIDCRequestParameter param : reqParams) {
                OIDCRequestParamSetting domainParam = new OIDCRequestParamSetting(param.getName(), OIDCProviderTranslator.apiToDomainRequestParamMappingValue(param, true), Boolean.valueOf(param.isApplicationEndpointOverride()));
                reqParamsList.add(domainParam);
            }
        }
        return reqParamsList;
    }

    public void domainToApi(org.sourceid.saml20.domain.IdpConnection domainConnection, OIDCProviderSettings apiOidcSetting) {
        List domainParams;
        OIDCSettings domainOidcSettings = domainConnection.getOidcSettings();
        apiOidcSetting.setScopes(domainOidcSettings.getScopes().getScopeStr());
        apiOidcSetting.setLoginType(OIDCLoginType.fromOIDCProfile(domainOidcSettings.getProfile()));
        apiOidcSetting.setJwtSecuredAuthorizationResponseModeType(JwtSecuredAuthorizationResponseModeType.getJwtSecuredAuthorizationResponseModeType(domainOidcSettings.getJwtSecuredAuthorizationResponseModeType()));
        if (domainOidcSettings.getProfile().equals((Object)OIDCProfile.BASIC)) {
            apiOidcSetting.setTokenEndpoint(domainOidcSettings.getTokenEndpoint().getLocation());
            apiOidcSetting.setEnablePKCE(domainOidcSettings.isEnableProofKeyForCodeExchange());
            if (domainOidcSettings.isBasicAuth()) {
                apiOidcSetting.setAuthenticationScheme(OIDCAuthenticationScheme.BASIC);
            } else if (domainOidcSettings.isPrivateKeyJwtAuth()) {
                apiOidcSetting.setAuthenticationScheme(OIDCAuthenticationScheme.PRIVATE_KEY_JWT);
                apiOidcSetting.setAuthenticationSigningAlgorithm(SigningAlgorithm.valueOf(domainOidcSettings.getSigningAlgorithm()));
                apiOidcSetting.setType(domainOidcSettings.getType());
                apiOidcSetting.setLifetime(domainOidcSettings.getLifetime());
                apiOidcSetting.setAudience(domainOidcSettings.getAudience());
                apiOidcSetting.setIncludeNotBeforeClaim(domainOidcSettings.isIncludeNotBeforeClaim());
            } else if (domainOidcSettings.isClientSecretJwtAuth()) {
                apiOidcSetting.setAuthenticationScheme(OIDCAuthenticationScheme.CLIENT_SECRET_JWT);
                apiOidcSetting.setAuthenticationSigningAlgorithm(SigningAlgorithm.valueOf(domainOidcSettings.getSigningAlgorithm()));
                apiOidcSetting.setType(domainOidcSettings.getType());
                apiOidcSetting.setLifetime(domainOidcSettings.getLifetime());
                apiOidcSetting.setAudience(domainOidcSettings.getAudience());
                apiOidcSetting.setIncludeNotBeforeClaim(domainOidcSettings.isIncludeNotBeforeClaim());
            } else {
                apiOidcSetting.setAuthenticationScheme(OIDCAuthenticationScheme.POST);
            }
        }
        if (StringUtils.isNotBlank((String)domainOidcSettings.getRequestSigningAlgorithm())) {
            apiOidcSetting.setRequestSigningAlgorithm(SigningAlgorithm.getType(domainOidcSettings.getRequestSigningAlgorithm()));
        }
        if (domainOidcSettings.getUserInfoEndpoint() != null) {
            apiOidcSetting.setUserInfoEndpoint(domainOidcSettings.getUserInfoEndpoint().getLocation());
        }
        apiOidcSetting.setJwksURL(domainOidcSettings.getJwksUri().getLocation());
        apiOidcSetting.setTrackUserSessionsForLogout(domainOidcSettings.isTrackUserSessionsForLogout());
        EndpointGroup ssoServices = domainConnection.getSingleSignOnServices();
        Endpoint endpoint = (Endpoint)ssoServices.getEndpoints().iterator().next();
        apiOidcSetting.setAuthorizationEndpoint(endpoint.getLocation());
        if (domainOidcSettings.getPushedAuthorizationRequestEndpoint() != null) {
            apiOidcSetting.setPushedAuthorizationRequestEndpoint(domainOidcSettings.getPushedAuthorizationRequestEndpoint().getLocation());
        }
        if (domainOidcSettings.getLogoutEndpoint() != null) {
            apiOidcSetting.setLogoutEndpoint(domainOidcSettings.getLogoutEndpoint().getLocation());
        }
        if ((domainParams = domainOidcSettings.getRequestParams()) != null) {
            List<OIDCRequestParameter> apiRequestParams = this.getApiRequestParams(domainParams);
            apiOidcSetting.setRequestParameters(apiRequestParams);
        }
        String entityId = domainConnection.getEntityId();
        apiOidcSetting.setRedirectUri(OIDCUtil.getRedirectUri((String)entityId));
        if (apiOidcSetting.isTrackUserSessionsForLogout()) {
            String logoutUri = OIDCUtil.getBackChannelLogoutUri((String)entityId);
            apiOidcSetting.setBackChannelLogoutUri(logoutUri);
        }
        String fcLogoutUri = OIDCUtil.getFrontChannelLogoutUri((String)entityId);
        apiOidcSetting.setFrontChannelLogoutUri(fcLogoutUri);
        if (apiOidcSetting.getLogoutEndpoint() != null) {
            apiOidcSetting.setPostLogoutRedirectUri(OIDCUtil.getPostLogoutRedirectUri());
        }
    }

    private List<OIDCRequestParameter> getApiRequestParams(List<OIDCRequestParamSetting> domainParams) {
        ArrayList<OIDCRequestParameter> apiRequestParams = new ArrayList<OIDCRequestParameter>();
        for (OIDCRequestParamSetting param : domainParams) {
            OIDCRequestParameter apiOidcParam = new OIDCRequestParameter();
            apiOidcParam.setName(param.getName());
            apiOidcParam.setAttributeValue(this.domainToApiRequestParamMappingValue(param));
            apiOidcParam.setApplicationEndpointOverride(param.isOverride());
            apiRequestParams.add(apiOidcParam);
        }
        return apiRequestParams;
    }

    public static AttrMappingValue apiToDomainRequestParamMappingValue(OIDCRequestParameter apiRequestParam, boolean addPrefix) {
        AttrMappingValue attrMappingValue;
        AttributeFulfillmentValue apiRequestParameterValue = apiRequestParam.getAttributeValue();
        if (apiRequestParameterValue != null) {
            attrMappingValue = attributeMappingTranslator.apiToDomainAttrMappingValue(apiRequestParameterValue, addPrefix);
            if (apiRequestParameterValue.getSource() != null && SourceType.TRACKED_HTTP_PARAMS.equals((Object)apiRequestParameterValue.getSource().getType()) && StringUtils.isEmpty((String)apiRequestParameterValue.getSource().getId())) {
                attrMappingValue = new AttrMappingValue(attrMappingValue.getType(), attrMappingValue.getValue(), ".", "trackedparams");
            }
        } else {
            org.sourceid.saml20.domain.SourceType domainSourceType = StringUtils.isEmpty((String)apiRequestParam.getValue()) ? SourceType.NO_MAPPING.getCorrespondingDomainSourceType() : SourceType.TEXT.getCorrespondingDomainSourceType();
            attrMappingValue = new AttrMappingValue(domainSourceType, apiRequestParam.getValue());
        }
        return attrMappingValue;
    }

    private AttributeFulfillmentValue domainToApiRequestParamMappingValue(OIDCRequestParamSetting domainRequestParam) {
        AttrMappingValue domainRequestParameterMappingValue = domainRequestParam.getValue();
        AttributeFulfillmentValue apiAttrMappingValue = null;
        if (domainRequestParameterMappingValue != null) {
            if (domainRequestParameterMappingValue.getType() == null) {
                apiAttrMappingValue = new AttributeFulfillmentValue();
                apiAttrMappingValue.setSource(new SourceTypeIdKey(SourceType.TEXT));
                apiAttrMappingValue.setValue(domainRequestParameterMappingValue.getValue());
            } else {
                apiAttrMappingValue = attributeMappingTranslator.domainToApiAttributeValue(domainRequestParameterMappingValue);
            }
        }
        return apiAttrMappingValue;
    }
}

