/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.Channel;
import com.pingidentity.admin.api.model.OutboundProvision;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.plugin.ConfigField;
import com.pingidentity.admin.api.translator.plugin.PluginConfigTranslator;
import com.pingidentity.admin.api.validator.SaasTargetValidator;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.pf.admin.rest.translator.ChannelTranslator;
import com.pingidentity.pf.admin.rest.translator.SchemaAttributeTranslator;
import com.pingidentity.provisioner.domain.mgmt.FieldInfoManager;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.model.Schema;

public class OutboundProvisionTranslator {
    private final ChannelTranslator channelTranslator = new ChannelTranslator();
    private final PluginConfigTranslator targetFieldsTranslator = new PluginConfigTranslator();
    private final SchemaAttributeTranslator schemaAttributeTranslator = new SchemaAttributeTranslator();
    private final Log log = LogFactory.getLog(this.getClass());

    public void domainToApi(org.sourceid.saml20.domain.SpConnection domainConnection, SpConnection apiSpConnection) {
        ProvisionerConfig provisionerConfig = (ProvisionerConfig)domainConnection.getModuleConfiguration(ProvisionerConfig.class);
        if (provisionerConfig != null) {
            OutboundProvision provisionApiSettings = new OutboundProvision();
            Schema schema = provisionerConfig.getCustomScim();
            String pluginType = provisionerConfig.getType();
            SaasPluginManager pluginManager = SaasPluginManager.getInstance();
            SaasProvisionerPlugin saasProvisioningPlugin = pluginManager.getPluginInstance(pluginType);
            try {
                List<ConfigField> configFields = this.targetFieldsTranslator.domainFieldsToApi(provisionerConfig.getTarget().getParameterValues().getFields(), new ArrayList<Field>(), (List<FieldDescriptor>)saasProvisioningPlugin.getParameterDescriptors(), new ArrayList<FieldDescriptor>(), null);
                provisionApiSettings.setType(pluginType);
                provisionApiSettings.setTargetSettings(configFields);
            }
            catch (NullPointerException e) {
                this.log.error((Object)("Ensure that the provisioning plugin for " + pluginType + "  is available in the deploy directory."), (Throwable)e);
            }
            if (schema != null) {
                com.pingidentity.admin.api.model.Schema apiSchema = new com.pingidentity.admin.api.model.Schema();
                apiSchema.setNamespace(schema.getSchema());
                if (schema.getAttributes() != null) {
                    ArrayList<SchemaAttribute> apiSchemaAttributes = new ArrayList<SchemaAttribute>();
                    for (org.sourceid.saml20.domain.scim.model.SchemaAttribute attribute : schema.getAttributes()) {
                        SchemaAttribute apiAttribute = this.schemaAttributeTranslator.domainToApi(attribute);
                        apiSchemaAttributes.add(apiAttribute);
                    }
                    apiSchema.setAttributes(apiSchemaAttributes);
                    provisionApiSettings.setCustomSchema(apiSchema);
                }
            }
            List channels = provisionerConfig.getChannels();
            ArrayList<Channel> apiChannels = new ArrayList<Channel>();
            for (com.pingidentity.provisioner.domain.Channel channel : channels) {
                Channel apiChannel = this.channelTranslator.domainToApi(channel);
                apiChannels.add(apiChannel);
            }
            provisionApiSettings.setChannels(apiChannels);
            apiSpConnection.setOutboundProvision(provisionApiSettings);
        }
    }

    public void apiToDomain(SpConnection apiSpConnection, org.sourceid.saml20.domain.SpConnection domainConnection, boolean isUpdate) {
        Object connectionManager;
        ProvisionerConfig provisionerConfig;
        if (apiSpConnection.getOutboundProvision() == null) {
            return;
        }
        OutboundProvision provisionApiSettings = apiSpConnection.getOutboundProvision();
        ProvisionerConfig provisioningConfig = new ProvisionerConfig(apiSpConnection.getEntityId());
        provisioningConfig.setType(provisionApiSettings.getType());
        List<Field>[] targetSettings = this.targetFieldsTranslator.apiFieldsToDomain(provisionApiSettings.getTargetSettings(), new ArrayList<FieldDescriptor>(), null, ConnectionPaths.getOutboundProvision(), false, false, null);
        if (targetSettings.length > 0) {
            SaasTarget saasTarget = new SaasTarget(provisionApiSettings.getType(), new SimpleFieldList(targetSettings[0]));
            provisioningConfig.setTarget(saasTarget);
        }
        com.pingidentity.admin.api.model.Schema apiSchema = provisionApiSettings.getCustomSchema();
        List<SchemaAttribute> schemaAttributes = null;
        if (apiSchema != null) {
            Schema domainSchema = new Schema();
            domainSchema.setSchema(apiSchema.getNamespace());
            schemaAttributes = apiSchema.getAttributes();
            ArrayList<org.sourceid.saml20.domain.scim.model.SchemaAttribute> domainSchemaAttrs = new ArrayList<org.sourceid.saml20.domain.scim.model.SchemaAttribute>();
            for (SchemaAttribute attribute : schemaAttributes) {
                org.sourceid.saml20.domain.scim.model.SchemaAttribute domainSchemaAttr = this.schemaAttributeTranslator.apiToDomain(attribute, apiSchema.getNamespace());
                domainSchemaAttrs.add(domainSchemaAttr);
            }
            domainSchema.setAttributes(domainSchemaAttrs);
            provisioningConfig.setCustomScim(domainSchema);
        }
        HashMap<String, com.pingidentity.provisioner.domain.Channel> existingChannels = new HashMap<String, com.pingidentity.provisioner.domain.Channel>();
        org.sourceid.saml20.domain.SpConnection existingConn = null;
        if (isUpdate && (provisionerConfig = (ProvisionerConfig)(existingConn = (connectionManager = MgmtFactory.getConnectionManager()).getSpConnectionBySystemId(apiSpConnection.getId())).getModuleConfiguration(ProvisionerConfig.class)) != null) {
            for (com.pingidentity.provisioner.domain.Channel channel : provisionerConfig.getChannels()) {
                existingChannels.put(channel.getName(), channel);
            }
        }
        for (Channel apiChannel : provisionApiSettings.getChannels()) {
            com.pingidentity.provisioner.domain.Channel domainChannel = new com.pingidentity.provisioner.domain.Channel();
            this.channelTranslator.apiToDomain(apiChannel, domainChannel, provisionApiSettings.getType(), schemaAttributes);
            com.pingidentity.provisioner.domain.Channel existingChannel = (com.pingidentity.provisioner.domain.Channel)existingChannels.get(apiChannel.getName());
            if (existingChannel == null) {
                String type = provisionApiSettings.getType();
                SaasProvisionerPlugin pluginInstance = SaasPluginManager.getInstance().getPluginInstance(type);
                SimpleFieldList simpleFieldList = SaasTargetValidator.buildSimpleFieldList(provisionApiSettings.getTargetSettings());
                SaasTarget saasTarget = new SaasTarget(pluginInstance.getId(), simpleFieldList);
                try {
                    String userNameFieldCode = FieldInfoManager.getInstance().getSaasUsernameFieldCode(saasTarget);
                    domainChannel.setSaasUsernameFieldCode(userNameFieldCode);
                }
                catch (SaasException e) {
                    throw new RuntimeException("Error in getting the FieldInfo from Saas Driver", e);
                }
            } else {
                domainChannel.setId(existingChannel.getId());
                domainChannel.setSaasUsernameFieldCode(existingChannel.getSaasUsernameFieldCode());
            }
            provisioningConfig.addChannel(domainChannel);
        }
        if (isUpdate) {
            ArrayList<Object> domainModules = new ArrayList<Object>();
            for (ConnectionModuleConfiguration moduleConfiguration : existingConn.getConnectionModuleConfigurations()) {
                if (moduleConfiguration.getModuleId().equals(provisioningConfig.getModuleId())) {
                    domainModules.add(provisioningConfig);
                    continue;
                }
                domainModules.add(moduleConfiguration);
            }
            domainConnection.setConnectionModuleConfigurations(domainModules);
        } else {
            domainConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provisioningConfig);
        }
    }
}

