/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.RedirectValidationLocalSettings;
import com.pingidentity.admin.api.model.RedirectValidationPartnerSettings;
import com.pingidentity.admin.api.model.RedirectValidationSettings;
import com.pingidentity.admin.api.model.RedirectValidationSettingsUriAllowlistEntry;
import com.pingidentity.admin.api.model.RedirectValidationSettingsWhitelistEntry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.domain.RedirectValidationUriAllowlistEntry;
import org.sourceid.saml20.domain.RedirectValidationWhitelistEntry;

public class RedirectValidationSettingsTranslator {
    private RedirectValidationSettingsTranslator() {
    }

    public static RedirectValidationSettings domainToApi(List<RedirectValidationWhitelistEntry> domainWhitelist, List<RedirectValidationUriAllowlistEntry> domainUriAllowlist, boolean enableTargetResourceValidationForSSO, boolean enableTargetResourceValidationForSLO, boolean enableInErrorResourceValidation, boolean enableTargetResourceValidationForIdpDiscovery, boolean enableWreplyValidationSLO) {
        RedirectValidationSettings redirectValidationSettings = new RedirectValidationSettings();
        RedirectValidationLocalSettings localSettings = new RedirectValidationLocalSettings();
        RedirectValidationPartnerSettings partnerSettings = new RedirectValidationPartnerSettings();
        redirectValidationSettings.setRedirectValidationLocalSettings(localSettings);
        redirectValidationSettings.setRedirectValidationPartnerSettings(partnerSettings);
        localSettings.setEnableTargetResourceValidationForSSO(enableTargetResourceValidationForSSO);
        localSettings.setEnableTargetResourceValidationForSLO(enableTargetResourceValidationForSLO);
        localSettings.setEnableInErrorResourceValidation(enableInErrorResourceValidation);
        localSettings.setEnableTargetResourceValidationForIdpDiscovery(enableTargetResourceValidationForIdpDiscovery);
        partnerSettings.setEnableWreplyValidationSLO(enableWreplyValidationSLO);
        ArrayList<RedirectValidationSettingsWhitelistEntry> apiWhitelist = new ArrayList<RedirectValidationSettingsWhitelistEntry>(domainWhitelist.size());
        domainWhitelist.forEach(entry -> {
            RedirectValidationSettingsWhitelistEntry redirectValidationSettingsWhitelistEntry = new RedirectValidationSettingsWhitelistEntry();
            redirectValidationSettingsWhitelistEntry.setRequireHttps(entry.isRequireHttps());
            redirectValidationSettingsWhitelistEntry.setValidDomain(entry.getValidDomain());
            redirectValidationSettingsWhitelistEntry.setValidPath(entry.getValidPath());
            redirectValidationSettingsWhitelistEntry.setAllowQueryAndFragment(entry.isAllowQueryAndFragment());
            redirectValidationSettingsWhitelistEntry.setTargetResourceSSO(entry.isTargetResourceSSO());
            redirectValidationSettingsWhitelistEntry.setTargetResourceSLO(entry.isTargetResourceSLO());
            redirectValidationSettingsWhitelistEntry.setInErrorResource(entry.isInErrorResource());
            redirectValidationSettingsWhitelistEntry.setIdpDiscovery(entry.isIdpDiscovery());
            apiWhitelist.add(redirectValidationSettingsWhitelistEntry);
        });
        localSettings.setWhiteList(apiWhitelist);
        ArrayList<RedirectValidationSettingsUriAllowlistEntry> apiUriAllowlist = new ArrayList<RedirectValidationSettingsUriAllowlistEntry>(domainUriAllowlist.size());
        domainUriAllowlist.forEach(entry -> {
            RedirectValidationSettingsUriAllowlistEntry redirectValidationSettingsUriAllowlistEntry = new RedirectValidationSettingsUriAllowlistEntry();
            redirectValidationSettingsUriAllowlistEntry.setValidUri(entry.getValidUri());
            redirectValidationSettingsUriAllowlistEntry.setAllowQueryAndFragment(entry.isAllowQueryAndFragment());
            redirectValidationSettingsUriAllowlistEntry.setTargetResourceSSO(entry.isTargetResourceSSO());
            redirectValidationSettingsUriAllowlistEntry.setTargetResourceSLO(entry.isTargetResourceSLO());
            redirectValidationSettingsUriAllowlistEntry.setInErrorResource(entry.isInErrorResource());
            redirectValidationSettingsUriAllowlistEntry.setIdpDiscovery(entry.isIdpDiscovery());
            apiUriAllowlist.add(redirectValidationSettingsUriAllowlistEntry);
        });
        localSettings.setUriAllowList(apiUriAllowlist);
        return redirectValidationSettings;
    }

    public static List<RedirectValidationWhitelistEntry> apiToDomainWhitelist(List<RedirectValidationSettingsWhitelistEntry> apiWhitelist) {
        LinkedList<RedirectValidationWhitelistEntry> domainWhitelist = new LinkedList<RedirectValidationWhitelistEntry>();
        for (RedirectValidationSettingsWhitelistEntry apiEntry : apiWhitelist) {
            domainWhitelist.add(new RedirectValidationWhitelistEntry(apiEntry.getValidDomain(), apiEntry.getValidPath(), apiEntry.isAllowQueryAndFragment(), apiEntry.isRequireHttps(), apiEntry.isTargetResourceSSO(), apiEntry.isTargetResourceSLO(), apiEntry.isInErrorResource(), apiEntry.isIdpDiscovery()));
        }
        return domainWhitelist;
    }

    public static List<RedirectValidationUriAllowlistEntry> apiToDomainUriAllowlist(List<RedirectValidationSettingsUriAllowlistEntry> apiUriAllowlist) {
        LinkedList<RedirectValidationUriAllowlistEntry> domainUriAllowlist = new LinkedList<RedirectValidationUriAllowlistEntry>();
        for (RedirectValidationSettingsUriAllowlistEntry apiEntry : apiUriAllowlist) {
            domainUriAllowlist.add(new RedirectValidationUriAllowlistEntry(apiEntry.getValidUri(), apiEntry.isAllowQueryAndFragment(), apiEntry.isTargetResourceSSO(), apiEntry.isTargetResourceSLO(), apiEntry.isInErrorResource(), apiEntry.isIdpDiscovery()));
        }
        return domainUriAllowlist;
    }
}

