/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ContactInfo;
import com.pingidentity.admin.api.model.systemsettings.FederationInfo;
import com.pingidentity.admin.api.model.systemsettings.IdpRole;
import com.pingidentity.admin.api.model.systemsettings.NotificationSettings;
import com.pingidentity.admin.api.model.systemsettings.OAuthRole;
import com.pingidentity.admin.api.model.systemsettings.RolesAndProtocols;
import com.pingidentity.admin.api.model.systemsettings.SAML20Profile;
import com.pingidentity.admin.api.model.systemsettings.ServerSettings;
import com.pingidentity.admin.api.model.systemsettings.SpRole;
import com.pingidentity.admin.api.model.systemsettings.SpSAML20Profile;
import com.pingidentity.pf.admin.rest.translator.CaptchaSettingsTranslator;
import com.pingidentity.pf.admin.rest.translator.EmailServerSettingsTranslator;
import com.pingidentity.pf.admin.rest.translator.FederationInfoTranslator;
import com.pingidentity.pf.admin.rest.translator.NotificationSettingsTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.sourceid.common.Util;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.CaptchaProviderInstance;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.CaptchaProviderPluginManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;
import org.sourceid.saml20.metadata.Role;

public class ServerSettingsTranslator {
    private static final OpenIdConnectProviderPolicyManager POLICY_MGR = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
    private static final ConnectionManager CONNECTION_MGR = MgmtFactory.getConnectionManager();
    private static final AuthzServerManager AUTH_MGR = MgmtFactory.getAuthzServerManager();
    private static final NotificationPublisherPluginManager NOTIFICATION_PUBLISHER_PLUGIN_MGR = MgmtFactory.getNotificationPublisherPluginManager();
    private static final CaptchaProviderPluginManager CAPTCHA_PROVIDER_PLUGIN_MGR = MgmtFactory.getCaptchaProviderPluginManager();
    private final NotificationSettingsTranslator notificationSettingsTranslator;
    private EmailServerSettingsTranslator emailServerSettingsTranslator = new EmailServerSettingsTranslator();
    private CaptchaSettingsTranslator captchaSettingsTranslator = new CaptchaSettingsTranslator();
    private final ValidatorContext validatorContext;

    public ServerSettingsTranslator(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
        this.notificationSettingsTranslator = new NotificationSettingsTranslator(this.validatorContext);
    }

    public ServerSettings domainToApi(LocalSettings localSettings, org.sourceid.saml20.domain.NotificationSettings notificationSettings) {
        ServerSettings serverSettings = new ServerSettings();
        this.populateContactInfoApi(localSettings, serverSettings);
        this.populateNotificationSettingsApi(notificationSettings, serverSettings);
        this.populateRolesAndProtocolsApi(localSettings, serverSettings);
        this.populateFederationInfoApi(localSettings, serverSettings);
        NotificationSenderPluginInstance defaultNotificationPublisherInstance = (NotificationSenderPluginInstance)NOTIFICATION_PUBLISHER_PLUGIN_MGR.getDefaultInstance();
        if (!this.validatorContext.isBulkConfigRequest() && defaultNotificationPublisherInstance != null && "SMTP Notification Publisher".equals(defaultNotificationPublisherInstance.getDescriptor().getType())) {
            this.populateEmailServerSettingsApi(defaultNotificationPublisherInstance.getConfiguration(), serverSettings);
        }
        CaptchaProviderInstance defaultCaptchaProviderInstance = (CaptchaProviderInstance)CAPTCHA_PROVIDER_PLUGIN_MGR.getDefaultInstance();
        if (!this.validatorContext.isBulkConfigRequest() && defaultCaptchaProviderInstance != null && "reCAPTCHA v2 Invisible".equals(defaultCaptchaProviderInstance.getDescriptor().getType())) {
            this.populateCaptchaSettingsApi(defaultCaptchaProviderInstance.getConfiguration(), serverSettings);
        }
        return serverSettings;
    }

    private void populateCaptchaSettingsApi(Configuration configuration, ServerSettings serverSettings) {
        serverSettings.setCaptchaSettings(this.captchaSettingsTranslator.domainToApi(configuration));
    }

    private void populateEmailServerSettingsApi(Configuration configuration, ServerSettings serverSettings) {
        serverSettings.setEmailServers(this.emailServerSettingsTranslator.domainToApi(configuration));
    }

    private void populateFederationInfoApi(LocalSettings localSettings, ServerSettings serverSettings) {
        FederationInfoTranslator translator = new FederationInfoTranslator();
        FederationInfo fedInfo = translator.domainToApi(localSettings);
        serverSettings.setFederationInfo(fedInfo);
    }

    private void populateRolesAndProtocolsApi(LocalSettings localSettings, ServerSettings serverSettings) {
        RolesAndProtocols rolesProtocols = new RolesAndProtocols();
        serverSettings.setRolesAndProtocols(rolesProtocols);
        rolesProtocols.setEnableIdpDiscovery(localSettings.isEnableIdpDiscovery());
        OAuthRole oAuthRole = new OAuthRole();
        rolesProtocols.setoAuthRole(oAuthRole);
        oAuthRole.setEnable(AUTH_MGR.isEnableOAuth());
        oAuthRole.setEnableOpenIdConnect(POLICY_MGR.getPolicy().isEnabled());
        IdpRole idpProviderRole = new IdpRole();
        rolesProtocols.setIdpRole(idpProviderRole);
        idpProviderRole.setEnable(this.disableRole(Role.IDP) ? false : localSettings.isEnableIdP());
        idpProviderRole.setEnableSaml10(localSettings.isEnableSamlOneZeroAp());
        idpProviderRole.setEnableSaml11(localSettings.isEnableSamlOneOneAp());
        idpProviderRole.setEnableWsFed(localSettings.isEnableWsFedIdP());
        idpProviderRole.setEnableWsTrust(localSettings.isEnableWsTrustIdP() || CONNECTION_MGR.isWsTrustStsInUse(Role.SP));
        idpProviderRole.setEnableOutboundProvisioning(localSettings.isEnableOutboundProvisioning());
        SAML20Profile idpSAMLProfile = new SAML20Profile();
        idpProviderRole.setSaml20Profile(idpSAMLProfile);
        idpSAMLProfile.setEnable(localSettings.isEnableSamlIdP());
        SpRole spProviderRole = new SpRole();
        rolesProtocols.setSpRole(spProviderRole);
        spProviderRole.setEnable(this.disableRole(Role.SP) ? false : localSettings.isEnableSP());
        spProviderRole.setEnableSaml10(localSettings.isEnableSamlOneZeroRp());
        spProviderRole.setEnableSaml11(localSettings.isEnableSamlOneOneRp());
        spProviderRole.setEnableWsFed(localSettings.isEnableWsFedSp());
        spProviderRole.setEnableWsTrust(localSettings.isEnableWsTrustSp() || CONNECTION_MGR.isWsTrustStsInUse(Role.IDP));
        spProviderRole.setEnableInboundProvisioning(localSettings.isEnableInboundProvisioning());
        spProviderRole.setEnableOpenIDConnect(localSettings.isEnableOIDCSp());
        SpSAML20Profile spSAMLProfile = new SpSAML20Profile();
        spProviderRole.setSaml20Profile(spSAMLProfile);
        spSAMLProfile.setEnable(localSettings.isEnableSamlSp());
        spSAMLProfile.setEnableXASP(localSettings.isEnableX509Discovery());
    }

    private boolean disableRole(Role role) {
        IdpAdapterManager pluginMgr = Role.IDP == role ? MgmtFactory.getIdpAdapterManager() : MgmtFactory.getSpAdapterManager();
        return Util.isEmpty((Collection)pluginMgr.getInstalledDescriptors());
    }

    private void populateContactInfoApi(LocalSettings localSettings, ServerSettings serverSettings) {
        org.sourceid.saml20.domain.ContactInfo domainContactInfo = localSettings.getContactInfo();
        if (domainContactInfo != null) {
            ContactInfo apiContactInfo = new ContactInfo();
            apiContactInfo.setCompany(domainContactInfo.getCompany());
            apiContactInfo.setEmail(domainContactInfo.getEmail());
            apiContactInfo.setFirstName(domainContactInfo.getFirstName());
            apiContactInfo.setLastName(domainContactInfo.getLastName());
            apiContactInfo.setPhone(domainContactInfo.getPhone());
            serverSettings.setContactInfo(apiContactInfo);
        }
    }

    private void populateNotificationSettingsApi(org.sourceid.saml20.domain.NotificationSettings notificationSettings, ServerSettings serverSettings) {
        serverSettings.setNotifications(this.notificationSettingsTranslator.domainToApi(notificationSettings));
    }

    public void apiToDomain(ServerSettings serverSettings, LocalSettings localSettings, org.sourceid.saml20.domain.NotificationSettings notificationSettings) {
        this.populateContactInfoDomain(serverSettings, localSettings);
        this.populateFederationInfoDomain(serverSettings, localSettings);
        this.populateNotificationSettingsDomain(serverSettings, notificationSettings);
    }

    private void populateNotificationSettingsDomain(ServerSettings serverSettings, org.sourceid.saml20.domain.NotificationSettings domainSettings) {
        NotificationSettings apiSettings = serverSettings.getNotifications();
        if (apiSettings == null) {
            apiSettings = new NotificationSettings();
        }
        this.notificationSettingsTranslator.apiToDomain(apiSettings, domainSettings);
    }

    private void populateFederationInfoDomain(ServerSettings serverSettings, LocalSettings localSettings) {
        FederationInfo fedInfo = serverSettings.getFederationInfo();
        FederationInfoTranslator federationInfoTranslator = new FederationInfoTranslator();
        federationInfoTranslator.apiToDomain(fedInfo, localSettings);
    }

    private void populateContactInfoDomain(ServerSettings serverSettings, LocalSettings localSettings) {
        org.sourceid.saml20.domain.ContactInfo domainContactInfo = new org.sourceid.saml20.domain.ContactInfo();
        ContactInfo contactInfo = serverSettings.getContactInfo();
        domainContactInfo.setCompany(contactInfo.getCompany());
        domainContactInfo.setEmail(contactInfo.getEmail());
        domainContactInfo.setFirstName(contactInfo.getFirstName());
        domainContactInfo.setLastName(contactInfo.getLastName());
        domainContactInfo.setPhone(contactInfo.getPhone());
        localSettings.setContactInfo(domainContactInfo);
    }
}

