/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SigningSettings;
import com.pingidentity.admin.api.model.WsFedTokenType;
import com.pingidentity.crypto.SignatureAlgorithms;
import com.pingidentity.crypto.WsfedJwtSigningAlgorithms;
import java.util.List;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SigningSettingsTranslator {
    public SigningSettings domainToApi(ConnectionBase domainConn) {
        SigningSettings signingSettings = new SigningSettings();
        WsTrustTokenType tokenType = this.getTokenType(domainConn);
        if (domainConn.getSigningKeyAlias() != null) {
            String href = ApiUtil.getResourceUrl("/keyPairs/signing", domainConn.getSigningKeyAlias());
            signingSettings.setSigningKeyPairRef(new ResourceLink(domainConn.getSigningKeyAlias(), href));
        }
        if (domainConn.getAltSigningKeyAliasToCertMap() != null) {
            for (String altSigningKeyAlias : domainConn.getAltSigningKeyAliasToCertMap().keySet()) {
                if (altSigningKeyAlias == null) continue;
                String href = ApiUtil.getResourceUrl("/keyPairs/signing", altSigningKeyAlias);
                signingSettings.addAlternativeSigningKeyPairRefs(new ResourceLink(altSigningKeyAlias, href));
            }
        }
        if (domainConn.getSigningAlgorithm() != null) {
            signingSettings.setAlgorithm(SignatureAlgorithms.getInstance().algUriToNameForRuntime(domainConn.getSigningAlgorithm()));
        }
        if (domainConn.getProtocol() == Protocol.WSFED) {
            signingSettings.setIncludeCertInSignature(null);
            if (tokenType == WsTrustTokenType.JWT) {
                signingSettings.setAlgorithm(WsfedJwtSigningAlgorithms.algToName((String)domainConn.getSigningAlgorithm()));
                signingSettings.setIncludeRawKeyInSignature(null);
            } else {
                signingSettings.setIncludeRawKeyInSignature(domainConn.isIncludeRawKeyInXmlSigs());
            }
        } else {
            signingSettings.setIncludeCertInSignature(domainConn.isIncludeCertInXmlSigs());
            signingSettings.setIncludeRawKeyInSignature(domainConn.isIncludeRawKeyInXmlSigs());
        }
        return signingSettings;
    }

    private WsTrustTokenType getTokenType(ConnectionBase domainConn) {
        SpConnection spConnection;
        if (domainConn instanceof SpConnection && (spConnection = (SpConnection)domainConn).getWsFedSettings() != null) {
            return spConnection.getWsFedSettings().getTokenType();
        }
        return null;
    }

    public void apiToDomain(SigningSettings signingSettings, ConnectionBase domainConn, boolean isWsFed, WsFedTokenType tokenType) {
        List<ResourceLink> apiAlternativeSigningKeyPairList;
        if (signingSettings == null) {
            return;
        }
        if (signingSettings.getSigningKeyPairRef() != null) {
            domainConn.setSigningKeyAlias(signingSettings.getSigningKeyPairRef().getId());
        }
        if ((apiAlternativeSigningKeyPairList = signingSettings.getAlternativeSigningKeyPairRefs()) != null) {
            for (ResourceLink altSigningKeyPairRef : apiAlternativeSigningKeyPairList) {
                domainConn.addAltSigningKeyAlias(altSigningKeyPairRef.getId(), null);
            }
        }
        if (signingSettings.getAlgorithm() != null) {
            domainConn.setSigningAlgorithm(SignatureAlgorithms.getInstance().algNameToUriForRuntime(signingSettings.getAlgorithm()));
            if (isWsFed && tokenType == WsFedTokenType.JWT) {
                domainConn.setSigningAlgorithm(WsfedJwtSigningAlgorithms.nameToAlg((String)signingSettings.getAlgorithm()));
            }
        }
        domainConn.setIncludeCertInXmlSigs(isWsFed || signingSettings.isIncludeCertInSignature() != false);
        if (isWsFed && tokenType == WsFedTokenType.JWT) {
            domainConn.setIncludeRawKeyInXmlSigs(false);
        } else {
            domainConn.setIncludeRawKeyInXmlSigs(signingSettings.isIncludeRawKeyInSignature().booleanValue());
        }
    }
}

