/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.ConnectionTargetType;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.pf.admin.rest.translator.ConnectionMetadataUrlTranslator;
import com.pingidentity.pf.admin.rest.translator.CredentialsTranslator;
import com.pingidentity.pf.admin.rest.translator.ExtendedPropertyValuesTranslator;
import com.pingidentity.pf.admin.rest.translator.GeneralInfoTranslator;
import com.pingidentity.pf.admin.rest.translator.OutboundProvisionTranslator;
import com.pingidentity.pf.admin.rest.translator.SpAttributeQueryTranslator;
import com.pingidentity.pf.admin.rest.translator.SpBrowserSsoTranslator;
import com.pingidentity.pf.admin.rest.translator.SpWsTrustTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.WsFedSpSettings;

public class SpConnectionTranslator {
    private final GeneralInfoTranslator generalInfoTranslator = new GeneralInfoTranslator();
    private final SpBrowserSsoTranslator spBrowserSsoTranslator;
    private final SpAttributeQueryTranslator spAttributeQueryTranslator = new SpAttributeQueryTranslator();
    private final CredentialsTranslator credentialsTranslator;
    private final ConnectionMetadataUrlTranslator metadataUrlTranslator = new ConnectionMetadataUrlTranslator();
    private final SpWsTrustTranslator wsTrustTranslator = new SpWsTrustTranslator();
    private final OutboundProvisionTranslator outboundTranslator = new OutboundProvisionTranslator();
    private final ExtendedPropertyValuesTranslator extendedPropertyTranslator = new ExtendedPropertyValuesTranslator();

    public SpConnectionTranslator(ValidatorContext validatorContext) {
        this.credentialsTranslator = new CredentialsTranslator();
        this.spBrowserSsoTranslator = new SpBrowserSsoTranslator(validatorContext);
    }

    public SpConnectionTranslator(ValidatorRegistry registry, ValidatorContext validatorContext) {
        this.credentialsTranslator = new CredentialsTranslator(registry);
        this.spBrowserSsoTranslator = new SpBrowserSsoTranslator(validatorContext);
    }

    public SpConnection domainToApi(org.sourceid.saml20.domain.SpConnection domainConn) {
        SpConnection apiConn = new SpConnection();
        apiConn.setActive(domainConn.isActive());
        this.generalInfoTranslator.domainToApi((ConnectionBase)domainConn, apiConn);
        this.credentialsTranslator.domainToApi((ConnectionBase)domainConn, apiConn);
        this.spBrowserSsoTranslator.domainToApi(domainConn, apiConn);
        this.spAttributeQueryTranslator.domainToApi(domainConn, apiConn);
        this.metadataUrlTranslator.domainToApi((ConnectionBase)domainConn, apiConn);
        this.wsTrustTranslator.domainToApi(domainConn, apiConn);
        this.outboundTranslator.domainToApi(domainConn, apiConn);
        apiConn.setExtendedProperties(this.extendedPropertyTranslator.domainToApi(domainConn.getExtendedProperties()));
        apiConn.setConnectionTargetType(ConnectionTargetType.fromTargetTypeName(domainConn.getConnectionTargetType()));
        return apiConn;
    }

    public org.sourceid.saml20.domain.SpConnection apiToDomain(SpConnection apiConn, boolean isUpdate) {
        org.sourceid.saml20.domain.SpConnection domainConn = new org.sourceid.saml20.domain.SpConnection();
        if (this.isWsFedConnection(apiConn)) {
            WsFedSpSettings wsFedSettings = new WsFedSpSettings();
            wsFedSettings.setTokenType(apiConn.getSpBrowserSso().getWsFedTokenType().getValue());
            if (apiConn.getSpBrowserSso().getWsTrustVersion() != null) {
                wsFedSettings.setWsTrustVersion(apiConn.getSpBrowserSso().getWsTrustVersion().getVersionNumber());
            }
            domainConn.setWsFedSettings(wsFedSettings);
        }
        domainConn.setActive(apiConn.isActive());
        this.generalInfoTranslator.apiToDomain(apiConn, (ConnectionBase)domainConn);
        this.credentialsTranslator.apiToDomain(apiConn, (ConnectionBase)domainConn);
        this.spBrowserSsoTranslator.apiToDomain(apiConn, domainConn);
        this.spAttributeQueryTranslator.apiToDomain(apiConn, domainConn);
        this.metadataUrlTranslator.apiToDomain(apiConn, (ConnectionBase)domainConn);
        this.wsTrustTranslator.apiToDomain(apiConn, domainConn);
        this.outboundTranslator.apiToDomain(apiConn, domainConn, isUpdate);
        domainConn.setExtendedProperties(this.extendedPropertyTranslator.apiTodomain(apiConn.getExtendedProperties()));
        if (apiConn.getConnectionTargetType() != null) {
            domainConn.setConnectionTargetType(apiConn.getConnectionTargetType().getConnectionTargetTypeName());
        }
        return domainConn;
    }

    private boolean isWsFedConnection(SpConnection apiConn) {
        return apiConn.getBrowserSso() != null && apiConn.getSpBrowserSso().getProtocol() == Protocol.WSFED;
    }
}

