/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.SpWsTrustAttribute;
import com.pingidentity.admin.api.model.SpWsTrustAttributeContract;
import java.util.HashMap;
import java.util.HashSet;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.WsTrustTokenAttributeContract;

public class SpConnectionWsTrustAttributeContractTranslator {
    public void domainToApi(org.sourceid.saml20.domain.SpConnection domainConn, SpConnection apiConn) {
        SpWsTrustAttributeContract apiContract = apiConn.getWsTrust().getAttributeContract();
        WsTrustTokenAttributeContract domainContract = domainConn.getWsTrustSettings().getAttributeContract();
        for (String immutableAttrName : domainContract.getImmutableAttributeNames()) {
            SpWsTrustAttribute immutableAttr = new SpWsTrustAttribute();
            immutableAttr.setName(immutableAttrName);
            apiContract.getCoreAttributes().add(immutableAttr);
        }
        for (String mutableAttrName : domainContract.getMutableAttributeNames()) {
            SpWsTrustAttribute mutableAttr = new SpWsTrustAttribute();
            mutableAttr.setName(mutableAttrName);
            String nameFormat = domainContract.getMutableAttributeNameFormat(mutableAttrName);
            mutableAttr.setNamespace(nameFormat);
            apiContract.getExtendedAttributes().add(mutableAttr);
        }
    }

    public void apiToDomain(SpConnection apiConn, org.sourceid.saml20.domain.SpConnection domainConn) {
        WsTrustFederatedWscSettings domainSettings = domainConn.getWsTrustSettings();
        SpWsTrust settings = apiConn.getWsTrust();
        WsTrustTokenAttributeContract wsTrustAttributeContract = new WsTrustTokenAttributeContract();
        HashSet<String> coreAttributes = new HashSet<String>();
        for (SpWsTrustAttribute coreAttribute : settings.getAttributeContract().getCoreAttributes()) {
            coreAttributes.add(coreAttribute.getName());
        }
        wsTrustAttributeContract.setImmutableAttributeNames(coreAttributes);
        HashSet<String> mutableAttributes = new HashSet<String>();
        HashMap<String, String> mutableAttributesInfo = new HashMap<String, String>();
        for (SpWsTrustAttribute mutableAttribute : settings.getAttributeContract().getExtendedAttributes()) {
            mutableAttributes.add(mutableAttribute.getName());
            mutableAttributesInfo.put(mutableAttribute.getName(), mutableAttribute.getNamespace());
        }
        wsTrustAttributeContract.setMutableAttributeNames(mutableAttributes);
        wsTrustAttributeContract.setMutableAttributesInfo(mutableAttributesInfo);
        domainSettings.setAttributeContract(wsTrustAttributeContract);
    }
}

