/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SpTokenGeneratorMapping;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.TokenPluginAttributeMapping;
import org.sourceid.saml20.domain.WsTrustFederatedWspSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class SpTokenGeneratorMappingTranslator {
    public void domainToApi(Collection<TokenPluginAttributeMapping> domainMappings, List<SpTokenGeneratorMapping> mappings, String defaultMappingId) {
        mappings.clear();
        for (TokenPluginAttributeMapping domainMapping : domainMappings) {
            ResourceLink resourceId = new ResourceLink();
            String id = domainMapping.getPluginId();
            SpTokenGeneratorMapping apiMapping = new SpTokenGeneratorMapping();
            if (id != null) {
                resourceId.setId(id);
                resourceId.setLocation(ApiUtil.getResourceUrl("/sp/tokenGenerators", id));
                if (id.equals(defaultMappingId)) {
                    apiMapping.setDefaultMapping(true);
                }
            }
            apiMapping.setSpTokenGeneratorRef(resourceId);
            mappings.add(apiMapping);
            AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator(id, (PluginManager<?, ?>)MgmtFactory.getTokenGeneratorManager());
            mappingTranslator.domainToApi(domainMapping.getAttributeMapping(), apiMapping);
            if (!domainMapping.isRestrictVirtualServerIds()) continue;
            apiMapping.setRestrictedVirtualEntityIds(domainMapping.getRestrictedVirtualServerIds());
        }
    }

    public void apiToDomain(List<SpTokenGeneratorMapping> mappings, WsTrustFederatedWspSettings wsTrustSettings) {
        ArrayList<TokenPluginAttributeMapping> domainMappings = new ArrayList<TokenPluginAttributeMapping>();
        for (SpTokenGeneratorMapping apiMapping : mappings) {
            TokenPluginAttributeMapping domainMapping = new TokenPluginAttributeMapping();
            domainMappings.add(domainMapping);
            domainMapping.setAttributeMapping(new AttributeMapping());
            String id = apiMapping.getSpTokenGeneratorRef().getId();
            domainMapping.setPluginId(id);
            domainMapping.setRestrictVirtualServerIds(!apiMapping.getRestrictedVirtualEntityIds().isEmpty());
            domainMapping.setRestrictedVirtualServerIds(apiMapping.getRestrictedVirtualEntityIds());
            AttributeMappingTranslator mappingTranslator = new AttributeMappingTranslator();
            mappingTranslator.apiToDomain(apiMapping, domainMapping.getAttributeMapping());
            if (!apiMapping.isDefaultMapping()) continue;
            wsTrustSettings.setDefaultAssertionToTokenMappingsMappingId(id);
        }
        wsTrustSettings.setAssertionToTokenMappings(domainMappings);
    }
}

