/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SpUrlMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.SpAdapterManagerImpl;

public class SpUrlMappingTranslator {
    private final ConnectionManager connectionManager;
    private final PluginManager<?, ?> pluginManager = new SpAdapterManagerImpl();

    public SpUrlMappingTranslator() {
        this.connectionManager = MgmtFactory.getConnectionManager();
    }

    public void apiToDomain(SpUrlMapping apiMapping, UrlToTargetMapping domainMapping) {
        domainMapping.setUrl(apiMapping.getUrl());
        domainMapping.setTargetType(apiMapping.getType().getDomainType());
        if (apiMapping.getType() == SpUrlMapping.TargetUrlSource.SP_ADAPTER) {
            ConfigurablePluginInstance pluginInstance = this.pluginManager.getInstance(apiMapping.getRef().getId());
            domainMapping.setTargetId(pluginInstance.getId());
        } else if (apiMapping.getType() == SpUrlMapping.TargetUrlSource.SP_CONNECTION) {
            SpConnection connection = this.connectionManager.getSpConnectionBySystemId(apiMapping.getRef().getId());
            domainMapping.setTargetId(connection.getId());
        }
    }

    public void domainToApi(UrlToTargetMapping domainMapping, SpUrlMapping apiMapping) {
        apiMapping.setUrl(domainMapping.getUrl());
        String location = ApiUtil.getResourceUrl(apiMapping.getType() == SpUrlMapping.TargetUrlSource.SP_ADAPTER ? "/sp/adapters" : "/idp/spConnections", domainMapping.getTargetId());
        apiMapping.setRef(new ResourceLink(domainMapping.getTargetId(), location));
        apiMapping.setType(SpUrlMapping.TargetUrlSource.fromType(domainMapping.getTargetType()));
    }
}

