/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ProtocolMessageCustomization;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SamlTokenType;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.admin.rest.translator.IdpTokenProcessorMappingTranslator;
import com.pingidentity.pf.admin.rest.translator.MessageCustomizationHookTranslator;
import com.pingidentity.pf.admin.rest.translator.SpConnectionWsTrustAttributeContractTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.sourceid.saml20.domain.AppliesTo;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.WsTrustFederatedWscSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SpWsTrustTranslator {
    private final LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
    private MessageCustomizationHookTranslator messageCutomisationHookTranslator = new MessageCustomizationHookTranslator();

    public void domainToApi(org.sourceid.saml20.domain.SpConnection domainConn, SpConnection apiConn) {
        WsTrustFederatedWscSettings settings = domainConn.getWsTrustSettings();
        if (settings == null || !this.localSettings.isEnableWsTrustIdP()) {
            return;
        }
        SpWsTrust wsTrust = new SpWsTrust();
        apiConn.setWsTrust(wsTrust);
        ArrayList<String> partnerServiceIds = new ArrayList<String>();
        for (AppliesTo appliesTo : settings.getAppliesTo()) {
            partnerServiceIds.add(appliesTo.toString());
        }
        wsTrust.setPartnerServiceIds(partnerServiceIds);
        wsTrust.setGenerateKey(settings.isUseSamlHoK());
        wsTrust.setEncryptSaml2Assertion(settings.isEncryptAssertion());
        wsTrust.setoAuthAssertionProfiles(settings.isEnableOAuthAssertionProfiles());
        wsTrust.setDefaultTokenType(SamlTokenType.getApiType(settings.getTokenType()));
        wsTrust.setMinutesBefore(settings.getAssertionValidityBeforeMinutes());
        wsTrust.setMinutesAfter(settings.getAssertionValidityAfterMinutes());
        ResourceLink resource = new ResourceLink();
        String id = settings.getRequestContractId();
        if (id != null) {
            resource.setId(id);
            resource.setLocation(ApiUtil.getResourceUrl("/idp/stsRequestParametersContracts", id));
            wsTrust.setRequestContractRef(resource);
            wsTrust.setAbortIfNotFulfilledFromRequest(settings.isAbortIfNotFulfilledFromRequest());
        }
        SpConnectionWsTrustAttributeContractTranslator attributeContractTranslator = new SpConnectionWsTrustAttributeContractTranslator();
        attributeContractTranslator.domainToApi(domainConn, apiConn);
        IdpTokenProcessorMappingTranslator tokenProcessorMappingTranslator = new IdpTokenProcessorMappingTranslator();
        tokenProcessorMappingTranslator.domainToApi(settings.getTokenToAssertionMappings(), wsTrust.getTokenProcessorMappings());
        Map domainMessageCustomisation = domainConn.getWsTrustMessageCustomizationHooks();
        if (domainMessageCustomisation != null && !domainMessageCustomisation.isEmpty() && ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            wsTrust.setMessageCustomizations(new ArrayList<ProtocolMessageCustomization>());
            this.messageCutomisationHookTranslator.domainToApi(domainConn.getWsTrustMessageCustomizationHooks(), wsTrust.getMessageCustomizations());
        }
    }

    public void apiToDomain(SpConnection apiConn, org.sourceid.saml20.domain.SpConnection domainConn) {
        SpWsTrust settings = apiConn.getWsTrust();
        if (settings == null) {
            return;
        }
        WsTrustFederatedWscSettings domainSettings = new WsTrustFederatedWscSettings();
        domainConn.setWsTrustSettings(domainSettings);
        if (!settings.getPartnerServiceIds().isEmpty()) {
            HashSet<AppliesTo> convertedAppliesTo = new HashSet<AppliesTo>();
            for (String appliesToStr : settings.getPartnerServiceIds()) {
                convertedAppliesTo.add(new AppliesTo(appliesToStr));
            }
            domainSettings.setAppliesTo(convertedAppliesTo);
        }
        domainSettings.setUseSamlHoK(settings.isGenerateKey());
        domainSettings.setEncryptAssertion(settings.isEncryptSaml2Assertion());
        domainSettings.setEnableOAuthAssertionProfiles(settings.isoAuthAssertionProfiles());
        domainSettings.setTokenType(settings.getDefaultTokenType().getId());
        domainSettings.setAssertionValidityBeforeMinutes(settings.getMinutesBefore());
        domainSettings.setAssertionValidityAfterMinutes(settings.getMinutesAfter());
        if (settings.getRequestContractRef() != null) {
            domainSettings.setRequestContractId(settings.getRequestContractRef().getId());
            domainSettings.setAbortIfNotFulfilledFromRequest(settings.isAbortIfNotFulfilledFromRequest() == null ? false : settings.isAbortIfNotFulfilledFromRequest());
        }
        SpConnectionWsTrustAttributeContractTranslator attributeContractTranslator = new SpConnectionWsTrustAttributeContractTranslator();
        attributeContractTranslator.apiToDomain(apiConn, domainConn);
        IdpTokenProcessorMappingTranslator tokenProcessorMappingTranslator = new IdpTokenProcessorMappingTranslator();
        tokenProcessorMappingTranslator.apiToDomain(settings.getTokenProcessorMappings(), domainSettings);
        this.messageCutomisationHookTranslator.apiToDomain(settings.getMessageCustomizations(), domainConn.getWsTrustMessageCustomizationHooks());
    }
}

