/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotificationManager;
import com.pingidentity.dependency.error.DependencyErrorManager;
import com.pingidentity.pf.admin.rest.translator.internal.model.Notification;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.util.InitialSetupConfigStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;

public class NotificationsTranslator {
    private static final String PING_ONE_IDENTITY_REPOSITORY_ID = "pingOneIdentityRepository";
    private static final String PING_ONE_IDENTITY_REPOSITORY_LABEL = "Update PingOne Identity Repository";
    private static final String PING_ONE_IDENTITY_REPOSITORY_DESCRIPTION = "You've made some changes that may affect your connection with PingOne for Enterprise. Visit the Update PingOne Identity Repository page to review your options.";
    private static final String DEPENDENCY_ERRORS_ID = "dependencyErrors";
    private static final String DEPENDENCY_ERRORS_LABEL = "Dependency Errors";
    private static final String DEPENDENCY_ERRORS_DESCRIPTION = "Configuration errors have occurred. Visit the Dependency Errors page to see the component.";
    private static final String MIXED_VERSION_ID = "mixedVersion";
    private static final String MIXED_VERSION_LABEL = "Mixed Maintenance Releases";
    private static final String MIXED_VERSION_DESCRIPTION = "The cluster is running more than one version of PingFederate. Visit the Cluster Management page to see the versions.";
    private static final String CERTIFICATE_WARNING_ID = "certificateExpiryWarnings";
    private static final String CERTIFICATE_WARNING_LABEL = "Certificate Expiry Warnings";
    private static final String CERTIFICATE_WARNING_DESCRIPTION = "Certificates are expiring or have recently expired. Visit the Certificate Expiry Warnings page to manage these warnings.";
    private final AdministrativeUser currentUser;
    private final InitialSetupConfigStore licenseConfigStore = new InitialSetupConfigStore();

    public NotificationsTranslator(AdministrativeUser currentUser) {
        this.currentUser = currentUser;
    }

    public List<Notification> getNotifications() {
        LinkedList<Notification> notifications = new LinkedList<Notification>();
        if (this.currentUser.isAdmin()) {
            notifications.addAll(this.getDependencyErrorsNotification());
            notifications.addAll(this.getMixedMaintenanceReleaseNotification());
            notifications.addAll(this.getPingOneUpdatePendingNotification());
        }
        if (this.currentUser.isCryptoManager() || this.currentUser.isAuditor()) {
            notifications.addAll(this.getCertificateErrorsNotification());
        }
        return notifications;
    }

    private List<Notification> getMixedMaintenanceReleaseNotification() {
        if (this.isMixedVersionCluster()) {
            Notification notification = new Notification(MIXED_VERSION_ID, MIXED_VERSION_LABEL, MIXED_VERSION_DESCRIPTION);
            return Collections.singletonList(notification);
        }
        return Collections.emptyList();
    }

    public boolean isMixedVersionCluster() {
        Mediator mediator = MgmtFactory.getMediator();
        if (mediator.isDistributable() && mediator.isConsole() && this.licenseConfigStore.hasAcceptedLicenseAgreement()) {
            NodeIndexRegistry idxReg = (NodeIndexRegistry)GlobalRegistry.getService(NodeIndexRegistry.class);
            List nodes = idxReg.getNodes();
            HashSet<String> version = new HashSet<String>();
            for (Node node : nodes) {
                version.add(node.getVersion());
                if (version.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private List<Notification> getDependencyErrorsNotification() {
        DependencyErrorManager dependencyErrorManager = MgmtFactory.getDependencyErrorManager();
        if (dependencyErrorManager.errorsExist()) {
            Notification notification = new Notification(DEPENDENCY_ERRORS_ID, DEPENDENCY_ERRORS_LABEL, DEPENDENCY_ERRORS_DESCRIPTION);
            return Collections.singletonList(notification);
        }
        return Collections.emptyList();
    }

    private List<Notification> getCertificateErrorsNotification() {
        CertificateExpiryNotificationManager notificationManager = MgmtFactory.getCertificateExpiryNotificationManager();
        if (notificationManager.certificateExpiryNotificationExist()) {
            Notification notification = new Notification(CERTIFICATE_WARNING_ID, CERTIFICATE_WARNING_LABEL, CERTIFICATE_WARNING_DESCRIPTION);
            return Collections.singletonList(notification);
        }
        return Collections.emptyList();
    }

    private List<Notification> getPingOneUpdatePendingNotification() {
        if (this.isPingOneUpdatePending()) {
            Notification notification = new Notification(PING_ONE_IDENTITY_REPOSITORY_ID, PING_ONE_IDENTITY_REPOSITORY_LABEL, PING_ONE_IDENTITY_REPOSITORY_DESCRIPTION);
            return Collections.singletonList(notification);
        }
        return Collections.emptyList();
    }

    private boolean isPingOneUpdatePending() {
        PingOneAdminService service = MgmtFactory.getPingOneAdminService();
        SpConnection spConn = service.getSpConnectionFactory().getManagedSpConnection();
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return localSettings.isEnableSamlIdP() && service.isAssociated() && spConn != null && spConn.isActive() && service.getSpConnectionFactory().isMetadataUploadPending();
    }
}

