/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.pf.admin.rest.translator.internal.constants.Contexts;
import com.pingidentity.sdk.PingFederateProperties;
import com.pingidentity.util.documentation.DocumentationHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.MenuAuthUtil;

public class PFInfoTranslator {
    private static final String HELP_BASE_URL = "helpBaseUrl";
    private final boolean accountManagementVisible;
    private final boolean adminVisible;

    public PFInfoTranslator() {
        this.accountManagementVisible = false;
        this.adminVisible = false;
    }

    public PFInfoTranslator(AdministrativeUser user) {
        this.accountManagementVisible = MenuAuthUtil.isAcctManagementVisible((AdministrativeUser)user);
        this.adminVisible = MenuAuthUtil.isAdminVisible((AdministrativeUser)user);
    }

    public String getEnvironment() {
        return PropertyInfo.getPingFederateEnvironment();
    }

    public String getConsoleTitle() {
        return PingFederateProperties.getAdminConsolePageTitle();
    }

    public boolean getShowBackground() {
        return PingFederateProperties.getShowBackgroundImage();
    }

    public String getPingOneAdminUrlRegion() {
        return PingFederateProperties.getPingOneAdminUrlRegion();
    }

    public String getPingOneAdminUrlEnvironmentId() {
        return PingFederateProperties.getPingOneAdminUrlEnvironmentId();
    }

    public Map<String, String> getAllDocContextLinks() {
        HashMap<String, String> links = new HashMap<String, String>();
        links.put(HELP_BASE_URL, DocumentationHelper.getDocumentationUrl());
        for (String context : Contexts.getAllLinkContexts()) {
            links.put(context, DocumentationHelper.getDocumentationUrl((String)context));
        }
        return links;
    }

    public String getVersion() {
        return PropertyInfo.getPingFederateVersion();
    }

    public boolean isAccountManagementVisible() {
        return this.accountManagementVisible;
    }

    public boolean isAdminVisible() {
        return this.adminVisible;
    }

    public String getTimezone() {
        return TimeZone.getDefault().getID();
    }

    public boolean getIsLog4j2Upgraded() {
        return MgmtFactory.getLogSettingsManager().isLog4j2Upgraded();
    }
}

