/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal.navigation.security;

import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavReactLeaf;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavSecondary;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavTapestryLeaf;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.MenuAuthUtil;
import org.sourceid.util.license.PingLicense;

public class CertificateAndKey
extends NavSecondary {
    private static final String LEAF_ID_PREFIX = "security/certificate-and-key-management/";
    private static final String TOKEN_SIGNING_KEY_ID = "security/certificate-and-key-management/token-signing-keys";
    private static final String CONFIGURATION_ENCRYPTION_KEYS_ID = "security/certificate-and-key-management/configuration-encryption-keys";

    public CertificateAndKey(AdministrativeUser currentUser, PingLicense license) {
        super(currentUser, license, "Certificate & Key Management", "Certificate & Key Management", "pf-security-certificate-key-mgmt");
    }

    @Override
    public List<NavNode> getChildren() {
        ArrayList<NavNode> children = new ArrayList<NavNode>();
        if (this.getCurrentUser().isAuditor() || this.getCurrentUser().isCryptoManager()) {
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "dsigSigningCerts", "Signing & Decryption Keys & Certificates"));
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "certificates", "Trusted CAs"));
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "serverCerts", "SSL Server Certificates"));
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "sslClientCerts", "SSL Client Keys & Certificates"));
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "jwksEndpoint", "OAuth & OpenID Connect Keys"));
            children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), TOKEN_SIGNING_KEY_ID, "Token Signing Keys"));
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "certificateRevocation", "Certificate Revocation Checking"));
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "partnerMetadataUrls", "Partner Metadata URLs"));
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser())) {
            children.add(new NavTapestryLeaf(this.getCurrentUser(), this.getLicense(), "systemKeys", "System Keys"));
            children.add(new NavReactLeaf(this.getCurrentUser(), this.getLicense(), CONFIGURATION_ENCRYPTION_KEYS_ID, "Configuration Encryption Keys"));
        }
        return children;
    }
}

