/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.internal.navigation.system;

import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavNode;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.NavPrimary;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.AdminApi;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.DataAndCredentialStores;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.ExternalSystems;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.MonitoringAndNotifications;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.OAuthSettings;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.ProtocolMetadata;
import com.pingidentity.pf.admin.rest.translator.internal.navigation.system.Server;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.saml20.domain.util.MenuAuthUtil;
import org.sourceid.util.license.PingLicense;

public class System
extends NavPrimary {
    public System(AdministrativeUser currentUser, PingLicense license) {
        super(currentUser, license, "system", "System");
    }

    @Override
    public List<NavNode> getChildren() {
        ArrayList<NavNode> children = new ArrayList<NavNode>();
        if (MenuAuthUtil.isPassiveAdminNode()) {
            children.add(new Server(this.getCurrentUser(), this.getLicense()));
            return children;
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser())) {
            children.add(new DataAndCredentialStores(this.getCurrentUser(), this.getLicense()));
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser()) || this.getCurrentUser().isAdminManager() || this.getCurrentUser().isCryptoManager()) {
            children.add(new Server(this.getCurrentUser(), this.getLicense()));
        }
        if (MenuAuthUtil.isAdminVisible((AdministrativeUser)this.getCurrentUser())) {
            children.add(new OAuthSettings(this.getCurrentUser(), this.getLicense()));
            children.add(new ExternalSystems(this.getCurrentUser(), this.getLicense()));
            children.add(new MonitoringAndNotifications(this.getCurrentUser(), this.getLicense()));
            children.add(new ProtocolMetadata(this.getCurrentUser(), this.getLicense()));
            children.add(new AdminApi(this.getCurrentUser(), this.getLicense()));
        }
        return children;
    }
}

