/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.localidentity;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.DataStoreType;
import com.pingidentity.admin.api.model.LdapSearchScope;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.localidentity.DataStoreAttribute;
import com.pingidentity.admin.api.model.localidentity.DataStoreConfig;
import com.pingidentity.admin.api.model.localidentity.LdapDataStoreAttribute;
import com.pingidentity.admin.api.model.localidentity.LdapDataStoreConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;

public class LocalIdentityDataStoreConfigTranslator {
    public DataStoreConfig domainToApi(com.pingidentity.localidentity.DataStoreConfig domainDataStoreConfig) {
        LdapDataStoreConfig apiDataStoreConfig = null;
        switch (DataSource.DSType.fromName((String)domainDataStoreConfig.getType())) {
            case LDAP: {
                apiDataStoreConfig = new LdapDataStoreConfig();
                LdapAttributeSource domainLdapAttrSource = (LdapAttributeSource)domainDataStoreConfig.getAttributeSource();
                ResourceLink ldapDataSourceResourceLink = LocalIdentityDataStoreConfigTranslator.getResourceLinkFromDomain((AttributeSource)domainLdapAttrSource);
                apiDataStoreConfig.setDataStoreRef(ldapDataSourceResourceLink);
                this.attributeSourceDomainToApi(domainLdapAttrSource, apiDataStoreConfig);
                HashMap<String, DataStoreAttribute> apiDataStoreMapping = new HashMap<String, DataStoreAttribute>();
                Map domainDataStoreMapping = domainDataStoreConfig.getDataStoreMapping();
                for (Map.Entry entry : domainDataStoreMapping.entrySet()) {
                    apiDataStoreMapping.put((String)entry.getKey(), this.domainToApiDataStoreAttributeMapping((com.pingidentity.localidentity.DataStoreAttribute)entry.getValue()));
                }
                apiDataStoreConfig.setDataStoreMapping(apiDataStoreMapping);
                break;
            }
        }
        return apiDataStoreConfig;
    }

    public com.pingidentity.localidentity.DataStoreConfig apiToDomain(DataStoreConfig apiDataStoreConfig) {
        DataStoreType dataStoreType = apiDataStoreConfig.getType();
        com.pingidentity.localidentity.LdapDataStoreConfig domainDataStoreConfig = null;
        switch (dataStoreType) {
            case LDAP: {
                LdapAttributeSource domainLdapAttributeSrc = new LdapAttributeSource();
                this.ldapAttributeSourceApiToDomain((LdapDataStoreConfig)apiDataStoreConfig, domainLdapAttributeSrc);
                domainDataStoreConfig = new com.pingidentity.localidentity.LdapDataStoreConfig((AttributeSource)domainLdapAttributeSrc);
                HashMap<String, com.pingidentity.localidentity.DataStoreAttribute> domLdapDataStoreAttributeMapping = new HashMap<String, com.pingidentity.localidentity.DataStoreAttribute>();
                Map<String, DataStoreAttribute> apiLdapDataStoreAttributeMapping = apiDataStoreConfig.getDataStoreMapping();
                for (Map.Entry<String, DataStoreAttribute> entry : apiLdapDataStoreAttributeMapping.entrySet()) {
                    domLdapDataStoreAttributeMapping.put(entry.getKey(), this.apiToDomainDataStoreAttributeMapping(entry.getValue()));
                }
                domainDataStoreConfig.setDataStoreMapping(domLdapDataStoreAttributeMapping);
                break;
            }
        }
        return domainDataStoreConfig;
    }

    private LdapDataStoreAttribute domainToApiDataStoreAttributeMapping(com.pingidentity.localidentity.DataStoreAttribute domainDataStoreAttribute) {
        String name = domainDataStoreAttribute.getName();
        Map metadata = domainDataStoreAttribute.getMetadata();
        return new LdapDataStoreAttribute(name, metadata);
    }

    private com.pingidentity.localidentity.DataStoreAttribute apiToDomainDataStoreAttributeMapping(DataStoreAttribute apiDataStoreAttribute) {
        String name = apiDataStoreAttribute.getName();
        Map<String, String> metadata = apiDataStoreAttribute.getMetadata();
        return new com.pingidentity.localidentity.LdapDataStoreAttribute(name, metadata);
    }

    private static ResourceLink getResourceLinkFromDomain(AttributeSource domainSource) {
        ResourceLink dsRef = new ResourceLink();
        dsRef.setId(domainSource.getDataSourceId());
        dsRef.setLocation(ApiUtil.getResourceUrl("/dataStores", domainSource.getDataSourceId()));
        return dsRef;
    }

    private void attributeSourceDomainToApi(LdapAttributeSource domainLdapAttrSource, LdapDataStoreConfig apiDataStoreConfig) {
        apiDataStoreConfig.setBaseDn(domainLdapAttrSource.getParameter("search_base"));
        apiDataStoreConfig.setCreatePattern(domainLdapAttrSource.getParameter("create_pattern"));
        apiDataStoreConfig.setObjectClass(domainLdapAttrSource.getParameter("object_class"));
        if (domainLdapAttrSource.getParameterMap().containsKey("auxiliary_object_classes")) {
            apiDataStoreConfig.setAuxiliaryObjectClasses(Arrays.asList(StringUtils.split((String)domainLdapAttrSource.getParameter("auxiliary_object_classes"), (char)',')));
        }
    }

    private void ldapAttributeSourceApiToDomain(LdapDataStoreConfig apiDataStoreConfig, LdapAttributeSource domainLdapAttrSource) {
        domainLdapAttrSource.setDataSourceId(apiDataStoreConfig.getDataStoreRef().getId());
        domainLdapAttrSource.setParameter("search_base", apiDataStoreConfig.getBaseDn());
        domainLdapAttrSource.setParameter("create_pattern", apiDataStoreConfig.getCreatePattern());
        domainLdapAttrSource.setParameter("object_class", apiDataStoreConfig.getObjectClass());
        if (CollectionUtils.isNotEmpty(apiDataStoreConfig.getAuxiliaryObjectClasses())) {
            domainLdapAttrSource.setParameter("auxiliary_object_classes", StringUtils.join(apiDataStoreConfig.getAuxiliaryObjectClasses(), (char)','));
        }
        domainLdapAttrSource.setParameter("search_scope", LdapSearchScope.ONE_LEVEL.toString());
    }
}

