/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.admin.rest.translator.oauth;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.oauth.AccessTokenMapping;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingContext;
import com.pingidentity.admin.api.model.oauth.AccessTokenMappingType;
import com.pingidentity.pf.admin.rest.translator.AttributeMappingTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ClientCredentialToAccessTokenMappingTranslator {
    private final AttributeMappingTranslator attributeMappingTranslator;
    private final BearerAccessTokenMgmtPluginManager bearerAccessTokenMgmtPluginManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();

    public ClientCredentialToAccessTokenMappingTranslator() {
        HashMap<SourceType, String> additionalPrefixes = new HashMap<SourceType, String>();
        this.attributeMappingTranslator = new AttributeMappingTranslator(additionalPrefixes);
    }

    public ClientCredentialAccessTokenMapping apiToDomain(AccessTokenMapping apiMapping) {
        ClientCredentialAccessTokenMapping domainMapping = new ClientCredentialAccessTokenMapping();
        AccessTokenMappingType type = apiMapping.getContext().getType();
        String contextId = AccessTokenMappingType.toContextId(type, null);
        domainMapping.setContextId(contextId);
        domainMapping.setTokenManagerId(apiMapping.getAccessTokenManagerRef().getId());
        this.attributeMappingTranslator.apiToDomain(apiMapping, (AttributeMapping)domainMapping);
        return domainMapping;
    }

    public List<AccessTokenMapping> domainToApi(Collection<ClientCredentialAccessTokenMapping> domainMappings) {
        ArrayList<AccessTokenMapping> apiMappings = new ArrayList<AccessTokenMapping>();
        for (ClientCredentialAccessTokenMapping domainMapping : domainMappings) {
            apiMappings.add(this.domainToApi(domainMapping));
        }
        return apiMappings;
    }

    public AccessTokenMapping domainToApi(ClientCredentialAccessTokenMapping domainMapping) {
        AccessTokenMapping apiMapping = new AccessTokenMapping();
        apiMapping.setId(domainMapping.getId());
        String contextId = domainMapping.getContextId();
        AccessTokenMappingType type = AccessTokenMappingType.fromContextId(contextId);
        AccessTokenMappingContext context = new AccessTokenMappingContext();
        context.setType(type);
        apiMapping.setContext(context);
        String tokenManagerId = domainMapping.getTokenManagerId();
        ResourceLink tokenManagerRef = new ResourceLink(tokenManagerId, ApiUtil.getResourceUrl("/oauth/accessTokenManagers", tokenManagerId));
        apiMapping.setAccessTokenManagerRef(tokenManagerRef);
        BearerAccessTokenMgmtPluginInstance tokenManagerInstance = (BearerAccessTokenMgmtPluginInstance)this.bearerAccessTokenMgmtPluginManager.getInstance(tokenManagerId);
        Set attributeContract = tokenManagerInstance.getAttributeContract().getAllAttributeNames();
        attributeContract.addAll(tokenManagerInstance.getTokenEndpointAttributeContract().getAllAttributeNames());
        this.attributeMappingTranslator.domainToApi((AttributeMapping)domainMapping, apiMapping, (Set<String>)attributeContract, false);
        return apiMapping;
    }
}

